#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * McSvcAccountManager:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _McSvcAccountManager McSvcAccountManager;

/**
 * McSvcAccountManagerClass:
 *
 * The class of McSvcAccountManager.
 */
typedef struct _McSvcAccountManagerClass McSvcAccountManagerClass;

GType mc_svc_account_manager_get_type (void);
#define MC_TYPE_SVC_ACCOUNT_MANAGER \
  (mc_svc_account_manager_get_type ())
#define MC_SVC_ACCOUNT_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MC_TYPE_SVC_ACCOUNT_MANAGER, McSvcAccountManager))
#define MC_IS_SVC_ACCOUNT_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MC_TYPE_SVC_ACCOUNT_MANAGER))
#define MC_SVC_ACCOUNT_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MC_TYPE_SVC_ACCOUNT_MANAGER, McSvcAccountManagerClass))


typedef void (*mc_svc_account_manager_create_account_impl) (McSvcAccountManager *self,
    const gchar *in_Connection_Manager,
    const gchar *in_Protocol,
    const gchar *in_Display_Name,
    GHashTable *in_Parameters,
    DBusGMethodInvocation *context);
void mc_svc_account_manager_implement_create_account (McSvcAccountManagerClass *klass, mc_svc_account_manager_create_account_impl impl);
/**
 * mc_svc_account_manager_return_from_create_account:
 * @context: The D-Bus method invocation context
 * @out_Account: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mc_svc_account_manager_return_from_create_account (DBusGMethodInvocation *context,
    const gchar *out_Account);
static inline void
mc_svc_account_manager_return_from_create_account (DBusGMethodInvocation *context,
    const gchar *out_Account)
{
  dbus_g_method_return (context,
      out_Account);
}

void mc_svc_account_manager_emit_account_removed (gpointer instance,
    const gchar *arg_Account);
void mc_svc_account_manager_emit_account_validity_changed (gpointer instance,
    const gchar *arg_Account,
    gboolean arg_Valid);


G_END_DECLS
