#!/usr/bin/perl
#
# $Id: DataStore.pm,v 1.10 2000/04/30 20:09:03 levine Exp $
#
# Copyright (C) 2000  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################

package PortScan::DataStore;
 
use strict;
no strict 'refs';


use PortScan::ScanSet;
use PortScan::ScanContext;


sub new
{
    my ($type) = @_;

    my $self = 
    {
	user_properties => {},	
    };

    bless $self, $type;

    return $self;
}


sub retrieve_scanset
{
    my  $tag = shift;


#    ($scanset) || undef
}

sub put_scanset
{
    my ($self, $scanset) = @_;
}


sub create_default_type
{
    my $t = &PortScan::ScanContext::default_data_store_type();

    eval "use $t";
    my $ds = new $t;

    $ds->set_user_properties(&PortScan::ScanContext::default_data_store_props() );

    $ds;
}

sub data_store_for
{
    my $tag = shift;
    
    $tag = prepare_tag($tag);

    if ($tag =~ /^:/)		# tag starts with ':', treat as an opaque data source
    {
	$tag =~ s/^://g;
	return ($tag, create_default_type());
    }
    else			# treat tag as a filename of an nmap file
    {
	use PortScan::NmapFile;
	my $ds = new PortScan::NmapFile;

	$ds->attach_file($tag);
	$ds->attach_metafile($tag . ".info");
	return ($tag, $ds);
    }
}


sub prepare_tag
{
    my $t = shift;
    my $host = `hostname`; chomp $host;

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
    $year += 1900;
    $mon += 1;

    $sec = sprintf "%02d", $sec;
    $min = sprintf "%02d", $min;
    $hour = sprintf "%02d", $hour;

    $t =~ s/%S/$sec/g;
    $t =~ s/%M/$min/g;
    $t =~ s/%H/$hour/g;

    $mday = sprintf "%02d", $mday;
    $mon = sprintf "%02d", $mon;
    $year = sprintf "%04d", $year;
    $wday = sprintf "%d", $wday;
    $yday = sprintf "%03d", $yday;

    $t =~ s/%D/$mday/g;
    $t =~ s/%m/$mon/g;
    $t =~ s/%Y/$year/g;

    $t =~ s/%j/$yday/g;
    $t =~ s/%w/$wday/g;

    $t =~ s/%F/$host/g;

    $t;
}

sub set_user_properties 
{
    my ($self, $propstring) = @_;
    $self->{user_properties} = split_property_string($propstring);
}

sub split_property_string
{
    my $prop_string = shift;
    $prop_string =~ s/,/=/g;

    return { split /=/, $prop_string }
}

sub get_user_property
{
    my ($self, $k) = @_;
    return $self->{user_properties}->{$k};
}

sub enumerate_scansets
{
# returns a listref of tags

# $[list of scansets] || undef
}

sub tests
{
    print prepare_tag "sec %S\n";
    print prepare_tag "min %M\n";
    print prepare_tag "hour %H\n";

    print prepare_tag "mday %D\n";
    print prepare_tag "mon %m\n";
    print prepare_tag "year %Y\n";

    print prepare_tag "yday %j\n";
    print prepare_tag "wday %w\n";

    print prepare_tag "host %F\n";
}

1;









