/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef NAMEDPROPS_H
#define NAMEDPROPS_H

//MNID_ID properties: 
// In PSETID_Address
#define dispidFileAs						0x8005	//PT_STRING8
#define dispidFileAsSelection				0x8006	//PT_LONG
#define dispidHomeAddress					0x801A	//PT_STRING8
#define dispidBusinessAddress				0x801B	//PT_STRING8
#define dispidOtherAddress					0x801C	//PT_STRING8
#define dispidSelectedMailingAddress		0x8022	//PT_LONG
#define dispidJournal						0x8025	//PT_BOOLEAN
#define dispidWebPage						0x802B	//PT_STRING8
#define dispidWorkAddressStreet				0x8045	//PT_STRING8
#define dispidWorkAddressCity				0x8046	//PT_STRING8
#define dispidWorkAddressState				0x8047	//PT_STRING8
#define dispidWorkAddressPostalCode			0x8048	//PT_STRING8
#define dispidWorkAddressCountry			0x8049	//PT_STRING8
#define dispidCheckSum						0x804C	//PT_LONG
#define dispidDLName						0x8053	//PT_STRING8
#define dispidOneOffMembers					0x8054	//PT_MV_BINARY
#define dispidMembers						0x8055	//PT_MV_BINARY
#define dispidInstMsg						0x8062	//PT_STRING8
#define dispidEmail1DisplayName				0x8080	//PT_STRING8
#define dispidEmail1AddressType				0x8082	//PT_STRING8
#define dispidEmail1Address					0x8083	//PT_STRING8
#define dispidEmail1OriginalDisplayName		0x8084	//PT_STRING8
#define dispidEmail1OriginalEntryID			0x8085	//PT_BINARY
#define dispidEmail2DisplayName				0x8090	//PT_STRING8
#define dispidEmail2AddressType				0x8092	//PT_STRING8
#define dispidEmail2Address					0x8093	//PT_STRING8
#define dispidEmail2OriginalDisplayName		0x8094	//PT_STRING8
#define dispidEmail2OriginalEntryID			0x8095	//PT_BINARY
#define dispidEmail3DisplayName				0x80A0	//PT_STRING8
#define dispidEmail3AddressType				0x80A2	//PT_STRING8
#define dispidEmail3Address					0x80A3	//PT_STRING8
#define dispidEmail3OriginalDisplayName		0x80A4	//PT_STRING8
#define dispidEmail3OriginalEntryID			0x80A5	//PT_BINARY
#define dispidFax1DisplayName				0x80B0	//PT_STRING8
#define dispidFax1AddressType				0x80B2	//PT_STRING8
#define dispidFax1Address					0x80B3	//PT_STRING8
#define dispidFax1OriginalDisplayName		0x80B4	//PT_STRING8
#define dispidFax1OriginalEntryID			0x80B5	//PT_BINARY
#define dispidFax2DisplayName				0x80C0	//PT_STRING8
#define dispidFax2AddressType				0x80C2	//PT_STRING8
#define dispidFax2Address					0x80C3	//PT_STRING8
#define dispidFax2OriginalDisplayName		0x80C4	//PT_STRING8
#define dispidFax2OriginalEntryID			0x80C5	//PT_BINARY
#define dispidFax3DisplayName				0x80D0	//PT_STRING8
#define dispidFax3AddressType				0x80D2	//PT_STRING8
#define dispidFax3Address					0x80D3	//PT_STRING8
#define dispidFax3OriginalDisplayName		0x80D4	//PT_STRING8
#define dispidFax3OriginalEntryID			0x80D5	//PT_BINARY
#define dispidInternetFreeBusyAddress		0x80D8	//PT_STRING8

// In PSETID_Task
#define dispidTaskStatus					0x8101	//PT_LONG
#define dispidTaskPercentComplete			0x8102	//PT_DOUBLE
#define dispidTaskTeamTask					0x8103	//PT_BOOLEAN
#define dispidTaskStartDate					0x8104	//PT_SYSTIME
#define dispidTaskDueDate					0x8105	//PT_SYSTIME
#define dispidTaskDateCompleted				0x810f	//PT_SYSTIME
#define dispidTaskActualEffort				0x8110	//PT_LONG
#define dispidTaskEstimatedEffort			0x8111	//PT_LONG
#define dispidTaskState						0x8113	//PT_LONG
#define dispidTaskRecurrenceState			0x8116	//PT_BINARY
#define dispidTaskComplete					0x811c	//PT_BOOLEAN
#define dispidTaskOwner						0x811f	//PT_STRING8
#define dispidTaskDelegator					0x8121	//PT_STRING8
#define dispidTaskOrdinal					0x8123	//PT_LONG
#define dispidTaskIsRecurring				0x8126	//PT_BOOLEAN	
#define dispidTaskRole						0x8127	//PT_STRING8
#define dispidTaskOwnership					0x8129	//PT_LONG
#define dispidTaskDelegationState			0x812A	//PT_LONG

// In PSETID_Appointment
#define dispidSendAsICAL					0x8200	//PT_BOOLEAN
#define dispidBusyStatus					0x8205	//PT_LONG
#define dispidLocation						0x8208	//PT_STRING8
#define dispidApptStartWhole				0x820D	//PT_SYSTIME
#define dispidApptEndWhole					0x820E	//PT_SYSTIME
#define dispidApptDuration					0x8213	//PT_LONG
#define dispidLabel							0x8214	//PT_LONG
#define dispidAllDayEvent					0x8215	//PT_BOOLEAN
#define dispidRecurrenceState				0x8216	//PT_BINARY
#define dispidMeetingStatus					0x8217	//PT_LONG
#define dispidResponseStatus				0x8218	//PT_LONG
#define dispidRecurring						0x8223	//PT_BOOLEAN
#define dispidRecurringBase					0x8228	//PT_SYSTIME
#define dispidRequestSent					0x8229	//PT_BOOLEAN
#define dispidRecurrenceType				0x8231	//PT_LONG
#define dispidRecurrencePattern				0x8232	//PT_STRING8
#define dispidTimeZoneData					0x8233	//PT_BINARY - official name dispidTimeZoneStruct
#define dispidTimeZone						0x8234	//PT_STRING8
#define dispidRecurrenceStart				0x8235	//PT_SYSTIME
#define dispidRecurrenceEnd					0x8236	//PT_SYSTIME
#define dispidAllAttendeesString			0x8238	//PT_STRING8
#define dispidToAttendeesString				0x823B	//PT_STRING8
#define dispidCCAttendeesString				0x823C	//PT_STRING8
#define dispidNetMeetingType				0x8241	//PT_LONG
#define dispidNetMeetingServer				0x8242	//PT_STRING8
#define dispidNetMeetingOrganizerAlias		0x8243	//PT_STRING8
#define dispidNetMeetingAutoStart			0x8244	//PT_BOOLEAN
#define dispidConferenceServerAllowExternal 0x8246	//PT_BOOLEAN
#define dispidNetMeetingDocPathName			0x8247	//PT_STRING8
#define dispidNetShowURL					0x8248	//PT_STRING8
#define dispidConferenceServerPassword		0x8249	//PT_STRING8
// A counter proposal is when the recipient of the request has proposed a new time for the meeting
#define dispidApptCounterProposal			0x8257	//PT_BOOLEAN

// New in OLK 2007
#define dispidApptTZDefStartDisplay			0x825E
#define dispidApptTZDefEndDisplay			0x825F
#define dispidApptTZDefRecur				0x8260

// In PSETID_Meeting
#define dispidMeetingLocation				0x0002	//PT_STRING8
#define dispidGlobalObjectID				0x0003	//PT_BINARY
#define dispidMeetingRecurrenceId			0x0023	//PT_BINARY
#define dispidMeetingMessageClass			0x0024	//PT_STRING8

// In PSETID_Common
#define dispidReminderMinutesBeforeStart	0x8501	//PT_LONG
#define dispidReminderTime					0x8502	//PT_SYSTIME
#define dispidReminderSet					0x8503	//PT_BOOLEAN
#define dispidPrivate						0x8506	//PT_BOOLEAN
#define dispidNoAging						0x850E	//PT_BOOLEAN
#define dispidFormStorage					0x850F
#define dispidRemoteStatus					0x8511
#define dispidPageDirStream					0x8513
#define dispidSmartNoAttach					0x8514
#define dispidCommonStart					0x8516	//PT_SYSTIME
#define dispidCommonEnd						0x8517	//PT_SYSTIME

//On Appointments needed for deleting an occurrunce of a recurring item in outlook
//On Tasks is set to 1 on the send/assigned tasks, otherwise set to 0.
#define dispidCommonAssign					0x8518	//PT_LONG

#define dispidFormPropStream				0x851B
#define dispidRequest						0x8530
#define dispidCompanies						0x8539
#define dispidPropDefStream					0x8540
#define dispidScriptStream					0x8541
#define dispidCustomFlag					0x8542
#define dispidContacts						0x853A
#define dispidOutlookInternalVersion		0x8552	//PT_LONG
#define dispidOutlookVersion				0x8554	//PT_STRING8
#define dispidReminderNextTime				0x8560
#define dispidHeaderItem					0x8578
#define dispidInetAcctName					0x8580
#define dispidInetAcctStamp					0x8581

// In PSETID_Log (also known as Journal)
#define dispidLogType						0x8700
#define dispidLogStart						0x8706
#define dispidLogDuration					0x8707
#define dispidLogEnd						0x8708

#endif

