/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef ECCONFIG_H
#define ECCONFIG_H

#include <map>
#include <list>
#include <string>
#include <string.h>
#include <pthread.h>
using namespace std;

struct configsetting_t {
	const char *szName;
	const char *szValue;
	unsigned int ulFlags;
#define CONFIGSETTING_ALIAS			0x0001
#define CONFIGSETTING_RELOADABLE	0x0002
#define CONFIGSETTING_UNUSED		0x0004
};

struct settingkey_t {
	char s[256];
	unsigned int ulFlags;
};

struct settingcompare
{
	bool operator()(settingkey_t a, settingkey_t b) const
	{
		return strcmp(a.s, b.s) < 0;
	}
};

#define MAXLINELEN 4096

typedef map<settingkey_t, char *, settingcompare> settingmap_t;

/*
 * Flags for the InitDefaults & InitConfigFile functions
 */
#define CONFIG_LOAD_INIT	0x0001
#define CONFIG_LOAD_FILE	0x0002
#define CONFIG_LOAD_RELOAD	0x0004

class ECConfig {
public:
	ECConfig(const configsetting_t *lpDefaults);
	~ECConfig();

	bool	LoadSettings(const char *szFilename);
	bool	ReloadSettings();

	void	AddSetting(const char *szName, const char *szValue);

	char*	GetSetting(const char *szName);
	char*	GetSetting(const char *szName, char *equal, char *other);

	bool	HasWarnings();
	list<string>* GetWarnings();
	bool	HasErrors();
	list<string>* GetErrors();

private:
	bool	InitDefaults(unsigned int ulFlags);
	bool	InitConfigFile(unsigned int ulFlags);

	char*	GetMapEntry(settingmap_t *lpMap, const char *szName);
	char*	GetAlias(const char *szAlias);

	void	AddSetting(const configsetting_t *lpsConfig, unsigned int ulFlags);
	void	AddAlias(const configsetting_t *lpsAlias);

	void	CleanupMap(settingmap_t *lpMap);
	bool	CopyConfigSetting(const configsetting_t *lpsSetting, settingkey_t *lpsKey);

private:
	const configsetting_t *m_lpDefaults;
	const char* m_szConfigFile;

	/* m_mapSettings & m_mapAliases are protected by m_settingsLock */
	pthread_rwlock_t m_settingsRWLock;

	settingmap_t		m_mapSettings;
	settingmap_t		m_mapAliases;
	list<string>	warnings;
	list<string>	errors;
};

#endif // ECCONFIG_H
