/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef ECCHANNEL_H
#define ECCHANNEL_H

#include <stdio.h>
#include <iostream>
#include <openssl/ssl.h>
#include <openssl/err.h>

#include "ECConfig.h"
#include "ECLogger.h"

// ECChannel is the communication channel with the other side. Initially, it is
// a simple way to read/write full lines of data. The reason why we specify
// a special 'HrWriteLine' instead of 'HrWrite' is that SSL encryption prefers
// writing all the data at once, instead of via multiple write() calls. Also, 
// this ensures that the ECChannel class is responsible for reading, writing
// and culling newline characters.

class ECChannel {
public:
	ECChannel(int socket);
	~ECChannel();

	HRESULT HrEnableTLS();

	HRESULT HrReadLine(char *szBuffer, ULONG ulBufSize);
	HRESULT HrReadLine(std::string * strBuffer);
	HRESULT HrWriteString(char * szBuffer);
	HRESULT HrWriteString(std::string & strBuffer);
	HRESULT HrWriteLine(char *szBuffer);
	HRESULT HrWriteLine(std::string & strBuffer);
	HRESULT HrReadBytes(char *szBuffer, ULONG ulByteCount);
	HRESULT HrReadBytes(std::string * strBuffer, ULONG ulByteCount);

	HRESULT HrSelect(int seconds);

	bool UsingSsl();
	bool sslctx();

	static HRESULT HrSetCtx(ECConfig * lpConfig, ECLogger * lpLogger);
	static HRESULT HrFreeCtx();

private:
	int fd;
	SSL *lpSSL;
	static SSL_CTX *lpCTX;

	char *fd_gets(char *buf, int len);
	char *SSL_gets(char *buf, int len);
};

#endif
#ifndef ECCHANNEL_H
#define ECCHANNEL_H

#include <stdio.h>
#include <iostream>
#include <openssl/ssl.h>
#include <openssl/err.h>

#include "ECConfig.h"
#include "ECLogger.h"

// ECChannel is the communication channel with the other side. Initially, it is
// a simple way to read/write full lines of data. The reason why we specify
// a special 'HrWriteLine' instead of 'HrWrite' is that SSL encryption prefers
// writing all the data at once, instead of via multiple write() calls. Also, 
// this ensures that the ECChannel class is responsible for reading, writing
// and culling newline characters.

class ECChannel {
public:
	ECChannel(int socket);
	~ECChannel();

	HRESULT HrEnableTLS();

	HRESULT HrReadLine(char *szBuffer, ULONG ulBufSize);
	HRESULT HrReadLine(std::string * strBuffer);
	HRESULT HrWriteString(char * szBuffer);
	HRESULT HrWriteString(std::string & strBuffer);
	HRESULT HrWriteLine(char *szBuffer);
	HRESULT HrWriteLine(std::string & strBuffer);
	HRESULT HrReadBytes(char *szBuffer, ULONG ulByteCount);
	HRESULT HrReadBytes(std::string * strBuffer, ULONG ulByteCount);

	HRESULT HrSelect(int seconds);

	bool UsingSsl();
	bool sslctx();

	static HRESULT HrSetCtx(ECConfig * lpConfig, ECLogger * lpLogger);
	static HRESULT HrFreeCtx();

private:
	int fd;
	SSL *lpSSL;
	static SSL_CTX *lpCTX;

	char *fd_gets(char *buf, int len);
	char *SSL_gets(char *buf, int len);
};

#endif
