/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$modeler$modules$MbeansDescriptorsIntrospectionSource == null ? (class$org$apache$commons$modeler$modules$MbeansDescriptorsIntrospectionSource = MbeansDescriptorsIntrospectionSource.class$("org.apache.commons.modeler.modules.MbeansDescriptorsIntrospectionSource")) : class$org$apache$commons$modeler$modules$MbeansDescriptorsIntrospectionSource));
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();
    static Hashtable specialMethods = new Hashtable();
    private static String[] strArray;
    private static ObjectName[] objNameArray;
    private static Class[] supportedTypes;
    static /* synthetic */ Class class$org$apache$commons$modeler$modules$MbeansDescriptorsIntrospectionSource;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            ManagedBean managed = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managed == null) {
                return;
            }
            managed.setName(this.type);
            this.mbeans.add(managed);
        }
        catch (Exception ex) {
            log.error((Object)"Error reading descriptors ", (Throwable)ex);
        }
    }

    private boolean supportedType(Class ret) {
        int i = 0;
        while (i < supportedTypes.length) {
            if (ret == supportedTypes[i]) {
                return true;
            }
            ++i;
        }
        return this.isBeanCompatible(ret);
    }

    protected boolean isBeanCompatible(Class javaType) {
        if (javaType.isArray() || javaType.isPrimitive()) {
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            return false;
        }
        try {
            javaType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        Class superClass = javaType.getSuperclass();
        return superClass == null || superClass == (class$java$lang$Object == null ? (class$java$lang$Object = MbeansDescriptorsIntrospectionSource.class$("java.lang.Object")) : class$java$lang$Object) || superClass == (class$java$lang$Exception == null ? (class$java$lang$Exception = MbeansDescriptorsIntrospectionSource.class$("java.lang.Exception")) : class$java$lang$Exception) || superClass == (class$java$lang$Throwable == null ? (class$java$lang$Throwable = MbeansDescriptorsIntrospectionSource.class$("java.lang.Throwable")) : class$java$lang$Throwable) || this.isBeanCompatible(superClass);
    }

    private void initMethods(Class realClass, Method[] methods, Hashtable attMap, Hashtable getAttMap, Hashtable setAttMap, Hashtable invokeAttMap) {
        int j = 0;
        while (j < methods.length) {
            String name = methods[j].getName();
            if (!Modifier.isStatic(methods[j].getModifiers())) {
                if (!Modifier.isPublic(methods[j].getModifiers())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Not public " + methods[j]));
                    }
                } else if (methods[j].getDeclaringClass() != (class$java$lang$Object == null ? MbeansDescriptorsIntrospectionSource.class$("java.lang.Object") : class$java$lang$Object)) {
                    Class<?>[] params = methods[j].getParameterTypes();
                    if (name.startsWith("get") && params.length == 0) {
                        Class<?> ret = methods[j].getReturnType();
                        if (!this.supportedType(ret)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Unsupported type " + methods[j]));
                            }
                        } else {
                            name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(3));
                            getAttMap.put(name, methods[j]);
                            attMap.put(name, methods[j]);
                        }
                    } else if (name.startsWith("is") && params.length == 0) {
                        Class<?> ret = methods[j].getReturnType();
                        if (Boolean.TYPE != ret) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Unsupported type " + methods[j] + " " + ret));
                            }
                        } else {
                            name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(2));
                            getAttMap.put(name, methods[j]);
                            attMap.put(name, methods[j]);
                        }
                    } else if (name.startsWith("set") && params.length == 1) {
                        if (!this.supportedType(params[0])) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Unsupported type " + methods[j] + " " + params[0]));
                            }
                        } else {
                            name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(3));
                            setAttMap.put(name, methods[j]);
                            attMap.put(name, methods[j]);
                        }
                    } else if (params.length == 0) {
                        if (specialMethods.get(methods[j].getName()) == null) {
                            invokeAttMap.put(name, methods[j]);
                        }
                    } else {
                        boolean supported = true;
                        int i = 0;
                        while (i < params.length) {
                            if (!this.supportedType(params[i])) {
                                supported = false;
                                break;
                            }
                            ++i;
                        }
                        if (supported) {
                            invokeAttMap.put(name, methods[j]);
                        }
                    }
                }
            }
            ++j;
        }
    }

    public ManagedBean createManagedBean(Registry registry, String domain, Class realClass, String type) {
        ManagedBean mbean = new ManagedBean();
        Method[] methods = null;
        Hashtable attMap = new Hashtable();
        Hashtable getAttMap = new Hashtable();
        Hashtable setAttMap = new Hashtable();
        Hashtable invokeAttMap = new Hashtable();
        methods = realClass.getMethods();
        this.initMethods(realClass, methods, attMap, getAttMap, setAttMap, invokeAttMap);
        try {
            String name;
            Enumeration en = attMap.keys();
            while (en.hasMoreElements()) {
                Method sm;
                name = (String)en.nextElement();
                AttributeInfo ai = new AttributeInfo();
                ai.setName(name);
                Method gm = (Method)getAttMap.get(name);
                if (gm != null) {
                    ai.setGetMethod(gm.getName());
                    Class<?> t = gm.getReturnType();
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                }
                if ((sm = (Method)setAttMap.get(name)) != null) {
                    Class<?> t = sm.getParameterTypes()[0];
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                    ai.setSetMethod(sm.getName());
                }
                ai.setDescription("Introspected attribute " + name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Introspected attribute " + name + " " + gm + " " + sm));
                }
                if (gm == null) {
                    ai.setReadable(false);
                }
                if (sm == null) {
                    ai.setWriteable(false);
                }
                if (sm == null && gm == null) continue;
                mbean.addAttribute(ai);
            }
            en = invokeAttMap.keys();
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                Method m = (Method)invokeAttMap.get(name);
                if (m != null && name != null) {
                    OperationInfo op = new OperationInfo();
                    op.setName(name);
                    op.setReturnType(m.getReturnType().getName());
                    op.setDescription("Introspected operation " + name);
                    Class<?>[] parms = m.getParameterTypes();
                    int i = 0;
                    while (i < parms.length) {
                        ParameterInfo pi = new ParameterInfo();
                        pi.setType(parms[i].getName());
                        pi.setName("param" + i);
                        pi.setDescription("Introspected parameter param" + i);
                        op.addParameter(pi);
                        ++i;
                    }
                    mbean.addOperation(op);
                    continue;
                }
                log.error((Object)("Null arg " + name + " " + m));
            }
            Constructor<?>[] constructors = realClass.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                ConstructorInfo info = new ConstructorInfo();
                String className = realClass.getName();
                int nIndex = -1;
                nIndex = className.lastIndexOf(46);
                if (nIndex != -1) {
                    className = className.substring(nIndex + 1);
                }
                info.setName(className);
                info.setDescription(constructors[i].getName());
                Class<?>[] classes = constructors[i].getParameterTypes();
                int j = 0;
                while (j < classes.length) {
                    ParameterInfo pi = new ParameterInfo();
                    pi.setType(classes[j].getName());
                    pi.setName("param" + j);
                    pi.setDescription("Introspected parameter param" + j);
                    info.addParameter(pi);
                    ++j;
                }
                mbean.addConstructor(info);
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting name: " + type));
            }
            mbean.setName(type);
            return mbean;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        strArray = new String[0];
        objNameArray = new ObjectName[0];
        supportedTypes = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = MbeansDescriptorsIntrospectionSource.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = MbeansDescriptorsIntrospectionSource.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = MbeansDescriptorsIntrospectionSource.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = MbeansDescriptorsIntrospectionSource.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = MbeansDescriptorsIntrospectionSource.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = MbeansDescriptorsIntrospectionSource.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = MbeansDescriptorsIntrospectionSource.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = MbeansDescriptorsIntrospectionSource.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE, class$java$lang$String == null ? (class$java$lang$String = MbeansDescriptorsIntrospectionSource.class$("java.lang.String")) : class$java$lang$String, strArray.getClass(), class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MbeansDescriptorsIntrospectionSource.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = MbeansDescriptorsIntrospectionSource.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MbeansDescriptorsIntrospectionSource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objNameArray.getClass(), class$java$io$File == null ? (class$java$io$File = MbeansDescriptorsIntrospectionSource.class$("java.io.File")) : class$java$io$File};
    }
}

