/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.InputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.storeconfig.IStoreConfig;
import org.apache.catalina.storeconfig.StoreLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;

public class StoreConfigLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog((Class)StoreConfigLifecycleListener.class);
    IStoreConfig storeConfig;
    private String storeConfigClass = "org.apache.catalina.storeconfig.StoreConfig";
    private String storeRegistry = null;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("after_start".equals(event.getType()) && event.getSource() instanceof StandardServer) {
            this.createMBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createMBean() {
        InputStream descriptor;
        block12: {
            StoreLoader loader = new StoreLoader();
            try {
                Class<?> clazz = Class.forName(this.getStoreConfigClass(), true, this.getClass().getClassLoader());
                this.storeConfig = (IStoreConfig)clazz.newInstance();
                if (null == this.getStoreRegistry()) {
                    loader.load();
                } else {
                    loader.load(this.getStoreRegistry());
                }
                this.storeConfig.setRegistry(loader.getRegistry());
            }
            catch (Exception e) {
                log.error((Object)"createMBean load", (Throwable)e);
                return;
            }
            MBeanServer mserver = MBeanUtils.createServer();
            descriptor = null;
            ObjectName objectName = new ObjectName("Catalina:type=StoreConfig");
            if (mserver.isRegistered(objectName)) break block12;
            descriptor = this.getClass().getResourceAsStream("mbeans-descriptors.xml");
            Registry registry = MBeanUtils.createRegistry();
            registry.loadMetadata((Object)descriptor);
            mserver.registerMBean(this.getManagedBean(this.storeConfig), objectName);
        }
        Object var7_8 = null;
        if (descriptor == null) return;
        try {
            descriptor.close();
            return;
        }
        catch (Exception ex2) {
            log.error((Object)"createMBean register MBean", (Throwable)ex2);
        }
        return;
        {
            catch (Exception ex) {
                log.error((Object)"createMBean register MBean", (Throwable)ex);
                Object var7_9 = null;
                if (descriptor == null) return;
                try {
                    descriptor.close();
                    return;
                }
                catch (Exception ex2) {
                    log.error((Object)"createMBean register MBean", (Throwable)ex2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (descriptor == null) throw throwable;
            try {
                descriptor.close();
                descriptor = null;
                throw throwable;
            }
            catch (Exception ex2) {
                log.error((Object)"createMBean register MBean", (Throwable)ex2);
            }
            throw throwable;
        }
    }

    protected ModelMBean getManagedBean(Object object) throws Exception {
        ManagedBean managedBean = Registry.getRegistry(null, null).findManagedBean(object.getClass().getName());
        return managedBean.createMBean(object);
    }

    public IStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public void setStoreConfig(IStoreConfig storeConfig) {
        this.storeConfig = storeConfig;
    }

    public String getStoreConfigClass() {
        return this.storeConfigClass;
    }

    public void setStoreConfigClass(String storeConfigClass) {
        this.storeConfigClass = storeConfigClass;
    }

    public String getStoreRegistry() {
        return this.storeRegistry;
    }

    public void setStoreRegistry(String storeRegistry) {
        this.storeRegistry = storeRegistry;
    }
}

