<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: ViewUserAccrualList.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('accrual','enabled')
		OR !( $permission->Check('accrual','view') OR $permission->Check('accrual','view_own') OR $permission->Check('accrual','view_child') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}


$smarty->assign('title', TTi18n::gettext($title = 'Accrual List')); // See index.php
BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'user_id',
												'accrual_policy_id',
												'ids',
												) ) );

if ( $permission->Check('accrual','view') OR $permission->Check('accrual','view_child')) {
	$user_id = $user_id;
} else {
	$user_id = $current_user->getId();
}

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'user_id' => $user_id,
													'accrual_policy_id' => $accrual_policy_id,
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}

Debug::Arr($ids,'Selected Objects', __FILE__, __LINE__, __METHOD__,10);

$action = Misc::findSubmitButton();
switch ($action) {
	case 'add':

		Redirect::Page( URLBuilder::getURL( NULL, 'EditUserAccrual.php') );

		break;
	case 'delete' OR 'undelete':
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		$alf = new AccrualListFactory();

		$alf->StartTransaction();
		foreach ($ids as $id) {

			$alf->getById( $id );
			foreach ($alf as $a_obj) {
				if ( $a_obj->getUserDateTotalID() == FALSE ) {
					$a_obj->setEnableCalcBalance(FALSE);
					$a_obj->setDeleted($delete);
					if ( $a_obj->isValid() ) {
						$a_obj->Save();
					}
				}
			}
		}

		AccrualBalanceFactory::calcBalance( $user_id, $accrual_policy_id );

		$alf->CommitTransaction();

		Redirect::Page( URLBuilder::getURL( NULL, 'ViewUserAccrualList.php') );

		break;

	default:
		$alf = new AccrualListFactory();
		$alf->getByCompanyIdAndUserIdAndAccrualPolicyID( $current_company->getId(), $user_id, $accrual_policy_id, $current_user_prefs->getItemsPerPage(), $page, NULL, $sort_array);

		$pager = new Pager($alf);

		$type_options = $alf->getOptions('type');

		foreach ($alf as $a_obj) {

			$date_stamp = $a_obj->getColumn('date_stamp');
			if ( $date_stamp != '' ) {
				$date_stamp = TTDate::strtotime($date_stamp);
			}
			$accruals[] = array(
								'id' => $a_obj->getId(),
								'user_id' => $a_obj->getUser(),
								'accrual_policy_id' => $a_obj->getAccrualPolicyId(),
								'type_id' => $a_obj->getType(),
								'type' => $type_options[$a_obj->getType()],
								'user_date_total_id' => $a_obj->getUserDateTotalId(),
								'user_date_total_date_stamp' => $date_stamp,
								'time_stamp' => $a_obj->getTimeStamp(),
								'amount' => $a_obj->getAmount(),
								'deleted' => $a_obj->getDeleted()
							);

		}
		$smarty->assign_by_ref('accruals', $accruals);

		$ulf = new UserListFactory();
		$user_obj = $ulf->getById( $user_id )->getCurrent();

		$aplf = new AccrualPolicyListFactory();
		$accrual_policy_obj = $aplf->getById( $accrual_policy_id )->getCurrent();

		$smarty->assign_by_ref('user_id', $user_id);
		$smarty->assign_by_ref('user_full_name', $user_obj->getFullName() );
		$smarty->assign_by_ref('accrual_policy_id', $accrual_policy_id);
		$smarty->assign_by_ref('accrual_policy', $accrual_policy_obj->getName() );

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}
$smarty->display('accrual/ViewUserAccrualList.tpl');
?>