<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2376 $
 * $Id: InstallSchema_1015A.class.php 2376 2009-01-23 17:12:17Z ipso $
 * $Date: 2009-01-23 09:12:17 -0800 (Fri, 23 Jan 2009) $
 */

/**
 * @package Module_Install
 */
class InstallSchema_1015A extends InstallSchema_Base {

	protected $station_users = array();

	function preInstall() {
		Debug::text('preInstall: '. $this->getVersion() , __FILE__, __LINE__, __METHOD__,9);

		if ( strncmp($this->getDatabaseConnection()->databaseType,'postgres',8) == 0 ) {
			//Mark old stations that weren't explicitly made, or used since Jan 01/2007 as deleted.
			$query = 'update station set deleted = 1 where id in ( select a.id from station as a LEFT JOIN station_user as b ON a.id = b.station_id WHERE b.station_id IS NULL AND (a.allowed_date is NULL OR a.allowed_date < 1167609600) )';
			$this->getDatabaseConnection()->Execute( $query );
		}

		//Get all station_ids and users explicitly assigned to them.
		$query = 'select a.station_id, a.user_id from station_user as a LEFT JOIN station as b ON a.station_id = b.id where b.deleted = 0 order by station_id';
		$rs = $this->getDatabaseConnection()->Execute( $query );
		if ( $rs->RecordCount() > 0 ) {
			foreach( $rs as $row ) {
				$this->station_users[$row['station_id']][] = $row['user_id'];
			}
		}

		return TRUE;
	}

	function postInstall() {
		global $cache;

		Debug::text('postInstall: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);

		Debug::text('l: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);

		if ( is_array($this->station_users) AND count($this->station_users) > 0 ) {
			foreach( $this->station_users as $station_id => $user_ids ) {
				//Get station object.
				$slf = new StationListFactory();
				$slf->getById( $station_id );
				if ( $slf->getRecordCount() > 0 ) {
					$s_obj = $slf->getCurrent();

					if ( in_array( '-1', $user_ids) ) {
						//All users allowed
						$s_obj->setGroupSelectionType( 10 );
						$s_obj->setBranchSelectionType( 10 );
						$s_obj->setDepartmentSelectionType( 10 );
					} else {
						//Only specific users allowed
						$s_obj->setIncludeUser( $user_ids );
					}

					if ( $s_obj->isValid() ) {
						$s_obj->Save();
					}
				}
			}
		}
		unset($this->station_users);

		//Add currency updating to cron.
		$maint_base_path = Environment::getBasePath() . DIRECTORY_SEPARATOR .'maint'. DIRECTORY_SEPARATOR;
		if ( PHP_OS == 'WINNT' ) {
			$cron_job_base_command =  'php-win.exe '. $maint_base_path;
		} else {
			$cron_job_base_command =  'php '. $maint_base_path;
		}
		Debug::text('Cron Job Base Command: '. $cron_job_base_command, __FILE__, __LINE__, __METHOD__,9);

		$cjf = new CronJobFactory();
		$cjf->setName('TimeClockSync');
		$cjf->setMinute('*');
		$cjf->setHour('*');
		$cjf->setDayOfMonth('*');
		$cjf->setMonth('*');
		$cjf->setDayOfWeek('*');
		$cjf->setCommand($cron_job_base_command.'TimeClockSync.php');
		$cjf->Save();

		return TRUE;
	}
}
?>
