/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Balancer;
import br.arca.morcego.Config;
import br.arca.morcego.Graph;
import br.arca.morcego.SpeedVector;
import br.arca.morcego.Vertex;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class Node
extends Vertex {
    private int ballSize;
    private int textSize;
    private boolean focussed = true;
    private Rectangle boundRectangle = new Rectangle();
    private int cornerU;
    private int cornerV;
    private boolean positionFixed;
    private SpeedVector speed = new SpeedVector(1, 1, 1);
    private Hashtable links;
    private boolean isCentered;
    private String name;
    private Graph graph;
    private URL actionUrl;
    private Color color = (Color)Config.getValue("nodeDefaultColor");
    private SpeedVector lastSpeed;

    public Node(String name, Graph graph) {
        this.links = new Hashtable();
        this.graph = graph;
        this.name = name;
        this.graph.add(this);
        this.y = this.length();
        this.x = this.length();
        this.z = this.length();
        this.setBounds();
    }

    public SpeedVector getForceFromNode(Node node) {
        SpeedVector sp = new SpeedVector(this.x - node.x, this.y - node.y, this.z - node.z);
        int distance = (Integer)Config.getValue("linkedNodesDistance");
        float module = sp.module();
        int radius = (Integer)Config.getValue("universeRadius");
        sp.resize(1.0f / module);
        if (this.isLinkedTo(node)) {
            if ((module -= (float)distance) > 0.0f) {
                sp.resize(-((float)Math.pow((double)module / Math.sqrt(radius), 2.0)));
            } else {
                sp.resize((float)Math.pow((double)module / Math.sqrt(radius), 2.0));
            }
        } else {
            sp.resize((float)Math.pow(Math.E, (float)(2 * radius) / module));
        }
        return sp;
    }

    public SpeedVector getForceToCenter() {
        SpeedVector sp = new SpeedVector(0, 0, 0);
        if (!this.centered()) {
            return new SpeedVector(0, 0, 0);
        }
        return new SpeedVector(-this.x / 4.0f, -this.y / 4.0f, -this.z / 4.0f);
    }

    private boolean isLinkedTo(Node node) {
        return this.links.containsKey(node.name);
    }

    public boolean centered() {
        return this.isCentered;
    }

    public void center() {
        this.isCentered = true;
    }

    public void unCenter() {
        this.isCentered = false;
    }

    public void clearSpeed() {
        this.speed.clear();
    }

    public void addSpeed(SpeedVector s) {
        this.speed.add(s);
    }

    public void balance(Balancer balancer) {
        if (this.centered()) {
            this.clearSpeed();
            this.addSpeed(this.getForceToCenter());
            this.moveBy(this.speed.x, this.speed.y, this.speed.z);
        } else if (!this.positionFixed()) {
            this.speed.resize(0.5f);
            if (this.lastSpeed != null && this.speed.opposed(this.lastSpeed)) {
                float module = this.speed.module();
                float lastModule = this.lastSpeed.module();
                this.speed.resize(0.75f * Math.min(lastModule, module) / module);
            }
            this.change(this.speed);
        }
        if (this.lastSpeed != null && this.speed.isTooLow() && this.lastSpeed.isTooLow()) {
            balancer.notifyBalanced(this);
        }
        this.lastSpeed = new SpeedVector(this.speed.x, this.speed.y, this.speed.z);
    }

    public boolean positionFixed() {
        return this.positionFixed || this.centered();
    }

    public void releasePosition() {
        this.positionFixed = false;
    }

    public void fixPosition() {
        this.positionFixed = true;
    }

    public void moveBy(float dx, float dy, float dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        this.setBounds();
        this.proj();
    }

    public void moveTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.setBounds();
        this.proj();
    }

    public void change(SpeedVector sp) {
        if (sp.module() > (float)((Integer)Config.getValue("maxNodeSpeed")).intValue()) {
            sp.resize((float)((Integer)Config.getValue("maxNodeSpeed")).intValue() / sp.module());
        }
        this.moveBy(sp.x / 2, sp.y / 2, sp.z / 2);
    }

    public synchronized void proj() {
        this.ballSize = (int)Math.round((double)((Integer)Config.getValue("nodeSize")).intValue() * (double)Vertex.FOV / (double)(-this.z + (float)((Integer)Config.getValue("cameraZ")).intValue()));
        this.textSize = (int)Math.round((double)((Integer)Config.getValue("textSize")).intValue() * (double)Vertex.FOV / (double)(-this.z + (float)((Integer)Config.getValue("cameraZ")).intValue()));
        if (this.centered()) {
            this.textSize = (int)((double)this.textSize * 1.5);
        }
        if (this.ballSize < (Integer)Config.getValue("minBallSize")) {
            this.ballSize = (Integer)Config.getValue("minBallSize");
        }
        int k = (int)(this.z - (float)((Integer)Config.getValue("cameraZ")).intValue());
        int ZZ = (int)(this.z - (float)((Integer)Config.getValue("cameraZ")).intValue());
        if (Math.abs(ZZ) < 1) {
            ZZ = 1;
        }
        this.u = new Float(this.graph.getOrigin().x + Vertex.FOV * (this.x - this.graph.getOrigin().x) / (float)ZZ).intValue();
        this.v = new Float(this.graph.getOrigin().y + Vertex.FOV * (this.y - this.graph.getOrigin().y) / (float)ZZ).intValue();
        int c = this.ballSize / 2;
        this.cornerU = this.u - c;
        this.cornerV = this.v - c;
        this.boundRectangle = new Rectangle(this.cornerU, this.cornerV, this.ballSize, this.ballSize);
    }

    public boolean contains(int x, int y) {
        return this.boundRectangle.contains(x, y);
    }

    public int length() {
        return (int)((Math.random() * 2.0 - 1.0) * 500.0);
    }

    void setBounds() {
        int radius = (Integer)Config.getValue("universeRadius");
        this.x = Math.min(Math.max(this.x, (float)(-radius)), (float)radius);
        this.y = Math.min(Math.max(this.y, (float)(-radius)), (float)radius);
        this.z = Math.min(Math.max(this.z, (float)(-radius)), (float)radius);
    }

    public void addLink(String nodeName) {
        this.links.put(nodeName, new Object());
        Node neighbour = this.graph.nodeFromName(nodeName);
        if (neighbour != null) {
            neighbour.links.put(this.name, new Object());
        }
    }

    public Color fadeColor(Color color, float scale) {
        int red = (int)(scale * (float)color.getRed() + (1.0f - scale) * (float)((Color)Config.getValue("backgroundColor")).getRed());
        int green = (int)(scale * (float)color.getGreen() + (1.0f - scale) * (float)((Color)Config.getValue("backgroundColor")).getGreen());
        int blue = (int)(scale * (float)color.getBlue() + (1.0f - scale) * (float)((Color)Config.getValue("backgroundColor")).getBlue());
        return new Color(red, green, blue);
    }

    public void paint(Graphics g) {
        Graphics2D graphic = (Graphics2D)g;
        float zc = this.z - (float)((Integer)Config.getValue("cameraZ")).intValue();
        float scale = Math.abs(zc) > 1.0f ? Math.abs(Vertex.FOV * 1.0f / zc) : 1.0f;
        if ((scale = (float)((double)scale * 1.5)) > 1.0f) {
            scale = 1.0f;
        }
        if ((double)scale < 0.1) {
            scale = 0.1f;
        }
        g.setColor(this.fadeColor((Color)Config.getValue("linkColor"), scale));
        Set linkSet = this.links.keySet();
        Iterator it = linkSet.iterator();
        while (it.hasNext()) {
            Node neighbour = this.graph.nodeFromName((String)it.next());
            if (neighbour == null || !(neighbour.z > this.z)) continue;
            g.drawLine(this.u, this.v, neighbour.u, neighbour.v);
        }
        graphic.setColor(this.fadeColor(this.color, scale));
        graphic.fillOval(this.cornerU, this.cornerV, this.ballSize, this.ballSize);
        graphic.setColor(this.fadeColor((Color)Config.getValue("ballBorderColor"), scale));
        graphic.drawOval(this.cornerU, this.cornerV, this.ballSize, this.ballSize);
        AffineTransform at = new AffineTransform(40.0f, 0.0f, 0.0f, 4.0f, 0.0f, 0.0f);
        FontRenderContext frc = new FontRenderContext(at, false, false);
        int interval = (Integer)Config.getValue("fontSizeInterval");
        Font font = new Font(null, 0, this.textSize / interval * interval);
        TextLayout l = new TextLayout(this.name, font, frc);
        Rectangle2D textBounds = l.getBounds();
        l.draw(graphic, (int)((double)this.u - textBounds.getWidth() / 2.0), this.cornerV);
    }

    public void setGraph(Graph g) {
        this.graph = g;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public String getName() {
        return this.name;
    }

    public URL getActionUrl() {
        return this.actionUrl;
    }

    public void setActionUrl(URL actionUrl) {
        this.actionUrl = actionUrl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public SpeedVector getSpeed() {
        return this.speed;
    }

    public void awake() {
        this.lastSpeed = null;
    }

    public SpeedVector getLastSpeed() {
        return this.lastSpeed;
    }

    public Enumeration getLinkList() {
        return this.links.keys();
    }
}

