/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphModel;
import org.jgraph.pad.DefaultGraphModelFileFormatSerial;
import org.jgraph.pad.DefaultGraphModelFileFormatXML;
import org.jgraph.pad.EllipseCell;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GraphModelFileFormat;
import org.jgraph.pad.GraphModelProvider;
import org.jgraph.pad.ImageCell;
import org.jgraph.pad.TextCell;
import org.jgraph.pad.resources.Translator;

public class DefaultGraphModelProvider
implements GraphModelProvider {
    DefaultGraphModelFileFormatXML defaultGraphModelFileFormatXML = new DefaultGraphModelFileFormatXML();
    DefaultGraphModelFileFormatSerial defaultGraphModelFileFormatSerial = new DefaultGraphModelFileFormatSerial();

    public String getPresentationName() {
        return "Default Graph Model";
    }

    public Object createCell(GraphModel graphModel, int n, Object object, Map map) {
        switch (n) {
            case 6: {
                return new DefaultEdge(object);
            }
            case 1: {
                return new EllipseCell(object);
            }
            case 3: {
                return new ImageCell(object);
            }
            case 5: {
                return new DefaultPort(object);
            }
            case 4: {
                return new TextCell(object, true);
            }
        }
        return new DefaultGraphCell(object);
    }

    public GraphModel createCleanGraphModel() {
        return new DefaultGraphModel();
    }

    public boolean isMutateAbleTo(Class clazz) {
        return false;
    }

    public GraphModel mutateTo(GraphModel graphModel, Class clazz) {
        return null;
    }

    public GraphModelFileFormat[] getGraphModelFileFormats() {
        return new GraphModelFileFormat[]{this.defaultGraphModelFileFormatXML};
    }

    public void addPort(Object object, Object object2) {
        if (object2 instanceof DefaultPort && object instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)object).add((DefaultPort)object2);
        }
    }

    public GPGraph createCleanGraph(GraphModel graphModel) {
        String string;
        GPGraph gPGraph = new GPGraph(graphModel);
        if (System.getProperty("os.name").equals("Mac OS X") && (string = Translator.getString("doubleBufferedOnMacOSX")) != null) {
            gPGraph.setDoubleBuffered(Boolean.getBoolean(string));
        }
        return gPGraph;
    }
}

