
dojo.require("dojo.io.*");
dojo.require("dojo.fx.*");

var bpui;
if (typeof bpui == "undefined") {
	bpui = new Object();
}

bpui.RSS = function() {
    var jsonData = null;
    var rssItemNum = 0;
    var currentItem = 0;
    var itemIntervalMsec = 2000;
    var itemIntervalId = 0;
    var headTitle = null;
    
    this.getRssInJson = function (method, uri, number, speed, title) {
        if (speed) {
            itemIntervalMsec = speed;
        }
        if (title) {
            headTitle = title;
        }
        rssItemNum = number;
        var encodedURI = encodeURI(method + "?style=json&itemCount="+number+"&url="+uri);
        var bindArgs = {
                    url: encodedURI,
                    mimetype: "text/json",
                    load: function (type, data, http) {
                        handleJsonRss(data);
                        for (var key in data.channel.item) {
                            dojo.debug("ITEM Title ", key, ":", data.channel.item[key].title);
                            dojo.debug("ITEM LInk ", key, ":", data.channel.item[key].link);
                        }
                    },
                    error: function (t, e) {
                        dojo.debug("ERROR : " + e.message);
                    }
        }
        dojo.io.bind(bindArgs);
        return false;
    }

    function handleJsonRss(json) {
        jsonData = json;
        // setting top title and link
        if (!headTitle) {
            headTitle = json.channel.title;
        }
        generateHref(headTitle, json.channel.link, "rss-channel");
        // setting items
        generateHref(json.channel.item[0].title, json.channel.item[0].link, "rss-item");
        var aNodes = document.getElementById("rss-item").getElementsByTagName("a");
        dojo.event.connect(aNodes[0], "onmouseover", "pauseCycle");
        dojo.event.connect(aNodes[0], "onmouseout", "resumeCycle");
        cycleRss();
    }

    function generateHref (title, link, nodeId) {
        var node = document.getElementById(nodeId);
        var aNode = document.createElement("a");
        aNode.setAttribute("href", link);
        aNode.setAttribute("target", "_blank");
        aNode.appendChild(document.createTextNode(title));
        if (node.hasChildNodes()) {
            node.removeChild(node.firstChild);
        }
        node.appendChild(aNode);
    }

    function cycleRss () {
        itemIntervalId = setTimeout(replaceItem, itemIntervalMsec);
    }
    
    
    function replaceItem() {
        if (itemIntervalId) {
            clearTimeout(itemIntervalId);
        }
        // fadeout the current item and pop the next one in.
        var cItem = document.getElementById("rss-item");
        dojo.fx.html.fadeOut(cItem.getElementsByTagName('a')[0], 500);
        var waitId = setTimeout(function(waitId) {
            clearTimeout(waitId);
            //cItem.removeChild(cItem.firstChild);
            if (currentItem < (rssItemNum -1)) {
                currentItem += 1;
            } else {
                currentItem = 0;
            }
            generateHref(jsonData.channel.item[currentItem].title, jsonData.channel.item[currentItem].link, "rss-item");
            // attach event for onmouseover(pause) and onmouseout(resume)
            var aNodes = cItem.getElementsByTagName("a");
            dojo.event.connect(aNodes[0], "onmouseover", "pauseCycle");
            dojo.event.connect(aNodes[0], "onmouseout", "resumeCycle");
            cycleRss();}, 500);
    }

    function pauseCycle(evt) {
        if (itemIntervalId) {
            clearTimeout(itemIntervalId);
        }
    }

    function resumeCycle (evt) {
        cycleRss();
    }
}

