/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class SharedClassObject
implements Externalizable {
    private static final long serialVersionUID = 4527891234589143259L;
    private static final Object PROP_SUPPORT;
    private static final Map values;
    private static final Map instancesBeingCreated;
    private static final Set alreadyWarnedAboutDupes;
    private static final ErrorManager err;
    private final DataEntry dataEntry;
    private Object lock;
    private final SharedClassObject first;
    private Throwable firstTrace = null;
    private boolean systemOption = false;
    private boolean waitingOnSystemOption = false;
    private IllegalStateException prematureSystemOptionMutation = null;
    private boolean inReadExternal = false;
    private boolean addNotifySuper;
    private boolean removeNotifySuper;
    private boolean initializeSuper;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$io$ObjectStreamException;
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedClassObject() {
        Object object = this.getLock();
        synchronized (object) {
            DataEntry de = (DataEntry)values.get(this.getClass());
            if (de == null) {
                de = new DataEntry();
                values.put(this.getClass(), de);
            }
            this.dataEntry = de;
            de.increase();
            this.first = de.first(this);
        }
        if (this.first != null) {
            if (this.first == this) {
                if (err != null && err.isLoggable(1)) {
                    Throwable t = new Throwable("First instance created here");
                    t.fillInStackTrace();
                    this.first.firstTrace = t;
                }
            } else {
                boolean creating;
                String clazz = this.getClass().getName();
                Map map = instancesBeingCreated;
                synchronized (map) {
                    creating = instancesBeingCreated.containsKey(clazz);
                }
                if (!creating && !alreadyWarnedAboutDupes.contains(clazz)) {
                    alreadyWarnedAboutDupes.add(clazz);
                    IllegalStateException e = new IllegalStateException("Warning: multiple instances of shared class " + clazz + " created.");
                    if (this.first.firstTrace != null) {
                        err.annotate((Throwable)e, this.first.firstTrace);
                    } else {
                        err.annotate((Throwable)e, "(Run with -J-Dorg.openide.util.SharedClassObject=0 for more details.)");
                    }
                    err.notify(1, e);
                }
            }
        }
    }

    protected final void finalize() throws Throwable {
        this.referenceLost();
    }

    protected boolean clearSharedData() {
        return true;
    }

    public final boolean equals(Object obj) {
        return obj instanceof SharedClassObject && this.getClass().equals(obj.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    protected final Object getLock() {
        if (this.lock == null) {
            this.lock = this.getClass().getName().intern();
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void referenceLost() {
        Object object = this.getLock();
        synchronized (object) {
            if ((this.dataEntry == null || this.dataEntry.decrease() == 0) && this.clearSharedData()) {
                values.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putProperty(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Tried to pass null key (value=" + value + ") to putProperty");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.waitingOnSystemOption && key != PROP_SUPPORT && this.prematureSystemOptionMutation == null && !this.dataEntry.isInInitialize() && !this.inReadExternal) {
                this.prematureSystemOptionMutation = new IllegalStateException("...setting property here...");
            }
            return this.dataEntry.getMap(this).put(key, value);
        }
    }

    protected final Object putProperty(String key, Object value, boolean notify) {
        Object previous = this.putProperty(key, value);
        if (notify) {
            this.firePropertyChange(key, previous, value);
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getProperty(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            if ("org.openide.util.SharedClassObject.initialize".equals(key)) {
                return this.dataEntry.isInInitialize() ? Boolean.TRUE : null;
            }
            return this.dataEntry.get(this, key);
        }
    }

    protected void initialize() {
        this.initializeSuper = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        boolean noListener;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport supp = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (supp == null) {
                supp = new PropertyChangeSupport(this);
                this.putProperty(PROP_SUPPORT, supp);
            }
            noListener = !supp.hasListeners(null);
            supp.addPropertyChangeListener(l);
        }
        if (noListener) {
            this.addNotifySuper = false;
            this.addNotify();
            if (!this.addNotifySuper) {
                String msg = "You must call super.addNotify() from " + this.getClass().getName() + ".addNotify()";
                err.log(16, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        boolean callRemoved;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport supp = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (supp == null) {
                return;
            }
            boolean hasListener = supp.hasListeners(null);
            supp.removePropertyChangeListener(l);
            callRemoved = hasListener && !supp.hasListeners(null);
        }
        if (callRemoved) {
            this.putProperty(PROP_SUPPORT, null);
            this.removeNotifySuper = false;
            this.removeNotify();
            if (!this.removeNotifySuper) {
                String msg = "You must call super.removeNotify() from " + this.getClass().getName() + ".removeNotify()";
                err.log(16, msg);
            }
        }
    }

    protected void addNotify() {
        this.addNotifySuper = true;
    }

    protected void removeNotify() {
        this.removeNotifySuper = true;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeSupport supp = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
        if (supp != null) {
            supp.firePropertyChange(name, oldValue, newValue);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
    }

    protected Object writeReplace() {
        return new WriteReplace(this);
    }

    public static SharedClassObject findObject(Class clazz) {
        return SharedClassObject.findObject(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedClassObject findObject(Class clazz, boolean create) {
        String string = clazz.getName().intern();
        synchronized (string) {
            Lookup.Result r;
            DataEntry de = (DataEntry)values.get(clazz);
            SharedClassObject obj = de == null ? null : de.get();
            boolean created = false;
            if (obj == null && create) {
                SetAccessibleAction action = new SetAccessibleAction(clazz);
                try {
                    obj = (SharedClassObject)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    IllegalArgumentException newEx = new IllegalArgumentException(ex.toString());
                    newEx.initCause(ex);
                    throw newEx;
                }
                created = true;
            }
            if ((de = (DataEntry)values.get(clazz)) != null) {
                SharedClassObject obj2 = de.get();
                if (obj != null && obj != obj2) {
                    if (obj2 == null && create) {
                        throw new IllegalStateException("Inconsistent state: " + clazz);
                    }
                    return obj2;
                }
            }
            if (created && obj.isSystemOption() && (r = Lookup.getDefault().lookup(new Lookup.Template(clazz))).allInstances().isEmpty()) {
                obj.waitingOnSystemOption = true;
                SharedClassObject _obj = obj;
                IllegalStateException start = new IllegalStateException("Making a SystemOption here that is not in lookup...");
                class SOLoader
                implements LookupListener {
                    private final /* synthetic */ Lookup.Result val$r;
                    private final /* synthetic */ SharedClassObject val$_obj;
                    private final /* synthetic */ IllegalStateException val$start;

                    SOLoader(Lookup.Result result, SharedClassObject sharedClassObject, IllegalStateException illegalStateException) {
                        this.val$r = result;
                        this.val$_obj = sharedClassObject;
                        this.val$start = illegalStateException;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultChanged(LookupEvent ev) {
                        if (!this.val$r.allInstances().isEmpty()) {
                            this.val$r.removeLookupListener(this);
                            Object object = this.val$_obj.getLock();
                            synchronized (object) {
                                this.val$_obj.waitingOnSystemOption = false;
                                if (this.val$_obj.prematureSystemOptionMutation != null) {
                                    SharedClassObject.warn(this.val$start);
                                    SharedClassObject.warn(this.val$_obj.prematureSystemOptionMutation);
                                    SharedClassObject.warn(new IllegalStateException("...and maybe getting clobbered here, see #17711."));
                                    this.val$_obj.prematureSystemOptionMutation = null;
                                }
                            }
                        }
                    }
                }
                r.addLookupListener(new SOLoader(r, _obj, start));
            }
            if (obj == null && create) {
                throw new IllegalStateException("Inconsistent state: " + clazz);
            }
            return obj;
        }
    }

    private boolean isSystemOption() {
        for (Class<?> c = this.getClass(); c != (class$org$openide$util$SharedClassObject == null ? SharedClassObject.class$("org.openide.util.SharedClassObject") : class$org$openide$util$SharedClassObject); c = c.getSuperclass()) {
            if (!"org.openide.options.SystemOption".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    private static void warn(Throwable t) {
        err.notify(1, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createInstancePrivileged(Class clazz) throws Exception {
        Constructor c = clazz.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        String name = clazz.getName();
        if (!$assertionsDisabled && instancesBeingCreated == null) {
            throw new AssertionError();
        }
        Map map = instancesBeingCreated;
        synchronized (map) {
            Integer i = (Integer)instancesBeingCreated.get(name);
            instancesBeingCreated.put(name, i == null ? new Integer(1) : new Integer(i + 1));
        }
        try {
            map = c.newInstance(new Object[0]);
            return map;
        }
        finally {
            Map map2 = instancesBeingCreated;
            synchronized (map2) {
                Integer i = (Integer)instancesBeingCreated.get(name);
                if (i == 1) {
                    instancesBeingCreated.remove(name);
                } else {
                    instancesBeingCreated.put(name, new Integer(i - 1));
                }
            }
            c.setAccessible(false);
        }
    }

    protected void reset() {
    }

    static {
        $assertionsDisabled = !SharedClassObject.class.desiredAssertionStatus();
        PROP_SUPPORT = new Object();
        values = new WeakHashMap(4);
        instancesBeingCreated = new HashMap(3);
        alreadyWarnedAboutDupes = new HashSet();
        err = ErrorManager.getDefault().getInstance("org.openide.util.SharedClassObject");
    }

    static final class SetAccessibleAction
    implements PrivilegedExceptionAction {
        Class klass;

        SetAccessibleAction(Class klass) {
            this.klass = klass;
        }

        public Object run() throws Exception {
            return SharedClassObject.createInstancePrivileged(this.klass);
        }
    }

    static final class DataEntry {
        private HashMap map;
        private int count = 0;
        private WeakReference ref = new WeakReference<Object>(null);
        private boolean initialized = false;
        private boolean initializeInProgress = false;
        private Throwable invalid = null;

        DataEntry() {
        }

        public String toString() {
            return "SCO.DataEntry[ref=" + this.ref.get() + ",count=" + this.count + ",initialized=" + this.initialized + ",invalid=" + this.invalid + ",map=" + this.map + "]";
        }

        boolean isInInitialize() {
            return this.initializeInProgress;
        }

        Map getMap(SharedClassObject obj) {
            this.ensureValid(obj);
            if (this.map == null) {
                this.map = new HashMap();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.tryToInitialize(obj);
            }
            return this.map;
        }

        Object get(SharedClassObject obj, Object key) {
            Object ret;
            this.ensureValid(obj);
            if (this.map == null) {
                this.map = new HashMap();
                ret = null;
            } else {
                ret = this.map.get(key);
            }
            if (ret == null && !this.initialized) {
                if (key == PROP_SUPPORT) {
                    return null;
                }
                this.initialized = true;
                this.tryToInitialize(obj);
                ret = this.map.get(key);
            }
            return ret;
        }

        Map getMap() {
            this.ensureValid(this.get());
            if (this.map == null) {
                this.map = new HashMap();
            }
            return this.map;
        }

        private void ensureValid(SharedClassObject obj) throws IllegalStateException {
            if (this.invalid != null) {
                String msg = obj != null ? obj.toString() : "<unknown object>";
                IllegalStateException ise = new IllegalStateException(msg);
                err.annotate((Throwable)ise, this.invalid);
                throw ise;
            }
        }

        private void tryToInitialize(SharedClassObject obj) throws IllegalStateException {
            this.initializeInProgress = true;
            obj.initializeSuper = false;
            try {
                obj.initialize();
            }
            catch (Exception e) {
                this.invalid = e;
                IllegalStateException ise = new IllegalStateException(this.invalid.toString() + " from " + obj);
                err.annotate((Throwable)ise, this.invalid);
                throw ise;
            }
            catch (LinkageError e) {
                this.invalid = e;
                IllegalStateException ise = new IllegalStateException(this.invalid.toString() + " from " + obj);
                err.annotate((Throwable)ise, this.invalid);
                throw ise;
            }
            finally {
                this.initializeInProgress = false;
            }
            if (!obj.initializeSuper) {
                String msg = "You must call super.initialize() from " + obj.getClass().getName() + ".initialize()";
                err.log(16, msg);
            }
        }

        int increase() {
            return ++this.count;
        }

        int decrease() {
            return --this.count;
        }

        SharedClassObject first(SharedClassObject obj) {
            SharedClassObject s = (SharedClassObject)this.ref.get();
            if (s == null) {
                this.ref = new WeakReference<SharedClassObject>(obj);
                return obj;
            }
            return s;
        }

        public SharedClassObject get() {
            return (SharedClassObject)this.ref.get();
        }

        public void reset(SharedClassObject obj) {
            SharedClassObject s = this.get();
            if (s != null && s != obj) {
                return;
            }
            this.invalid = null;
            this.getMap().clear();
            this.initialized = true;
            this.tryToInitialize(obj);
        }
    }

    static final class WriteReplace
    implements Serializable {
        static final long serialVersionUID = 1327893248974327640L;
        private Class clazz;
        private String name;
        private transient SharedClassObject object;

        public WriteReplace(SharedClassObject object) {
            this.object = object;
            this.clazz = object.getClass();
            this.name = this.clazz.getName();
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            this.object.writeExternal(oos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.clazz == null) {
                if (this.name != null) {
                    throw new ClassNotFoundException(this.name);
                }
                throw new ClassNotFoundException();
            }
            this.object = SharedClassObject.findObject(this.clazz, true);
            this.object.inReadExternal = true;
            try {
                this.object.readExternal(ois);
            }
            finally {
                this.object.inReadExternal = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readResolve() throws ObjectStreamException {
            SharedClassObject resolved = this.object;
            Method resolveMethod = WriteReplace.findReadResolveMethod(this.object.getClass());
            if (resolveMethod != null) {
                try {
                    resolveMethod.setAccessible(true);
                    Object object = resolveMethod.invoke((Object)this.object, null);
                    return object;
                }
                catch (Exception ex) {
                    String banner = "Skipping " + this.object.getClass() + " resolution:";
                    err.annotate(ex, 0, banner, null, null, null);
                    err.notify(1, ex);
                }
                finally {
                    resolveMethod.setAccessible(false);
                }
            }
            return resolved;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method result = null;
            for (Class i = clazz; i != null; i = i.getSuperclass()) {
                try {
                    result = WriteReplace.accept(i.getDeclaredMethod("readResolve", new Class[0]));
                    if (result == null) continue;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return result;
        }

        private static Method accept(Method candidate) {
            Class<?>[] result;
            if (candidate != null && (result = candidate.getExceptionTypes()).length == 1 && (class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = SharedClassObject.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(result[0]) && (class$java$lang$Object == null ? (class$java$lang$Object = SharedClassObject.class$("java.lang.Object")) : class$java$lang$Object).equals(candidate.getReturnType())) {
                return candidate;
            }
            return null;
        }
    }
}

