/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class IconManager {
    private static final Object NO_ICON;
    private static final HashMap map;
    private static final HashMap localizedMap;
    private static final Set extraInitialSlashes;
    private static volatile Object currentLoader;
    private static Lookup.Result loaderQuery;
    private static boolean noLoaderWarned;
    private static final Component component;
    private static final MediaTracker tracker;
    private static int mediaTrackerID;
    private static ErrorManager ERR;
    static final /* synthetic */ boolean $assertionsDisabled;

    IconManager() {
    }

    static ClassLoader getLoader() {
        Iterator it;
        Object is = currentLoader;
        if (is instanceof ClassLoader) {
            return (ClassLoader)is;
        }
        currentLoader = Thread.currentThread();
        if (loaderQuery == null) {
            loaderQuery = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
            loaderQuery.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    ERR.log("Loader cleared");
                    currentLoader = null;
                }
            });
        }
        if ((it = loaderQuery.allInstances().iterator()).hasNext()) {
            ClassLoader toReturn = (ClassLoader)it.next();
            if (currentLoader == Thread.currentThread()) {
                currentLoader = toReturn;
            }
            ERR.log("Loader computed: " + currentLoader);
            return toReturn;
        }
        if (!noLoaderWarned) {
            noLoaderWarned = true;
            ERR.log(16, "No ClassLoader instance found in " + Lookup.getDefault());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String resource, boolean localized) {
        if (localized) {
            HashMap hashMap = localizedMap;
            synchronized (hashMap) {
                String ext;
                String base;
                Object img = localizedMap.get(resource);
                if (img == NO_ICON) {
                    return null;
                }
                if (img != null) {
                    img = ((Reference)img).get();
                }
                if (img != null) {
                    return (Image)img;
                }
                ClassLoader loader = IconManager.getLoader();
                int idx = (resource = new String(resource).intern()).lastIndexOf(46);
                if (idx != -1 && idx > resource.lastIndexOf(47)) {
                    base = resource.substring(0, idx);
                    ext = resource.substring(idx);
                } else {
                    base = resource;
                    ext = "";
                }
                Image baseVariant = IconManager.getIcon(resource, loader, false);
                Iterator it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    String suffix = (String)it.next();
                    Image i = suffix.length() == 0 ? baseVariant : IconManager.getIcon(base + suffix + ext, loader, true);
                    if (i == null) continue;
                    localizedMap.put(resource, new ActiveRef(i, localizedMap, resource));
                    return i;
                }
                localizedMap.put(resource, NO_ICON);
                return null;
            }
        }
        return IconManager.getIcon(resource);
    }

    private static Image getIcon(String name) {
        Object img = map.get(name);
        if (img == NO_ICON) {
            return null;
        }
        if (img != null) {
            img = ((Reference)img).get();
        }
        if (img != null) {
            return (Image)img;
        }
        ClassLoader loader = IconManager.getLoader();
        name = new String(name).intern();
        return IconManager.getIcon(name, loader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getIcon(String name, ClassLoader loader, boolean localizedQuery) {
        Object img = map.get(name);
        if (img == NO_ICON) {
            return null;
        }
        if (img != null) {
            img = ((Reference)img).get();
        }
        if (img != null) {
            return (Image)img;
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            String n;
            boolean warn;
            img = map.get(name);
            if (img == NO_ICON) {
                return null;
            }
            if (img != null) {
                img = ((Reference)img).get();
            }
            if (img != null) {
                return (Image)img;
            }
            if (name.startsWith("/")) {
                warn = true;
                n = name.substring(1);
            } else {
                warn = false;
                n = name;
            }
            URL url = loader != null ? loader.getResource(n) : IconManager.class.getClassLoader().getResource(n);
            Image image = img = url == null ? null : Toolkit.getDefaultToolkit().createImage(url);
            if (img != null) {
                if (warn && extraInitialSlashes.add(name)) {
                    ERR.log(16, "Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                Image img2 = IconManager.toBufferedImage((Image)img);
                if (localizedQuery) {
                    name = new String(name).intern();
                }
                map.put(name, new ActiveRef(img2, map, name));
                return img2;
            }
            if (!localizedQuery) {
                map.put(name, NO_ICON);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Image mergeImages(Image im1, Image im2, int x, int y) {
        CompositeImageKey k = new CompositeImageKey(im1, im2, x, y);
        HashMap hashMap = map;
        synchronized (hashMap) {
            Image cached;
            Reference r = (Reference)map.get(k);
            if (r != null && (cached = (Image)r.get()) != null) {
                return cached;
            }
            cached = IconManager.doMergeImages(im1, im2, x, y);
            map.put(k, new ActiveRef(cached, map, k));
            return cached;
        }
    }

    static final Image toBufferedImage(Image img) {
        new ImageIcon(img);
        BufferedImage rep = IconManager.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            if (!$assertionsDisabled && tracker.statusID(id, false) != 8) {
                throw new AssertionError((Object)"Image loaded");
            }
            tracker.removeImage(image, id);
        }
    }

    private static final Image doMergeImages(Image image1, Image image2, int x, int y) {
        IconManager.ensureLoaded(image1);
        IconManager.ensureLoaded(image2);
        int w = Math.max(image1.getWidth(null), x + image2.getWidth(null));
        int h = Math.max(image1.getHeight(null), y + image2.getHeight(null));
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, x, y, null);
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    static {
        $assertionsDisabled = !IconManager.class.desiredAssertionStatus();
        NO_ICON = new Object();
        map = new HashMap(128);
        localizedMap = new HashMap(128);
        extraInitialSlashes = new HashSet();
        loaderQuery = null;
        noLoaderWarned = false;
        component = new Component(){};
        tracker = new MediaTracker(component);
        ERR = ErrorManager.getDefault().getInstance(IconManager.class.getName());
    }

    private static final class ActiveRef
    extends SoftReference
    implements Runnable {
        private Map holder;
        private Object key;

        public ActiveRef(Object o, Map holder, Object key) {
            super(o, Utilities.activeReferenceQueue());
            this.holder = holder;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

