/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerLocationPanel;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerPropertiesPanel;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerPropertiesVisualPanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class JBInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    public final boolean skipServerLocationStep = false;
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddServerPropertiesPanel propertiesPanel = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private transient Set listeners = new HashSet(1);
    private transient String[] steps = null;
    private String host;
    private String port;
    private String userName = "";
    private String password = "";
    private String server;
    private String installLocation;
    private String deployDir;
    private String serverPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return "JBoss Server AddInstanceIterator";
    }

    public static void showInformation(final String msg, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String displayName = (String)this.wizard.getProperty("ServInstWizard_displayName");
        String url = "jboss-deployer:" + this.host + ":" + this.port;
        if (this.server != null && !this.server.equals("")) {
            url = url + "#" + this.server;
        }
        url = url + "&" + this.installLocation;
        try {
            InstanceProperties ip = InstanceProperties.createInstanceProperties((String)url, (String)this.userName, (String)this.password, (String)displayName);
            ip.setProperty("server", this.server);
            ip.setProperty("deploy-dir", this.deployDir);
            ip.setProperty("server-dir", this.serverPath);
            ip.setProperty("root-dir", this.installLocation);
            ip.setProperty("host", this.host);
            ip.setProperty("port", this.port);
            result.add(ip);
        }
        catch (InstanceCreationException e) {
            JBInstantiatingIterator.showInformation(e.getLocalizedMessage(), NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"MSG_INSTANCE_REGISTRATION_FAILED"));
            ErrorManager.getDefault().log(4096, e.getMessage());
        }
        return result;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(JBInstantiatingIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(JBInstantiatingIterator.class, (String)"STEP_Properties")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new AddServerPropertiesPanel(this);
            this.propertiesPanel.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.propertiesPanel};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel result = this.getPanels()[this.index];
        JComponent component = (JComponent)result.getComponent();
        component.putClientProperty("WizardPanel_contentData", this.getSteps());
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.getIndex()));
        return result;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void setHost(String host) {
        this.host = host.trim();
    }

    public void setPort(String port) {
        this.port = port.trim();
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation;
        this.propertiesPanel.installLocationChanged();
    }
}

