/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.jboss4.config.JBDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.gen.EjbRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossClient;
import org.netbeans.modules.j2ee.jboss4.config.gen.ResourceRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.ServiceRef;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class CarDeploymentConfiguration
extends JBDeploymentConfiguration
implements PropertyChangeListener,
XpathListener {
    private static final String EJB_REF = "/application-client/ejb-ref";
    private static final String SERVICE_REF = "/application-client/service-ref";
    private static final String RESOURCE_REF = "/application-client/resource-ref";
    private static final String DISPLAY_NAME = "/application-client/display-name";
    private File jbossClientFile;
    private JbossClient jbossClient;

    public CarDeploymentConfiguration(DeployableObject deployableObject) {
        super(deployableObject);
    }

    public void init(File file, File resourceDir) {
        super.init(resourceDir);
        this.jbossClientFile = file;
        this.getJbossClient();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossClientFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
        this.deplObj.getDDBeanRoot().addXpathListener(DISPLAY_NAME, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(RESOURCE_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(EJB_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(SERVICE_REF, (XpathListener)this);
    }

    public synchronized JbossClient getJbossClient() {
        if (this.jbossClient == null) {
            try {
                if (this.jbossClientFile.exists()) {
                    try {
                        this.jbossClient = JbossClient.createGraph(this.jbossClientFile);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.jbossClient = this.generateJbossClient();
                    this.writefile(this.jbossClientFile, this.jbossClient);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.jbossClient;
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            if (evt.getSource() == this.deploymentDescriptorDO) {
                this.jbossClient = null;
            } else {
                super.propertyChange(evt);
            }
        }
    }

    public void fireXpathEvent(XpathEvent xpe) {
        String[] name;
        if (!xpe.isAddEvent()) {
            return;
        }
        DDBean eventDDBean = xpe.getBean();
        if (DISPLAY_NAME.equals(eventDDBean.getXpath())) {
            String name2 = eventDDBean.getText();
            try {
                this.setJndiName(name2);
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        } else if (RESOURCE_REF.equals(eventDDBean.getXpath())) {
            String[] desc = eventDDBean.getText("description");
            String[] name3 = eventDDBean.getText("res-ref-name");
            String[] type = eventDDBean.getText("res-type");
            if (name3.length > 0 && type.length > 0) {
                try {
                    if (desc.length > 0 && "javax.sql.DataSource".equals(type[0])) {
                        this.addResReference(desc[0], name3[0]);
                    } else if ("javax.mail.Session".equals(type[0])) {
                        this.addMailReference(name3[0]);
                    }
                    if ("javax.jms.ConnectionFactory".equals(type[0])) {
                        this.addConnectionFactoryReference(name3[0]);
                    }
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify((Throwable)ce);
                }
            }
        } else if (EJB_REF.equals(eventDDBean.getXpath())) {
            String[] name4 = eventDDBean.getText("ejb-ref-name");
            String[] type = eventDDBean.getText("ejb-ref-type");
            if (name4.length > 0 && type.length > 0 && ("Session".equals(type[0]) || "Entity".equals(type[0]))) {
                try {
                    this.addEjbReference(name4[0]);
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify((Throwable)ce);
                }
            }
        } else if (SERVICE_REF.equals(eventDDBean.getXpath()) && (name = eventDDBean.getText("service-ref-name")).length > 0) {
            try {
                this.addServiceReference(name[0]);
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
    }

    public void save(OutputStream os) throws ConfigurationException {
        JbossClient jbossClientDD = this.getJbossClient();
        if (jbossClientDD == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            jbossClientDD.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    private JbossClient generateJbossClient() {
        JbossClient jbossClientDD = new JbossClient();
        return jbossClientDD;
    }

    private void addResReference(String desc, final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            public void modify(JbossClient modifiedJbossClient) {
                ResourceRef[] resourceRefs = modifiedJbossClient.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:" + name);
                modifiedJbossClient.addResourceRef(newRR);
            }
        });
    }

    private void addMailReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            public void modify(JbossClient modifiedJbossClient) {
                ResourceRef[] resourceRefs = modifiedJbossClient.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:Mail");
                modifiedJbossClient.addResourceRef(newRR);
            }
        });
    }

    private void addConnectionFactoryReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            public void modify(JbossClient modifiedJbossClient) {
                ResourceRef[] resourceRefs = modifiedJbossClient.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("ConnectionFactory");
                modifiedJbossClient.addResourceRef(newRR);
            }
        });
    }

    private void addEjbReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            public void modify(JbossClient modifiedJbossClient) {
                EjbRef[] ejbRefs = modifiedJbossClient.getEjbRef();
                for (int i = 0; i < ejbRefs.length; ++i) {
                    String ern = ejbRefs[i].getEjbRefName();
                    if (!name.equals(ern)) continue;
                    return;
                }
                EjbRef newER = new EjbRef();
                newER.setEjbRefName(name);
                newER.setJndiName(name);
                modifiedJbossClient.addEjbRef(newER);
            }
        });
    }

    private void setJndiName(final String jndiName) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            public void modify(JbossClient modifiedJbossClient) {
                modifiedJbossClient.setJndiName(jndiName);
            }
        });
    }

    private void addServiceReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            public void modify(JbossClient modifiedJbossClient) {
                ServiceRef[] serviceRefs = modifiedJbossClient.getServiceRef();
                for (int i = 0; i < serviceRefs.length; ++i) {
                    String srn = serviceRefs[i].getServiceRefName();
                    if (!name.equals(srn)) continue;
                    return;
                }
                ServiceRef newSR = new ServiceRef();
                newSR.setServiceRefName(name);
                modifiedJbossClient.addServiceRef(newSR);
            }
        });
    }

    private void modifyJbossClient(JbossClientModifier modifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            JbossClient newJbossClient = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJbossClient = JbossClient.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                JbossClient oldJbossClient = this.getJbossClient();
                if (oldJbossClient == null) {
                    throw new ConfigurationException("Configuration data are not parseable cannot perform changes.");
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_jbossClientXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJbossClient = oldJbossClient;
            }
            modifier.modify(newJbossClient);
            boolean modified = this.deploymentDescriptorDO.isModified();
            this.replaceDocument(doc, newJbossClient);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class);
                cookie.save();
            }
            this.jbossClient = newJbossClient;
        }
        catch (BadLocationException ble) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ble);
        }
        catch (IOException ioe) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ioe);
        }
    }

    private static interface JbossClientModifier {
        public void modify(JbossClient var1);
    }
}

