/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.ui;

import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.registry.ui.ArrayTypeTreeNode;
import org.netbeans.modules.websvc.registry.ui.ReflectionHelper;
import org.netbeans.modules.websvc.registry.ui.StructureTypeTreeNode;
import org.netbeans.modules.websvc.registry.ui.TypeNodeData;
import org.netbeans.modules.websvc.registry.ui.WebServiceReflectionException;
import org.netbeans.swing.outline.RowModel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class TypeRowModel
implements RowModel {
    private URLClassLoader urlClassLoader;
    private String packageName;

    public TypeRowModel(URLClassLoader inClassLoader, String inPackageName) {
        this.urlClassLoader = inClassLoader;
        this.packageName = inPackageName;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return NbBundle.getMessage(this.getClass(), (String)"PARAM_NAME");
            }
            case 1: {
                return NbBundle.getMessage(this.getClass(), (String)"PARAM_VALUE");
            }
        }
        return "";
    }

    public Object getValueFor(Object inNode, int column) {
        if (null == inNode) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)inNode;
        if (null == node.getUserObject()) {
            return null;
        }
        TypeNodeData data = (TypeNodeData)node.getUserObject();
        switch (column) {
            case 0: {
                return data.getParameterName();
            }
            case 1: {
                Object val = data.getParameterValue();
                if (val instanceof Calendar) {
                    return DateFormat.getDateTimeInstance().format(((Calendar)val).getTime());
                }
                return val;
            }
        }
        return "";
    }

    public boolean isCellEditable(Object inNode, int column) {
        if (null == inNode) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)inNode;
        if (null == node.getUserObject()) {
            return false;
        }
        TypeNodeData data = (TypeNodeData)node.getUserObject();
        switch (column) {
            case 0: {
                return false;
            }
            case 1: {
                return data.getParameterType() instanceof JavaSimpleType || data.getParameterType() instanceof JavaEnumerationType;
            }
        }
        return false;
    }

    public void setValueFor(Object inNode, int column, Object value) {
        if (null == inNode) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)inNode;
        if (null == node.getUserObject()) {
            return;
        }
        TypeNodeData data = (TypeNodeData)node.getUserObject();
        if (column != 1) {
            return;
        }
        JavaType type = data.getParameterType();
        Object newValue = null;
        if (type instanceof JavaEnumerationType) {
            try {
                newValue = ReflectionHelper.makeEnumerationType((JavaEnumerationType)type, this.urlClassLoader, this.packageName, value);
            }
            catch (WebServiceReflectionException wsfe) {
                Throwable cause = wsfe.getCause();
                ErrorManager.getDefault().notify(cause);
                ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to create an Enumeration Type: " + type.getFormalName() + "ClassNWebServiceReflectionExceptionotFoundException=" + cause);
                return;
            }
        } else {
            newValue = value;
        }
        data.setParameterValue(newValue);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (null != parentNode && parentNode instanceof ArrayTypeTreeNode) {
            ((ArrayTypeTreeNode)parentNode).updateValueOfChildren();
        } else if (null != parentNode && parentNode instanceof StructureTypeTreeNode) {
            ((StructureTypeTreeNode)parentNode).updateValueOfChild(data);
        }
    }
}

