/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.nodes;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceGroupEvent;
import org.netbeans.modules.websvc.registry.model.WebServiceGroupListener;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.netbeans.modules.websvc.registry.model.WebServiceListModelEvent;
import org.netbeans.modules.websvc.registry.model.WebServiceListModelListener;
import org.netbeans.modules.websvc.registry.nodes.WebServiceGroupNode;
import org.netbeans.modules.websvc.registry.nodes.WebServicesNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class WebServicesRootNodeChildren
extends Children.Keys
implements WebServiceGroupListener,
WebServiceListModelListener {
    WebServiceGroup defaultGroup = null;

    private WebServiceGroup getDefaultGroup() {
        if (this.defaultGroup == null) {
            WebServiceListModel websvcListModel = WebServiceListModel.getInstance();
            this.defaultGroup = websvcListModel.getWebServiceGroup("default");
            if (this.defaultGroup == null) {
                this.defaultGroup = new WebServiceGroup("default");
            }
            websvcListModel.addWebServiceGroup(this.defaultGroup);
            this.defaultGroup.addWebServiceGroupListener(this);
            websvcListModel.addWebServiceListModelListener(this);
        }
        return this.defaultGroup;
    }

    protected void addNotify() {
        super.addNotify();
        this.getDefaultGroup();
        this.updateKeys();
    }

    private void updateKeys() {
        WebServiceListModel websvcListModel = WebServiceListModel.getInstance();
        Object[] keys = new WebServiceGroup[websvcListModel.getWebServiceGroupSet().size()];
        Iterator iter = websvcListModel.getWebServiceGroupSet().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            keys[counter++] = (WebServiceGroup)iter.next();
        }
        this.setKeys(keys);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        if (key instanceof WebServiceGroup) {
            WebServiceGroup wsGroup = (WebServiceGroup)key;
            if (wsGroup.getId().equals(this.getDefaultGroup().getId())) {
                WebServiceListModel websvcListModel = WebServiceListModel.getInstance();
                Iterator iter = this.getDefaultGroup().getWebServiceIds().iterator();
                while (iter.hasNext()) {
                    WebServiceData wsData = websvcListModel.getWebService((String)iter.next());
                    nodes.add(new WebServicesNode(wsData));
                }
            } else {
                nodes.add(new WebServiceGroupNode(wsGroup));
            }
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    public void webServiceGroupAdded(WebServiceListModelEvent modelEvent) {
        this.updateKeys();
    }

    public void webServiceGroupRemoved(WebServiceListModelEvent modelEvent) {
        this.updateKeys();
    }

    public void webServiceAdded(WebServiceGroupEvent groupEvent) {
        this.updateKeys();
        this.refreshKey(this.getDefaultGroup());
    }

    public void webServiceRemoved(WebServiceGroupEvent groupEvent) {
        this.refreshKey(this.getDefaultGroup());
    }
}

