/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceGroupEvent;
import org.netbeans.modules.websvc.registry.model.WebServiceGroupListener;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;

public class WebServiceGroup {
    Set listeners = new HashSet();
    String groupId = null;
    String groupName = null;
    Set webserviceIds = new HashSet();

    public WebServiceGroup() {
        this(WebServiceListModel.getInstance().getUniqueWebServiceGroupId());
    }

    public WebServiceGroup(String id) {
        this.setId(id);
    }

    public void addWebServiceGroupListener(WebServiceGroupListener listener) {
        this.listeners.add(listener);
    }

    public void removeWebServiceGroupListener(WebServiceGroupListener listener) {
        this.listeners.remove(listener);
    }

    public void setId(String id) {
        this.groupId = id;
    }

    public String getId() {
        return this.groupId;
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String name) {
        this.groupName = name;
    }

    public void add(String webServiceId) {
        if (!this.webserviceIds.contains(webServiceId)) {
            WebServiceData wsData = WebServiceListModel.getInstance().getWebService(webServiceId);
            wsData.setGroupId(this.getId());
            this.webserviceIds.add(webServiceId);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceGroupEvent evt = new WebServiceGroupEvent(webServiceId);
                ((WebServiceGroupListener)iter.next()).webServiceAdded(evt);
            }
        }
    }

    public void remove(String webServiceId) {
        if (this.webserviceIds.contains(webServiceId)) {
            this.webserviceIds.remove(webServiceId);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceGroupEvent evt = new WebServiceGroupEvent(webServiceId);
                ((WebServiceGroupListener)iter.next()).webServiceRemoved(evt);
            }
        }
    }

    public void setWebServiceIds(Set ids) {
        this.webserviceIds = ids;
        Iterator iter = this.webserviceIds.iterator();
        while (iter.hasNext()) {
            WebServiceData wsData = WebServiceListModel.getInstance().getWebService((String)iter.next());
            wsData.setGroupId(this.getId());
        }
    }

    public Set getWebServiceIds() {
        return this.webserviceIds;
    }
}

