/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.actions;

import java.io.IOException;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.nodes.WebServiceGroupCookie;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class DeleteWebServiceGroupAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length > 0 && nodes[0].getCookie(WebServiceGroupCookie.class) != null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/websvc/registry/resources/MyActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(DeleteWebServiceGroupAction.class, (String)"DELETE");
    }

    protected void performAction(Node[] nodes) {
        WebServiceGroupCookie groupCookie;
        if (null != nodes && nodes.length > 0 && (groupCookie = (WebServiceGroupCookie)nodes[0].getCookie(WebServiceGroupCookie.class)) != null) {
            WebServiceGroup wsGroup = groupCookie.getWebServiceGroup();
            String groupName = null;
            if (null != wsGroup) {
                groupName = wsGroup.getName();
            }
            String msg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"WS_DELETE_GROUP") + " " + groupName;
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, 0);
            Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            if (null != response && response.equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    nodes[0].destroy();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DeleteWebServiceGroupAction.class, (String)"ERROR_DELETING"));
                }
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

