/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.viewmodel.Column;
import org.netbeans.modules.viewmodel.DefaultColumn;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.windows.TopComponent;

public class TreeTable
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener {
    private ExplorerManager explorerManager;
    private MyTreeTable treeTable;
    private Node.Property[] columns;
    private List expandedPaths = new ArrayList();
    private TreeModelRoot currentTreeModelRoot;
    private Models.CompoundModel model;

    public TreeTable() {
        this.setLayout(new BorderLayout());
        this.treeTable = new MyTreeTable();
        this.treeTable.setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        this.add((Component)((Object)this.treeTable), "Center");
        this.treeTable.getTree().addTreeExpansionListener(this);
        ActionMap map = this.getActionMap();
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)false));
    }

    public void setModel(Models.CompoundModel model) {
        this.model = model;
        if (this.currentTreeModelRoot != null) {
            this.currentTreeModelRoot.destroy();
        }
        List ep = this.treeTable.getExpandedPaths();
        this.saveWidths();
        if (model == null) {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
            return;
        }
        this.columns = this.createColumns(model);
        this.currentTreeModelRoot = new TreeModelRoot(model, this);
        TreeModelNode rootNode = this.currentTreeModelRoot.getRootNode();
        this.getExplorerManager().setRootContext((Node)rootNode);
        this.treeTable.setProperties(this.columns);
        this.updateColumnWidths();
        this.treeTable.expandNodes(this.expandedPaths);
        if (ep.size() > 0) {
            this.expandedPaths = ep;
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (tc == null) {
            return;
        }
        if (propertyName.equals("currentNodes")) {
            ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)this.equalNodes());
        } else if (propertyName.equals("selectedNodes")) {
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object obj = Visualizer.findNode((Object)event.getPath().getLastPathComponent()).getLookup().lookup(Object.class);
        this.model.nodeExpanded(obj);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        Object obj = Visualizer.findNode((Object)event.getPath().getLastPathComponent()).getLookup().lookup(Object.class);
        this.model.nodeCollapsed(obj);
    }

    private boolean equalNodes() {
        Node[] ns2;
        Node[] ns1 = TopComponent.getRegistry().getCurrentNodes();
        if (ns1 == (ns2 = this.getExplorerManager().getSelectedNodes())) {
            return true;
        }
        if (ns1 == null || ns2 == null) {
            return false;
        }
        if (ns1.length != ns2.length) {
            return false;
        }
        int k = ns1.length;
        for (int i = 0; i < k; ++i) {
            if (ns1[i].equals((Object)ns2[i])) continue;
            return false;
        }
        return true;
    }

    private Node.Property[] createColumns(Models.CompoundModel model) {
        ColumnModel[] cs = model.getColumns();
        int k = cs.length;
        Column[] columns = new Column[k];
        boolean addDefaultColumn = true;
        for (int i = 0; i < k; ++i) {
            columns[i] = new Column(cs[i], this);
            if (cs[i].getType() != null) continue;
            addDefaultColumn = false;
        }
        if (!addDefaultColumn) {
            this.setMnemonics((Node.Property[])columns);
            return columns;
        }
        PropertySupport.ReadWrite[] columns2 = new PropertySupport.ReadWrite[columns.length + 1];
        System.arraycopy(columns, 0, columns2, 1, columns.length);
        columns2[0] = new DefaultColumn();
        this.setMnemonics((Node.Property[])columns2);
        return columns2;
    }

    private void setMnemonics(Node.Property[] properties) {
        HashSet<String> mnemonicsUsed = new HashSet<String>();
        block0: for (int i = 0; i < properties.length; ++i) {
            String name = properties[i].getDisplayName();
            for (int j = 0; j < name.length(); ++j) {
                String c = name.substring(j, j + 1);
                String lc = c.toLowerCase();
                if (mnemonicsUsed.contains(lc)) continue;
                mnemonicsUsed.add(lc);
                properties[i].setValue("ColumnMnemonicCharTTV", (Object)c);
                continue block0;
            }
        }
    }

    void updateColumnWidths() {
        int k = this.columns.length;
        for (int i = 0; i < k; ++i) {
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || !(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            if (column.isDefault()) {
                int width = column.getColumnWidth();
                this.treeTable.setTreePreferredWidth(width);
                continue;
            }
            int order = column.getOrderNumber();
            if (order == -1) continue;
            int width = column.getColumnWidth();
            this.treeTable.setTableColumnPreferredWidth(order, width);
        }
    }

    private void saveWidths() {
        if (this.columns == null) {
            return;
        }
        int k = this.columns.length;
        for (int i = 0; i < k; ++i) {
            TableColumn tc;
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || !(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            if (column.isDefault()) {
                TableColumn tc2 = this.treeTable.getTable().getColumnModel().getColumn(0);
                if (tc2 == null) continue;
                int width = tc2.getWidth();
                column.setColumnWidth(width);
                continue;
            }
            int order = column.getOrderNumber();
            if (order == -1 || (tc = this.treeTable.getTable().getColumnModel().getColumn(order + 1)) == null) continue;
            int width = tc.getWidth();
            column.setColumnWidth(width);
        }
    }

    private void expandDefault(Object[] nodes) {
        int k = nodes.length;
        for (int i = 0; i < k; ++i) {
            try {
                if (!this.model.isExpanded(nodes[i])) continue;
                this.expandNode(nodes[i]);
                continue;
            }
            catch (UnknownTypeException ex) {
                // empty catch block
            }
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeTable.requestFocusInWindow();
    }

    public void addNotify() {
        super.addNotify();
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeNotify() {
        super.removeNotify();
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean isExpanded(Object node) {
        TreeModelNode n = this.currentTreeModelRoot.findNode(node);
        if (n == null) {
            return false;
        }
        return this.treeTable.isExpanded((Node)n);
    }

    public void expandNode(Object node) {
        TreeModelNode n = this.currentTreeModelRoot.findNode(node);
        if (this.treeTable != null && n != null) {
            this.treeTable.expandNode((Node)n);
        }
    }

    public void collapseNode(Object node) {
        TreeModelNode n = this.currentTreeModelRoot.findNode(node);
        this.treeTable.collapseNode((Node)n);
    }

    private static class MyTreeTable
    extends TreeTableView {
        MyTreeTable() {
            this.treeTable.setShowHorizontalLines(true);
            this.treeTable.setShowVerticalLines(false);
        }

        JTable getTable() {
            return this.treeTable;
        }

        JTree getTree() {
            return this.tree;
        }

        public List getExpandedPaths() {
            ArrayList<String[]> result = new ArrayList<String[]>();
            ExplorerManager em = ExplorerManager.find((Component)((Object)this));
            TreeNode rtn = Visualizer.findVisualizer((Node)em.getRootContext());
            TreePath tp = new TreePath(rtn);
            Enumeration<TreePath> exPaths = this.tree.getExpandedDescendants(tp);
            if (exPaths == null) {
                return result;
            }
            while (exPaths.hasMoreElements()) {
                TreePath ep = exPaths.nextElement();
                Node en = Visualizer.findNode((Object)ep.getLastPathComponent());
                String[] path = NodeOp.createPath((Node)en, (Node)em.getRootContext());
                result.add(path);
            }
            return result;
        }

        public void expandNodes(List exPaths) {
            Iterator it = exPaths.iterator();
            while (it.hasNext()) {
                String[] sp = (String[])it.next();
                TreePath tp = this.stringPath2TreePath(sp);
                if (tp == null) continue;
                this.showPath(tp);
            }
        }

        private TreePath stringPath2TreePath(String[] sp) {
            ExplorerManager em = ExplorerManager.find((Component)((Object)this));
            try {
                Node n = NodeOp.findPath((Node)em.getRootContext(), (String[])sp);
                Object[] tns = new TreeNode[sp.length + 1];
                for (int i = sp.length; i >= 0; --i) {
                    tns[i] = Visualizer.findVisualizer((Node)n);
                    n = n.getParentNode();
                }
                return new TreePath(tns);
            }
            catch (NodeNotFoundException e) {
                return null;
            }
        }
    }
}

