/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.viewmodel.ExceptionNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class TreeModelNode
extends AbstractNode {
    private static final int MAX_HTML_LENGTH = 511;
    private Models.CompoundModel model;
    private TreeModelRoot treeModelRoot;
    private Object object;
    private String htmlDisplayName;
    private Map properties = new HashMap();
    private RequestProcessor.Task task;
    private static RequestProcessor requestProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$viewmodel$TreeModelNode;
    static /* synthetic */ Class class$java$lang$String;

    public TreeModelNode(Models.CompoundModel model, TreeModelRoot treeModelRoot, Object object) {
        super(TreeModelNode.createChildren(model, treeModelRoot, object), Lookups.singleton((Object)object));
        this.model = model;
        this.treeModelRoot = treeModelRoot;
        this.object = object;
        if (model.getHelpId() != null) {
            this.setValue("propertiesHelpID", model.getHelpId());
        }
        treeModelRoot.registerNode(object, this);
        this.refreshNode();
        this.initProperties();
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ColumnModel[] columns = this.model.getColumns();
        int k = columns.length;
        for (int i = 0; i < k; ++i) {
            ps.put((Node.Property)new MyProperty(columns[i], this.treeModelRoot));
        }
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static Children createChildren(Models.CompoundModel model, TreeModelRoot treeModelRoot, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            return model.isLeaf(object) ? Children.LEAF : new TreeModelChildren(model, treeModelRoot, object);
        }
        catch (UnknownTypeException e) {
            if (!(object instanceof String)) {
                Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + model);
                ErrorManager.getDefault().notify(1, t);
            }
            return Children.LEAF;
        }
    }

    public String getShortDescription() {
        try {
            String shortDescription = this.model.getShortDescription(this.object);
            return shortDescription;
        }
        catch (UnknownTypeException e) {
            if (!(this.object instanceof String)) {
                Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + this.model);
                ErrorManager.getDefault().notify(1, t);
            }
            return null;
        }
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return this.treeModelRoot.getRootNode().getActions(false);
        }
        try {
            return this.model.getActions(this.object);
        }
        catch (UnknownTypeException e) {
            return new Action[0];
        }
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TreeModelNode.this.model.performDefaultAction(TreeModelNode.this.object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    // empty catch block
                }
            }
        };
    }

    public boolean canDestroy() {
        try {
            Action[] as = this.model.getActions(this.object);
            int k = as.length;
            for (int i = 0; i < k; ++i) {
                Object key;
                if (as[i] == null || (key = as[i].getValue("AcceleratorKey")) == null || !key.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                return as[i].isEnabled();
            }
            return false;
        }
        catch (UnknownTypeException e) {
            return false;
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void destroy() {
        try {
            Action[] as = this.model.getActions(this.object);
            int k = as.length;
            for (int i = 0; i < k; ++i) {
                Object key;
                if (as[i] == null || (key = as[i].getValue("AcceleratorKey")) == null || !key.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                as[i].actionPerformed(null);
                return;
            }
        }
        catch (UnknownTypeException e) {
            Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, t);
        }
    }

    void setObject(Object o) {
        this.setObjectNoRefresh(o);
        this.refresh();
    }

    private void setObjectNoRefresh(Object o) {
        this.object = o;
        Children ch = this.getChildren();
        if (ch instanceof TreeModelChildren) {
            ((TreeModelChildren)ch).object = o;
        }
    }

    public Object getObject() {
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        this.htmlDisplayName = null;
        Map map = this.properties;
        synchronized (map) {
            this.properties.clear();
        }
        if (this.task == null) {
            this.task = TreeModelNode.getRequestProcessor().create(new Runnable(){

                public void run() {
                    TreeModelNode.this.refreshNode();
                    TreeModelNode.this.fireShortDescriptionChange(null, null);
                    TreeModelNode.this.refreshTheChildren(true);
                }
            });
        }
        this.task.schedule(0);
    }

    void refresh(int changeMask) {
        block15: {
            if (changeMask == -1) {
                this.refresh();
                return;
            }
            if ((1 & changeMask) != 0) {
                this.htmlDisplayName = null;
                try {
                    String name = this.model.getDisplayName(this.object);
                    if (name == null) {
                        NullPointerException t = new NullPointerException("Model: " + this.model + ".getDisplayName (" + this.object + ") = null!");
                        ErrorManager.getDefault().notify((Throwable)t);
                    }
                    this.setName(name, false);
                }
                catch (UnknownTypeException e) {
                    Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + this.model);
                    ErrorManager.getDefault().notify(1, t);
                }
            } else if ((2 & changeMask) != 0) {
                try {
                    String iconBase = this.model.getIconBase(this.object);
                    if (iconBase != null) {
                        this.setIconBase(iconBase);
                        break block15;
                    }
                    this.setIconBase("org/openide/resources/actions/empty");
                }
                catch (UnknownTypeException e) {
                    Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + this.model);
                    ErrorManager.getDefault().notify(1, t);
                }
            } else if ((4 & changeMask) != 0) {
                this.fireShortDescriptionChange(null, null);
            } else if ((8 & changeMask) != 0) {
                TreeModelNode.getRequestProcessor().post(new Runnable(){

                    public void run() {
                        TreeModelNode.this.refreshTheChildren(false);
                    }
                });
            } else {
                this.refresh();
            }
        }
    }

    public static RequestProcessor getRequestProcessor() {
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("TreeModel");
        }
        return requestProcessor;
    }

    private void setName(String name, boolean italics) {
        if (name.startsWith("<html>")) {
            if (italics && name.indexOf("<i>") < 0) {
                name = "<html><i>" + name.substring(6, name.length() - 7) + "</i></html>";
            }
            this.htmlDisplayName = name;
            this.setDisplayName(name.substring(6, name.length() - 7));
        } else {
            this.htmlDisplayName = null;
            this.setDisplayName(name);
        }
    }

    private void refreshNode() {
        try {
            String name = this.model.getDisplayName(this.object);
            if (name == null) {
                NullPointerException t = new NullPointerException("Model: " + this.model + ".getDisplayName (" + this.object + ") = null!");
                ErrorManager.getDefault().notify((Throwable)t);
            }
            this.setName(name, false);
            String iconBase = this.model.getIconBase(this.object);
            if (iconBase != null) {
                this.setIconBase(iconBase);
            } else {
                this.setIconBase("org/openide/resources/actions/empty");
            }
            this.firePropertyChange(null, null, null);
        }
        catch (UnknownTypeException e) {
            Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumn(String column) {
        Map map = this.properties;
        synchronized (map) {
            this.properties.remove(column);
            this.properties.remove(column + "#html");
        }
        this.firePropertyChange(column, null, null);
    }

    private void refreshTheChildren(boolean refreshSubNodes) {
        Children ch = this.getChildren();
        try {
            if (ch instanceof TreeModelChildren) {
                ((TreeModelChildren)ch).refreshChildren(refreshSubNodes);
            } else if (!this.model.isLeaf(this.object)) {
                this.setChildren((Children)new TreeModelChildren(this.model, this.treeModelRoot, this.object));
            }
        }
        catch (UnknownTypeException utex) {
            if (!(this.object instanceof String)) {
                Throwable t = ErrorManager.getDefault().annotate((Throwable)utex, "Model: " + this.model);
                ErrorManager.getDefault().notify(1, t);
            }
            this.setChildren(Children.LEAF);
        }
    }

    private static String i(String text) {
        if (text.startsWith("<html>")) {
            if (text.indexOf("<i>") > 0) {
                return text;
            }
            text = text.substring(6, text.length() - 7);
        }
        return "<html><font color=666666>" + text + "</font></html>";
    }

    private static String htmlValue(String name) {
        if (!name.startsWith("<html>")) {
            return null;
        }
        if (name.length() > 511) {
            int endTagsPos = TreeModelNode.findEndTagsPos(name);
            String ending = name.substring(endTagsPos + 1);
            name = name.substring(0, 508 - ending.length());
            int n = name.length();
            for (int i = n - 1; i > n - 6 && name.charAt(i) != ';'; --i) {
                if (name.charAt(i) != '&') continue;
                name = name.substring(0, i);
                break;
            }
            name = name + "..." + ending;
        }
        return name;
    }

    private static int findEndTagsPos(String s) {
        int i;
        int openings = 0;
        for (i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '>') {
                ++openings;
                continue;
            }
            if (s.charAt(i) == '<') {
                --openings;
                continue;
            }
            if (openings == 0) break;
        }
        return i;
    }

    private static String removeHTML(String text) {
        text = text.replaceAll("<i>", "");
        text = text.replaceAll("</i>", "");
        text = text.replaceAll("<b>", "");
        text = text.replaceAll("</b>", "");
        text = text.replaceAll("<html>", "");
        text = text.replaceAll("</html>", "");
        text = text.replaceAll("</font>", "");
        int i = text.indexOf("<font");
        while (i >= 0) {
            int j = text.indexOf(">", i);
            text = text.substring(0, i) + text.substring(j + 1);
            i = text.indexOf("<font");
        }
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("&amp;", "&");
        return text;
    }

    static class LazyEvaluator
    implements Runnable {
        private static final long EXPIRE_TIME = 60000L;
        private List objectsToEvaluate = new LinkedList();
        private Evaluable currentlyEvaluating;
        private RequestProcessor.Task evalTask = new RequestProcessor("Debugger Values Evaluator", 1).post((Runnable)this);

        public void evaluate(Evaluable eval) {
            this.evaluate(eval, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate(Evaluable eval, boolean checkForEvaluating) {
            List list = this.objectsToEvaluate;
            synchronized (list) {
                Iterator it = this.objectsToEvaluate.iterator();
                while (it.hasNext()) {
                    if (eval != it.next()) continue;
                    return;
                }
                if (checkForEvaluating && this.currentlyEvaluating == eval) {
                    return;
                }
                this.objectsToEvaluate.add(eval);
                this.objectsToEvaluate.notify();
                if (this.evalTask.isFinished()) {
                    this.evalTask.schedule(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Evaluable eval;
                List list = this.objectsToEvaluate;
                synchronized (list) {
                    if (this.objectsToEvaluate.size() == 0) {
                        try {
                            this.objectsToEvaluate.wait(60000L);
                        }
                        catch (InterruptedException iex) {
                            return;
                        }
                        if (this.objectsToEvaluate.size() == 0) {
                            return;
                        }
                    }
                    this.currentlyEvaluating = eval = (Evaluable)this.objectsToEvaluate.remove(0);
                }
                Runnable evaluatedNotify = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = LazyEvaluator.this.objectsToEvaluate;
                        synchronized (list) {
                            LazyEvaluator.this.currentlyEvaluating = null;
                        }
                    }
                };
                eval.evaluateLazily(evaluatedNotify);
            }
        }

        public static interface Evaluable {
            public void evaluateLazily(Runnable var1);
        }
    }

    private class MyProperty
    extends PropertySupport
    implements LazyEvaluator.Evaluable {
        private final String EVALUATING_STR;
        private String id;
        private ColumnModel columnModel;
        private TreeModelRoot treeModelRoot;
        private int[] evaluated;

        MyProperty(ColumnModel columnModel, TreeModelRoot treeModelRoot) {
            super(columnModel.getID(), columnModel.getType(), columnModel.getDisplayName(), columnModel.getShortDescription(), true, true);
            this.EVALUATING_STR = NbBundle.getMessage((Class)(class$org$netbeans$modules$viewmodel$TreeModelNode == null ? (class$org$netbeans$modules$viewmodel$TreeModelNode = TreeModelNode.class$("org.netbeans.modules.viewmodel.TreeModelNode")) : class$org$netbeans$modules$viewmodel$TreeModelNode), (String)"EvaluatingProp");
            this.evaluated = new int[]{0};
            this.columnModel = columnModel;
            this.treeModelRoot = treeModelRoot;
            this.id = columnModel.getID();
        }

        public boolean canWrite() {
            try {
                return !TreeModelNode.this.model.isReadOnly(TreeModelNode.this.object, this.columnModel.getID());
            }
            catch (UnknownTypeException e) {
                if (!(TreeModelNode.this.object instanceof String)) {
                    Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model);
                    ErrorManager.getDefault().notify(1, t);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void evaluateLazily(Runnable evaluatedNotify) {
            Object value = "";
            String htmlValue = null;
            String nonHtmlValue = null;
            try {
                block24: {
                    try {
                        value = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                        if (!(value instanceof String)) break block24;
                        htmlValue = TreeModelNode.htmlValue((String)value);
                        nonHtmlValue = TreeModelNode.removeHTML((String)value);
                    }
                    catch (UnknownTypeException e) {
                        if (!(TreeModelNode.this.object instanceof String)) {
                            e.printStackTrace();
                            System.out.println("  Column id:" + this.columnModel.getID());
                            System.out.println(TreeModelNode.this.model);
                            System.out.println();
                        }
                        Object var7_6 = null;
                        evaluatedNotify.run();
                        Map map = TreeModelNode.this.properties;
                        // MONITORENTER : map
                        if (value instanceof String) {
                            TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                            TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                        } else {
                            TreeModelNode.this.properties.put(this.id, value);
                        }
                        int[] nArray = this.evaluated;
                        // MONITORENTER : this.evaluated
                        boolean fire = this.evaluated[0] == -1;
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                        // MONITOREXIT : nArray
                        // MONITOREXIT : map
                        if (!fire) return;
                        TreeModelNode.this.firePropertyChange(this.id, null, value);
                        TreeModelNode.this.refreshTheChildren(true);
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Object var7_7 = null;
                        evaluatedNotify.run();
                        Map map = TreeModelNode.this.properties;
                        // MONITORENTER : map
                        if (value instanceof String) {
                            TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                            TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                        } else {
                            TreeModelNode.this.properties.put(this.id, value);
                        }
                        int[] nArray = this.evaluated;
                        // MONITORENTER : this.evaluated
                        boolean fire = this.evaluated[0] == -1;
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                        // MONITOREXIT : nArray
                        // MONITOREXIT : map
                        if (!fire) return;
                        TreeModelNode.this.firePropertyChange(this.id, null, value);
                        TreeModelNode.this.refreshTheChildren(true);
                        return;
                    }
                }
                Object var7_5 = null;
                evaluatedNotify.run();
                Map map = TreeModelNode.this.properties;
                // MONITORENTER : map
                if (value instanceof String) {
                    TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                    TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                } else {
                    TreeModelNode.this.properties.put(this.id, value);
                }
                int[] nArray = this.evaluated;
                // MONITORENTER : this.evaluated
                boolean fire = this.evaluated[0] == -1;
                this.evaluated[0] = 1;
                this.evaluated.notifyAll();
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                if (!fire) return;
                TreeModelNode.this.firePropertyChange(this.id, null, value);
                TreeModelNode.this.refreshTheChildren(true);
                return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                evaluatedNotify.run();
                Map map = TreeModelNode.this.properties;
                // MONITORENTER : map
                if (value instanceof String) {
                    TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                    TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                } else {
                    TreeModelNode.this.properties.put(this.id, value);
                }
                int[] nArray = this.evaluated;
                // MONITORENTER : this.evaluated
                boolean fire = this.evaluated[0] == -1;
                this.evaluated[0] = 1;
                this.evaluated.notifyAll();
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                if (!fire) throw throwable;
                TreeModelNode.this.firePropertyChange(this.id, null, value);
                TreeModelNode.this.refreshTheChildren(true);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized Object getValue() {
            Object object = TreeModelNode.this.properties;
            // MONITORENTER : object
            if (TreeModelNode.this.properties.containsKey(this.id)) {
                // MONITOREXIT : object
                return TreeModelNode.this.properties.get(this.id);
            }
            // MONITOREXIT : object
            object = this.evaluated;
            // MONITORENTER : this.evaluated
            this.evaluated[0] = 0;
            // MONITOREXIT : object
            this.treeModelRoot.getValuesEvaluator().evaluate(this);
            String ret = null;
            boolean refreshChildren = false;
            Object object2 = this.evaluated;
            // MONITORENTER : this.evaluated
            if (this.evaluated[0] != 1) {
                try {
                    this.evaluated.wait(25L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                if (this.evaluated[0] != 1) {
                    this.evaluated[0] = -1;
                    ret = this.EVALUATING_STR;
                } else {
                    refreshChildren = true;
                }
            }
            // MONITOREXIT : object2
            if (ret == null) {
                Map map = TreeModelNode.this.properties;
                object2 = map;
                // MONITORENTER : map
                ret = TreeModelNode.this.properties.get(this.id);
                // MONITOREXIT : object2
            }
            if (refreshChildren) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        TreeModelNode.this.refreshTheChildren(true);
                    }
                });
            }
            if (ret != this.EVALUATING_STR) return ret;
            if (this.getValueType() == null) return ret;
            if (this.getValueType() == (class$java$lang$String == null ? (class$java$lang$String = TreeModelNode.class$("java.lang.String")) : class$java$lang$String)) return ret;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(String attributeName) {
            if (attributeName.equals("htmlDisplayValue")) {
                Object object = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return "<html><font color=\"0000CC\">" + this.EVALUATING_STR + "</font></html>";
                    }
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    Map map = TreeModelNode.this.properties;
                    object = map;
                    synchronized (map) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return TreeModelNode.this.properties.get(this.id + "#html");
                    }
                }
            }
            return super.getValue(attributeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object v) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                TreeModelNode.this.model.setValueAt(TreeModelNode.this.object, this.id, v);
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    TreeModelNode.this.properties.put(this.id, v);
                }
                TreeModelNode.this.firePropertyChange(this.id, null, null);
            }
            catch (UnknownTypeException e) {
                Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model);
                ErrorManager.getDefault().notify(1, t);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.columnModel.getPropertyEditor();
        }
    }

    private static final class TreeModelChildren
    extends Children.Keys
    implements LazyEvaluator.Evaluable {
        private boolean initialezed = false;
        private Models.CompoundModel model;
        private TreeModelRoot treeModelRoot;
        private Object object;
        private WeakHashMap objectToNode = new WeakHashMap();
        private int[] evaluated = new int[]{0};
        private Object[] children_evaluated;
        private boolean refreshingSubNodes = true;
        private boolean refreshingStarted = true;
        private static final Object WAIT_KEY = new Object();

        TreeModelChildren(Models.CompoundModel model, TreeModelRoot treeModelRoot, Object object) {
            this.model = model;
            this.treeModelRoot = treeModelRoot;
            this.object = object;
        }

        protected void addNotify() {
            this.initialezed = true;
            this.refreshChildren(true);
        }

        protected void removeNotify() {
            this.initialezed = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        void refreshChildren(boolean refreshSubNodes) {
            if (!this.initialezed) {
                return;
            }
            this.refreshLazyChildren(refreshSubNodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluateLazily(Runnable evaluatedNotify) {
            int[] nArray = this.evaluated;
            synchronized (this.evaluated) {
                Object[] ch;
                this.refreshingStarted = false;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                try {
                    int count = this.model.getChildrenCount(this.object);
                    ch = this.model.getChildren(this.object, 0, count);
                }
                catch (UnknownTypeException e) {
                    ch = new Object[]{};
                    if (!(this.object instanceof String)) {
                        Throwable t = ErrorManager.getDefault().annotate((Throwable)e, "Model: " + this.model);
                        ErrorManager.getDefault().notify(1, t);
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    ErrorManager.getDefault().notify(t);
                    ch = new Object[]{};
                }
                evaluatedNotify.run();
                int[] nArray2 = this.evaluated;
                synchronized (this.evaluated) {
                    boolean fire;
                    int eval = this.evaluated[0];
                    if (this.refreshingStarted) {
                        fire = false;
                    } else {
                        boolean bl = fire = this.evaluated[0] == -1;
                        if (!fire) {
                            this.children_evaluated = ch;
                        }
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                    }
                    // ** MonitorExit[var4_9] (shouldn't be in output)
                    if (fire) {
                        this.applyChildren(ch, this.refreshingSubNodes);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLazyChildren(boolean refreshSubNodes) {
            int[] nArray = this.evaluated;
            synchronized (this.evaluated) {
                this.evaluated[0] = 0;
                this.refreshingStarted = true;
                this.refreshingSubNodes = refreshSubNodes;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.treeModelRoot.getChildrenEvaluator().evaluate(this, false);
                int[] nArray2 = this.evaluated;
                synchronized (this.evaluated) {
                    Object[] ch;
                    if (this.evaluated[0] != 1) {
                        try {
                            this.evaluated.wait(200L);
                        }
                        catch (InterruptedException iex) {
                            // empty catch block
                        }
                        if (this.evaluated[0] != 1) {
                            this.evaluated[0] = -1;
                            ch = null;
                        } else {
                            ch = this.children_evaluated;
                        }
                    } else {
                        ch = this.children_evaluated;
                    }
                    if (this.children_evaluated == null && this.evaluated[0] == 1) {
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        return;
                    }
                    this.children_evaluated = null;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    if (ch == null) {
                        this.applyWaitChildren();
                    } else {
                        this.applyChildren(ch, refreshSubNodes);
                    }
                    return;
                }
            }
        }

        private void applyChildren(final Object[] ch, boolean refreshSubNodes) {
            int k = ch.length;
            WeakHashMap<Object, WeakReference> newObjectToNode = new WeakHashMap<Object, WeakReference>();
            for (int i = 0; i < k; ++i) {
                TreeModelNode tmn;
                if (ch[i] == null) {
                    throw (NullPointerException)ErrorManager.getDefault().annotate((Throwable)new NullPointerException(), "model: " + this.model + "\nparent: " + this.object);
                }
                WeakReference wr = (WeakReference)this.objectToNode.get(ch[i]);
                if (wr == null || (tmn = (TreeModelNode)((Object)wr.get())) == null) continue;
                if (refreshSubNodes) {
                    tmn.setObject(ch[i]);
                } else {
                    tmn.setObjectNoRefresh(ch[i]);
                }
                newObjectToNode.put(ch[i], wr);
            }
            this.objectToNode = newObjectToNode;
            this.setKeys(ch);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int k = ch.length;
                    for (int i = 0; i < k; ++i) {
                        try {
                            TreeTable treeTable;
                            if (!TreeModelChildren.this.model.isExpanded(ch[i]) || !(treeTable = TreeModelChildren.this.treeModelRoot.getTreeTable()).isExpanded(TreeModelChildren.this.object)) continue;
                            treeTable.expandNode(ch[i]);
                            continue;
                        }
                        catch (UnknownTypeException unknownTypeException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        private void applyWaitChildren() {
            this.setKeys(new Object[]{WAIT_KEY});
        }

        protected Node[] createNodes(Object object) {
            if (object == WAIT_KEY) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$viewmodel$TreeModelNode == null ? (class$org$netbeans$modules$viewmodel$TreeModelNode = TreeModelNode.class$("org.netbeans.modules.viewmodel.TreeModelNode")) : class$org$netbeans$modules$viewmodel$TreeModelNode), (String)"WaitNode"));
                n.setIconBase("org/netbeans/modules/viewmodel/wait");
                return new Node[]{n};
            }
            if (object instanceof Exception) {
                return new Node[]{new ExceptionNode((Exception)object)};
            }
            TreeModelNode tmn = new TreeModelNode(this.model, this.treeModelRoot, object);
            this.objectToNode.put(object, new WeakReference<TreeModelNode>(tmn));
            return new Node[]{tmn};
        }
    }
}

