/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.loader;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.FileRecognitionPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.NameAndLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

final class NewLoaderIterator
extends BasicWizardIterator {
    private DataModel data;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NewLoaderIterator() {
    }

    public static NewLoaderIterator createIterator() {
        return new NewLoaderIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return this.getCreatedFiles(cmf, this.data.getProject());
    }

    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new FileRecognitionPanel(wiz, this.data), new NameAndLocationPanel(wiz, this.data)};
    }

    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    public static void generateFileChanges(DataModel model) {
        String suffix;
        URL template;
        HashMap<String, String> replaceTokens;
        String namePrefix;
        CreatedModifiedFiles fileChanges;
        block11: {
            fileChanges = new CreatedModifiedFiles(model.getProject());
            namePrefix = model.getPrefix();
            String packageName = model.getPackageName();
            final String mime = model.getMimeType();
            replaceTokens = new HashMap<String, String>();
            replaceTokens.put("@@PREFIX@@", namePrefix);
            replaceTokens.put("@@PACKAGENAME@@", packageName);
            replaceTokens.put("@@MIMETYPE@@", mime);
            replaceTokens.put("@@EXTENSIONS@@", NewLoaderIterator.formatExtensions(model.isExtensionBased(), model.getExtension(), mime));
            replaceTokens.put("@@NAMESPACES@@", NewLoaderIterator.formatNameSpace(model.isExtensionBased(), model.getNamespace(), mime));
            String origIconPath = model.getIconPath();
            if (origIconPath != null && new File(origIconPath).exists()) {
                String relativeIconPath = model.addCreateIconOperation(fileChanges, origIconPath);
                replaceTokens.put("@@IMAGESNIPPET@@", NewLoaderIterator.formatImageSnippet(relativeIconPath));
                replaceTokens.put("@@ICONPATH@@", relativeIconPath);
                replaceTokens.put("@@COMMENTICON@@", "");
            } else {
                replaceTokens.put("@@IMAGESNIPPET@@", NewLoaderIterator.formatImageSnippet(null));
                replaceTokens.put("@@ICONPATH@@", "SET/PATH/TO/ICON/HERE");
                replaceTokens.put("@@COMMENTICON@@", "//");
            }
            String loaderName = model.getDefaultPackagePath(namePrefix + "DataLoader.java");
            template = NewLoaderIterator.class.getResource("templateDataLoader.javx");
            fileChanges.add(fileChanges.createFileWithSubstitutions(loaderName, template, replaceTokens));
            String loaderInfoName = model.getDefaultPackagePath(namePrefix + "DataLoaderBeanInfo.java");
            template = NewLoaderIterator.class.getResource("templateDataLoaderBeanInfo.javx");
            fileChanges.add(fileChanges.createFileWithSubstitutions(loaderInfoName, template, replaceTokens));
            final boolean isEditable = Pattern.matches("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.+-])*)", mime);
            if (isEditable) {
                StringBuffer editorBuf = new StringBuffer();
                editorBuf.append("        CookieSet cookies = getCookieSet();\n");
                editorBuf.append("        cookies.add((Node.Cookie) DataEditorSupport.create(this, getPrimaryEntry(), cookies));");
                replaceTokens.put("@@EDITOR_SUPPORT_SNIPPET@@", editorBuf.toString());
                replaceTokens.put("@@EDITOR_SUPPORT_IMPORT@@", "import org.openide.text.DataEditorSupport;");
            } else {
                replaceTokens.put("@@EDITOR_SUPPORT_SNIPPET@@", "");
                replaceTokens.put("@@EDITOR_SUPPORT_IMPORT@@", "");
            }
            String doName = model.getDefaultPackagePath(namePrefix + "DataObject.java");
            template = NewLoaderIterator.class.getResource("templateDataObject.javx");
            fileChanges.add(fileChanges.createFileWithSubstitutions(doName, template, replaceTokens));
            String nodeName = model.getDefaultPackagePath(namePrefix + "DataNode.java");
            template = NewLoaderIterator.class.getResource("templateDataNode.javx");
            fileChanges.add(fileChanges.createFileWithSubstitutions(nodeName, template, replaceTokens));
            template = NewLoaderIterator.class.getResource("templateresolver.xml");
            fileChanges.add(fileChanges.createLayerEntry("Services/MIMEResolver/" + namePrefix + "Resolver.xml", template, replaceTokens, NbBundle.getMessage((Class)NewLoaderIterator.class, (String)"LBL_LoaderName", (Object)namePrefix), null));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.filesystems"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.loaders"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.nodes"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.util"));
            if (isEditable) {
                fileChanges.add(fileChanges.addModuleDependency("org.openide.text"));
            }
            if (isEditable) {
                fileChanges.add(fileChanges.addModuleDependency("org.openide.windows"));
            }
            String bundlePath = model.getDefaultPackagePath("Bundle.properties");
            fileChanges.add(fileChanges.bundleKey(bundlePath, "LBL_" + namePrefix + "_loader_name", NbBundle.getMessage((Class)NewLoaderIterator.class, (String)"LBL_LoaderName", (Object)namePrefix)));
            boolean isXml = Pattern.matches("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.-])*\\+xml)", mime);
            String installBefore = null;
            if (isXml) {
                installBefore = "org.openide.loaders.XMLDataObject, org.netbeans.modules.xml.core.XMLDataObject";
            }
            fileChanges.add(fileChanges.addLoaderSection(packageName.replace('.', '/') + "/" + namePrefix + "DataLoader", installBefore));
            fileChanges.add(fileChanges.layerModifications(new CreatedModifiedFiles.LayerOperation(){

                public void run(FileSystem layer) throws IOException {
                    ArrayList<String> actions = new ArrayList<String>();
                    if (isEditable) {
                        actions.add("org.openide.actions.OpenAction");
                    }
                    actions.addAll(Arrays.asList("org.openide.actions.FileSystemAction", null, "org.openide.actions.CutAction", "org.openide.actions.CopyAction", null, "org.openide.actions.DeleteAction", "org.openide.actions.RenameAction", null, "org.openide.actions.SaveAsTemplateAction", null, "org.openide.actions.ToolsAction", "org.openide.actions.PropertiesAction"));
                    FileObject folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)("Loaders/" + mime + "/Actions"));
                    ArrayList<DataObject> kids = new ArrayList<DataObject>();
                    Iterator it = actions.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        FileObject kid;
                        String name = (String)it.next();
                        if (name != null) {
                            kid = folder.createData(name.replace('.', '-') + ".instance");
                        } else {
                            kid = folder.createData("sep-" + ++i + ".instance");
                            kid.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                        }
                        kids.add(DataObject.find((FileObject)kid));
                    }
                    DataFolder.findFolder((FileObject)folder).setOrder(kids.toArray(new DataObject[kids.size()]));
                }
            }, Collections.EMPTY_SET));
            suffix = null;
            if (model.isExtensionBased()) {
                suffix = "Template." + NewLoaderIterator.getFirstExtension(model.getExtension());
                template = NewLoaderIterator.class.getResource("templateNew1");
            } else {
                template = NewLoaderIterator.class.getResource("templateNew2");
                suffix = "Template.xml";
                try {
                    replaceTokens.put("@@NAMESPACE@@", XMLUtil.toElementContent((String)model.getNamespace()));
                }
                catch (CharConversionException ex) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)ex);
                }
            }
        }
        HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
        attrs.put("template", Boolean.TRUE);
        fileChanges.add(fileChanges.createLayerEntry("Templates/Other/" + namePrefix + suffix, template, replaceTokens, NbBundle.getMessage((Class)NewLoaderIterator.class, (String)"LBL_fileTemplateName", (Object)namePrefix), attrs));
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String formatExtensions(boolean isExtensionBased, String ext, String mime) {
        if (!isExtensionBased) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(ext, " ,");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken().trim();
            if (element.startsWith(".")) {
                element = element.substring(1);
            }
            buff.append("        <ext name=\"").append(element).append("\"/>\n");
        }
        buff.append("        <resolver mime=\"").append(mime).append("\"/>\n");
        return buff.toString();
    }

    private static String getFirstExtension(String ext) {
        StringTokenizer tokens = new StringTokenizer(ext, " ,");
        String element = "someextension";
        if (tokens.hasMoreTokens() && (element = tokens.nextToken().trim()).startsWith(".")) {
            element = element.substring(1);
        }
        return element;
    }

    private static String formatNameSpace(boolean isExtensionBased, String namespace, String mime) {
        StringBuffer buff;
        block3: {
            if (isExtensionBased) {
                return "";
            }
            buff = new StringBuffer();
            buff.append("        <ext name=\"xml\"/>\n");
            buff.append("        <resolver mime=\"").append(mime).append("\">\n");
            buff.append("            <xml-rule>\n");
            try {
                buff.append("                <element ns=\"").append(XMLUtil.toElementContent((String)namespace)).append("\"/>\n");
            }
            catch (CharConversionException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex);
            }
        }
        buff.append("            </xml-rule>\n");
        buff.append("        </resolver>\n");
        return buff.toString();
    }

    private static String formatImageSnippet(String path) {
        if (path == null) {
            return "return super.getIcon(type); // TODO add a custom icon here\n";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {\n");
        buff.append("            return Utilities.loadImage(\"");
        buff.append(path).append("\");\n");
        buff.append("        } else {\n");
        buff.append("            return null;\n        }\n");
        return buff.toString();
    }

    static {
        $assertionsDisabled = !NewLoaderIterator.class.desiredAssertionStatus();
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private String prefix;
        private String iconPath;
        private String mimeType;
        private boolean extensionBased = true;
        private String extension;
        private String namespace;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public void setIconPath(String iconPath) {
            this.iconPath = iconPath;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public boolean isExtensionBased() {
            return this.extensionBased;
        }

        public void setExtensionBased(boolean extensionBased) {
            this.extensionBased = extensionBased;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }
}

