/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

final class CreatedModifiedFilesProvider {
    private static final String VOLUME_CLASS = "classpath";
    private static final String VOLUME_SRC = "src";
    private static final String VOLUME_JAVADOC = "javadoc";
    private static final String LIBRARY_LAYER_ENTRY = "org-netbeans-api-project-libraries/Libraries";
    static final /* synthetic */ boolean $assertionsDisabled;

    CreatedModifiedFilesProvider() {
    }

    static CreatedModifiedFiles createInstance(NewLibraryDescriptor.DataModel data) {
        CreatedModifiedFiles retval = new CreatedModifiedFiles(data.getProject());
        CreatedModifiedFilesProvider.addOperations(retval, data);
        return retval;
    }

    private static void addOperations(CreatedModifiedFiles fileSupport, NewLibraryDescriptor.DataModel data) {
        URL template = CreatedModifiedFilesProvider.class.getResource("libdescriptemplate.xml");
        Map tokens = CreatedModifiedFilesProvider.getTokens(fileSupport, data.getProject(), data);
        String layerEntry = CreatedModifiedFilesProvider.getLibraryDescriptorEntryPath(data.getLibraryName());
        fileSupport.add(fileSupport.createLayerEntry(layerEntry, template, tokens, null, null));
        fileSupport.add(fileSupport.bundleKeyDefaultBundle(data.getLibraryName(), data.getLibraryDisplayName()));
    }

    private static String getPackagePlusBundle(NbModuleProject project) {
        ManifestManager mm = ManifestManager.getInstance(project.getManifest(), false);
        String bundle = mm.getLocalizingBundle().replace('/', '.');
        if (bundle.endsWith(".properties")) {
            bundle = bundle.substring(0, bundle.length() - 11);
        }
        return bundle;
    }

    static String getLibraryDescriptorEntryPath(String libraryName) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIBRARY_LAYER_ENTRY).append("/").append(libraryName).append(".xml");
        return sb.toString();
    }

    private static String transformURL(String cnb, String pathPrefix, String archiveName) {
        StringBuffer sb = new StringBuffer();
        sb.append("jar:nbinst://").append(cnb).append("/");
        sb.append(pathPrefix).append(archiveName).append("!/");
        return sb.toString();
    }

    private static Map getTokens(CreatedModifiedFiles fileSupport, NbModuleProject project, NewLibraryDescriptor.DataModel data) {
        HashMap<String, String> retval = new HashMap<String, String>();
        Library library = data.getLibrary();
        retval.put("name_to_substitute", data.getLibraryName());
        retval.put("bundle_to_substitute", CreatedModifiedFilesProvider.getPackagePlusBundle(project).replace('/', '.'));
        Iterator it = library.getContent(VOLUME_CLASS).iterator();
        retval.put("classpath_to_substitute", CreatedModifiedFilesProvider.getTokenSubstitution(it, fileSupport, data, "libs/"));
        it = library.getContent(VOLUME_SRC).iterator();
        retval.put("src_to_substitute", CreatedModifiedFilesProvider.getTokenSubstitution(it, fileSupport, data, "sources/"));
        it = library.getContent(VOLUME_JAVADOC).iterator();
        retval.put("javadoc_to_substitute", CreatedModifiedFilesProvider.getTokenSubstitution(it, fileSupport, data, "docs/"));
        return retval;
    }

    private static String getTokenSubstitution(Iterator it, CreatedModifiedFiles fileSupport, NewLibraryDescriptor.DataModel data, String pathPrefix) {
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            URL originalURL = (URL)it.next();
            String archiveName = CreatedModifiedFilesProvider.addArchiveToCopy(fileSupport, data, originalURL, "release/" + pathPrefix);
            if (archiveName == null) continue;
            String codeNameBase = ManifestManager.getInstance(data.getProject().getManifest(), false).getCodeNameBase();
            String urlToString = CreatedModifiedFilesProvider.transformURL(codeNameBase, pathPrefix, archiveName);
            sb.append("<resource>");
            sb.append(urlToString);
            if (it.hasNext()) {
                sb.append("</resource>\n");
                continue;
            }
            sb.append("</resource>");
        }
        return sb.toString();
    }

    private static String addArchiveToCopy(CreatedModifiedFiles fileSupport, NewLibraryDescriptor.DataModel data, URL originalURL, String pathPrefix) {
        FileObject folderToZip;
        String retval = null;
        URL archivURL = FileUtil.getArchiveFile((URL)originalURL);
        if (archivURL != null && FileUtil.isArchiveFile((URL)archivURL)) {
            FileObject archiv = URLMapper.findFileObject((URL)archivURL);
            if (!$assertionsDisabled && archiv == null) {
                throw new AssertionError();
            }
            retval = archiv.getNameExt();
            StringBuffer sb = new StringBuffer();
            sb.append(pathPrefix).append(retval);
            fileSupport.add(fileSupport.createFile(sb.toString(), archivURL));
        } else if ("file".equals(originalURL.getProtocol()) && (folderToZip = URLMapper.findFileObject((URL)originalURL)) != null) {
            retval = data.getLibraryName() + ".zip";
            pathPrefix = pathPrefix + retval;
            fileSupport.add(new ZipAndCopyOperation(data.getProject(), folderToZip, pathPrefix));
        }
        return retval;
    }

    static {
        $assertionsDisabled = !CreatedModifiedFilesProvider.class.desiredAssertionStatus();
    }

    private static class ZipAndCopyOperation
    extends CreatedModifiedFilesFactory.OperationBase {
        private FileObject folderToZip;
        private String relativePath;
        static final /* synthetic */ boolean $assertionsDisabled;

        ZipAndCopyOperation(NbModuleProject prj, FileObject folderToZip, String relativePath) {
            super(prj);
            this.folderToZip = folderToZip;
            this.relativePath = relativePath;
            this.addCreatedOrModifiedPath(relativePath, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            ArrayList files = Collections.list(this.folderToZip.getChildren(true));
            if (files.isEmpty()) {
                return;
            }
            FileObject prjDir = this.getProject().getProjectDirectory();
            if (!$assertionsDisabled && prjDir == null) {
                throw new AssertionError();
            }
            FileObject zipedTarget = prjDir.getFileObject(this.relativePath);
            if (zipedTarget == null) {
                zipedTarget = FileUtil.createData((FileObject)prjDir, (String)this.relativePath);
            }
            if (!$assertionsDisabled && zipedTarget == null) {
                throw new AssertionError();
            }
            FileLock fLock = null;
            OutputStream os = null;
            try {
                fLock = zipedTarget.lock();
                os = zipedTarget.getOutputStream(fLock);
                ZipAndCopyOperation.createZipFile(os, this.folderToZip, files);
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (fLock != null) {
                    fLock.releaseLock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createZipFile(OutputStream target, FileObject root, Collection files) throws IOException {
            ZipOutputStream str = null;
            try {
                str = new ZipOutputStream(target);
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    FileObject fo = (FileObject)it.next();
                    String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                    if (fo.isFolder()) {
                        if (fo.getChildren().length > 0) continue;
                        if (!relativePath.endsWith("/")) {
                            relativePath = relativePath + "/";
                        }
                    }
                    ZipEntry entry = new ZipEntry(relativePath);
                    str.putNextEntry(entry);
                    if (fo.isData()) {
                        InputStream in = null;
                        try {
                            in = fo.getInputStream();
                            FileUtil.copy((InputStream)in, (OutputStream)str);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    str.closeEntry();
                }
            }
            finally {
                if (str != null) {
                    str.close();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$wizard$librarydescriptor$CreatedModifiedFilesProvider == null ? (class$org$netbeans$modules$apisupport$project$ui$wizard$librarydescriptor$CreatedModifiedFilesProvider = CreatedModifiedFilesProvider.class$("org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.CreatedModifiedFilesProvider")) : class$org$netbeans$modules$apisupport$project$ui$wizard$librarydescriptor$CreatedModifiedFilesProvider).desiredAssertionStatus();
        }
    }
}

