/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.netbeans.modules.apisupport.project.ui.wizard.action.ShortcutEnterPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class GUIRegistrationPanel
extends BasicWizardIterator.Panel {
    private final RequestProcessor SFS_RP = new RequestProcessor(GUIRegistrationPanel.class.getName());
    private static final String ACTIONS_DIR = "Actions";
    private FileSystem sfs;
    private final ListCellRenderer POSITION_RENDERER = new PositionRenderer();
    private static final String POSITION_HERE;
    private static final String POSITION_SEPARATOR = " - ";
    private DataModel data;
    private final JComponent[] gmiGroup;
    private final JComponent[] toolbarGroup;
    private final JComponent[] shortcutGroup;
    private final JComponent[] fileTypeGroup;
    private final JComponent[] editorGroup;
    private JComboBox category;
    private JLabel categoryTxt;
    private JComboBox edContentType;
    private JLabel edContentTypeTxt;
    private JComboBox edPosition;
    private JLabel edPositionTxt;
    private JCheckBox edSeparatorAfter;
    private JCheckBox edSeparatorBefore;
    private JPanel edSeparatorPanel;
    JCheckBox editorContext;
    JCheckBox fileTypeContext;
    private JLabel filler;
    private JComboBox ftContentType;
    private JLabel ftContentTypeTxt;
    private JComboBox ftPosition;
    private JLabel ftPositionTxt;
    private JCheckBox ftSeparatorAfter;
    private JCheckBox ftSeparatorBefore;
    private JPanel ftSeparatorPanel;
    private JCheckBox globalKeyboardShortcut;
    JCheckBox globalMenuItem;
    JCheckBox globalToolbarButton;
    private JScrollPane jScrollPane1;
    private JButton keyStrokeChange;
    private JButton keyStrokeRemove;
    private JLabel keyStrokeTxt;
    private JComboBox menu;
    private JComboBox menuPosition;
    private JLabel menuPositionTxt;
    private JCheckBox menuSeparatorAfter;
    private JCheckBox menuSeparatorBefore;
    private JPanel menuSeparatorPanel;
    private JLabel menuTxt;
    private JList shortcutsList;
    private JComboBox toolbar;
    private JComboBox toolbarPosition;
    private JLabel toolbarPositionTxt;
    private JLabel toolbarTxt;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GUIRegistrationPanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccesibility();
        this.putClientProperty("NewFileWizard_Title", GUIRegistrationPanel.getMessage("LBL_ActionWizardTitle"));
        this.menu.addPopupMenuListener(new PML(this.menu, this.menuPosition));
        this.toolbar.addPopupMenuListener(new PML(this.toolbar, this.toolbarPosition));
        this.ftContentType.addPopupMenuListener(new PML(this.ftContentType, this.ftPosition));
        this.edContentType.addPopupMenuListener(new PML(this.edContentType, this.edPosition));
        this.gmiGroup = new JComponent[]{this.menu, this.menuTxt, this.menuPosition, this.menuPositionTxt, this.menuSeparatorAfter, this.menuSeparatorBefore};
        this.toolbarGroup = new JComponent[]{this.toolbar, this.toolbarTxt, this.toolbarPosition, this.toolbarPositionTxt};
        this.shortcutGroup = new JComponent[]{this.shortcutsList, this.keyStrokeTxt, this.keyStrokeChange, this.keyStrokeRemove};
        this.fileTypeGroup = new JComponent[]{this.ftContentType, this.ftContentTypeTxt, this.ftPosition, this.ftPositionTxt, this.ftSeparatorAfter, this.ftSeparatorBefore};
        this.editorGroup = new JComponent[]{this.edContentType, this.edContentTypeTxt, this.edPosition, this.edPositionTxt, this.edSeparatorAfter, this.edSeparatorBefore};
        this.readSFS();
    }

    private void setEditable(final JComboBox combo) {
        combo.setEditable(true);
        if (combo.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField txt = (JTextField)combo.getEditor().getEditorComponent();
            txt.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent e) {
                    if (!CustomizerComponentFactory.isWaitModel(combo.getModel())) {
                        GUIRegistrationPanel.this.checkValidity();
                    }
                }
            });
        }
    }

    protected String getPanelName() {
        return GUIRegistrationPanel.getMessage("LBL_GUIRegistration_Title");
    }

    private String getCategoryPath() {
        String path = UIUtil.getSFSPath(this.category, ACTIONS_DIR);
        return path == null ? "Actions/Tools" : path;
    }

    protected void storeToDataModel() {
        if (!this.checkValidity()) {
            return;
        }
        this.data.setCategory(this.getCategoryPath());
        this.data.setGlobalMenuItemEnabled(this.globalMenuItem.isSelected());
        if (this.globalMenuItem.isSelected()) {
            this.data.setGMIParentMenu(GUIRegistrationPanel.getSelectedLayerPresenter(this.menu).getFullPath());
            this.data.setGMIPosition((DataModel.Position)this.menuPosition.getSelectedItem());
            this.data.setGMISeparatorAfter(this.menuSeparatorAfter.isSelected());
            this.data.setGMISeparatorBefore(this.menuSeparatorBefore.isSelected());
        }
        this.data.setToolbarEnabled(this.globalToolbarButton.isSelected());
        if (this.globalToolbarButton.isSelected()) {
            this.data.setToolbar(GUIRegistrationPanel.getSelectedLayerPresenter(this.toolbar).getFullPath());
            this.data.setToolbarPosition((DataModel.Position)this.toolbarPosition.getSelectedItem());
        }
        this.data.setKeyboardShortcutEnabled(this.globalKeyboardShortcut.isSelected());
        this.data.setFileTypeContextEnabled(this.fileTypeContext.isSelected());
        if (this.fileTypeContext.isSelected()) {
            this.data.setFTContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.ftContentType).getFullPath());
            this.data.setFTContextPosition((DataModel.Position)this.ftPosition.getSelectedItem());
            this.data.setFTContextSeparatorBefore(this.ftSeparatorBefore.isSelected());
            this.data.setFTContextSeparatorAfter(this.ftSeparatorAfter.isSelected());
        }
        this.data.setEditorContextEnabled(this.editorContext.isSelected());
        if (this.editorContext.isSelected()) {
            this.data.setEdContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.edContentType).getFullPath());
            this.data.setEdContextPosition((DataModel.Position)this.edPosition.getSelectedItem());
            this.data.setEdContextSeparatorBefore(this.edSeparatorBefore.isSelected());
            this.data.setEdContextSeparatorAfter(this.edSeparatorAfter.isSelected());
        }
    }

    protected void readFromDataModel() {
        this.initializeGlobalAction();
        this.checkValidity();
    }

    private void initializeGlobalAction() {
        this.globalMenuItem.setSelected(true);
        this.globalMenuItem.setEnabled(true);
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.globalToolbarButton.setEnabled(true);
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        boolean alwaysEnabled = this.data.isAlwaysEnabled();
        this.globalKeyboardShortcut.setEnabled(alwaysEnabled);
        this.setShortcutGroupEnabled();
        if (alwaysEnabled) {
            this.fileTypeContext.setSelected(false);
            this.editorContext.setSelected(false);
        }
        this.fileTypeContext.setEnabled(!alwaysEnabled);
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.editorContext.setEnabled(!alwaysEnabled);
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
    }

    boolean checkValidity() {
        boolean result = false;
        if (this.globalKeyboardShortcut.isSelected() && ((DefaultListModel)this.shortcutsList.getModel()).isEmpty()) {
            this.setError(GUIRegistrationPanel.getMessage("MSG_YouMustSpecifyShortcut"));
        } else if (!(this.check(this.globalMenuItem, this.menu, this.menuPosition) && this.check(this.globalToolbarButton, this.toolbar, this.toolbarPosition) && this.check(this.fileTypeContext, this.ftContentType, this.ftPosition) && this.check(this.editorContext, this.edContentType, this.edPosition))) {
            this.markInvalid();
        } else if (!Util.isValidSFSPath(this.getCategoryPath())) {
            this.setError(GUIRegistrationPanel.getMessage("ERR_Category_Invalid"));
        } else {
            this.markValid();
            result = true;
        }
        return result;
    }

    private boolean check(JCheckBox groupCheckBox, JComboBox menu, JComboBox position) {
        boolean result = !groupCheckBox.isSelected() || GUIRegistrationPanel.getSelectedItem(menu) != null && GUIRegistrationPanel.getSelectedItem(position) != null;
        return result;
    }

    private void setGroupEnabled(JComponent[] group, boolean enabled) {
        for (int i = 0; i < group.length; ++i) {
            if (group[i] == null) continue;
            group[i].setEnabled(enabled && !this.isEmptyCombo(group[i]));
        }
    }

    private void setShortcutGroupEnabled() {
        boolean isEnabled = this.globalKeyboardShortcut.isSelected();
        this.setGroupEnabled(this.shortcutGroup, isEnabled);
        isEnabled = isEnabled && this.shortcutsList.getSelectedValues().length > 0;
        this.keyStrokeRemove.setEnabled(isEnabled);
    }

    private boolean isEmptyCombo(JComponent c) {
        return c instanceof JComboBox && CustomizerComponentFactory.hasOnlyValue(((JComboBox)c).getModel(), CustomizerComponentFactory.EMPTY_VALUE);
    }

    private void readSFS() {
        this.markInvalid();
        this.loadComboAndPositions(ACTIONS_DIR, this.category, null, null, true);
        this.loadComboAndPositions("Menu", this.menu, this.menuPosition, null);
        this.loadComboAndPositions("Toolbars", this.toolbar, this.toolbarPosition, null);
        this.loadComboAndPositions("Loaders", this.ftContentType, this.ftPosition, ACTIONS_DIR);
        this.loadComboAndPositions("Editors", this.edContentType, this.edPosition, "Popup");
    }

    private void loadComboAndPositions(String startFolder, JComboBox combo, JComboBox comboPositions, String subFolderName) {
        this.loadComboAndPositions(startFolder, combo, comboPositions, subFolderName, false);
    }

    private void loadComboAndPositions(final String startFolder, final JComboBox combo, final JComboBox comboPositions, final String subFolderName, final boolean editable) {
        combo.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){

            public void run() {
                DataFolder parentDF;
                Util.err.log("Loading " + startFolder + " from SFS....");
                final FileObject parent = GUIRegistrationPanel.this.getSFS().getRoot().getFileObject(startFolder);
                DataFolder dataFolder = parentDF = parent != null ? DataFolder.findFolder((FileObject)parent) : null;
                if (parentDF == null) {
                    Util.err.log("Could not find " + startFolder);
                    GUIRegistrationPanel.this.setEmptyModel(combo);
                    GUIRegistrationPanel.this.setEmptyModel(comboPositions);
                    return;
                }
                final Enumeration folders = subFolderName == null ? GUIRegistrationPanel.getFolders(parentDF) : GUIRegistrationPanel.this.getFoldersByName(parentDF, subFolderName);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        LinkedHashSet<UIUtil.LayerItemPresenter> sorted = new LinkedHashSet<UIUtil.LayerItemPresenter>();
                        while (folders.hasMoreElements()) {
                            DataFolder folder = (DataFolder)folders.nextElement();
                            sorted.add(new UIUtil.LayerItemPresenter(folder.getPrimaryFile(), parent, subFolderName != null));
                        }
                        if (sorted.size() == 0) {
                            GUIRegistrationPanel.this.setEmptyModel(combo);
                            GUIRegistrationPanel.this.setEmptyModel(comboPositions);
                        } else {
                            DefaultComboBoxModel model = new DefaultComboBoxModel();
                            Iterator it = sorted.iterator();
                            while (it.hasNext()) {
                                model.addElement(it.next());
                            }
                            combo.setModel(model);
                            if (editable) {
                                GUIRegistrationPanel.this.setEditable(combo);
                            }
                            if (comboPositions != null) {
                                GUIRegistrationPanel.this.loadPositionsCombo((UIUtil.LayerItemPresenter)combo.getSelectedItem(), comboPositions);
                            }
                        }
                    }
                });
            }
        });
    }

    private void loadPositionsCombo(final UIUtil.LayerItemPresenter parent, final JComboBox positionsCombo) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && positionsCombo == null) {
            throw new AssertionError();
        }
        positionsCombo.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){

            public void run() {
                DataObject[] kids = DataFolder.findFolder((FileObject)parent.getFileObject()).getChildren();
                final FileObject[] files = new FileObject[kids.length];
                for (int i = 0; i < kids.length; ++i) {
                    files[i] = kids[i].getPrimaryFile();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GUIRegistrationPanel.this.createPositionModel(positionsCombo, files, parent);
                    }
                });
            }
        });
    }

    private void createPositionModel(JComboBox positionsCombo, FileObject[] files, UIUtil.LayerItemPresenter parent) {
        DefaultComboBoxModel<DataModel.Position> newModel = new DefaultComboBoxModel<DataModel.Position>();
        UIUtil.LayerItemPresenter previous = null;
        for (int i = 0; i < files.length; ++i) {
            UIUtil.LayerItemPresenter current = new UIUtil.LayerItemPresenter(files[i], parent.getFileObject());
            newModel.addElement(GUIRegistrationPanel.createPosition(previous, current));
            previous = current;
        }
        newModel.addElement(GUIRegistrationPanel.createPosition(previous, null));
        positionsCombo.setModel(newModel);
        this.checkValidity();
    }

    private static Object getSelectedItem(JComboBox combo) {
        Object item = combo.getSelectedItem();
        return item == CustomizerComponentFactory.WAIT_VALUE || item == CustomizerComponentFactory.EMPTY_VALUE ? null : item;
    }

    private static UIUtil.LayerItemPresenter getSelectedLayerPresenter(JComboBox combo) {
        return (UIUtil.LayerItemPresenter)GUIRegistrationPanel.getSelectedItem(combo);
    }

    private static DataModel.Position createPosition(UIUtil.LayerItemPresenter first, UIUtil.LayerItemPresenter second) {
        return new DataModel.Position(first == null ? null : first.getFileObject().getNameExt(), second == null ? null : second.getFileObject().getNameExt(), first == null ? null : first.getDisplayName(), second == null ? null : second.getDisplayName());
    }

    private void setEmptyModel(JComboBox combo) {
        if (combo != null) {
            combo.setModel(CustomizerComponentFactory.createComboEmptyModel());
            combo.setEnabled(false);
            combo.setEditable(false);
            this.checkValidity();
        }
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(GUIRegistrationPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)key);
    }

    private void initComponents() {
        this.categoryTxt = new JLabel();
        this.category = new JComboBox();
        this.globalMenuItem = new JCheckBox();
        this.menuTxt = new JLabel();
        this.menu = new JComboBox();
        this.menuPositionTxt = new JLabel();
        this.menuPosition = new JComboBox();
        this.menuSeparatorPanel = new JPanel();
        this.menuSeparatorBefore = new JCheckBox();
        this.menuSeparatorAfter = new JCheckBox();
        this.globalToolbarButton = new JCheckBox();
        this.toolbarTxt = new JLabel();
        this.toolbar = new JComboBox();
        this.toolbarPositionTxt = new JLabel();
        this.toolbarPosition = new JComboBox();
        this.globalKeyboardShortcut = new JCheckBox();
        this.keyStrokeTxt = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.shortcutsList = new JList(new DefaultListModel());
        this.keyStrokeChange = new JButton();
        this.keyStrokeRemove = new JButton();
        this.filler = new JLabel();
        this.fileTypeContext = new JCheckBox();
        this.ftContentTypeTxt = new JLabel();
        this.ftContentType = new JComboBox();
        this.ftPositionTxt = new JLabel();
        this.ftPosition = new JComboBox();
        this.ftSeparatorPanel = new JPanel();
        this.ftSeparatorBefore = new JCheckBox();
        this.ftSeparatorAfter = new JCheckBox();
        this.editorContext = new JCheckBox();
        this.edContentTypeTxt = new JLabel();
        this.edContentType = new JComboBox();
        this.edPositionTxt = new JLabel();
        this.edPosition = new JComboBox();
        this.edSeparatorPanel = new JPanel();
        this.edSeparatorBefore = new JCheckBox();
        this.edSeparatorAfter = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.categoryTxt.setLabelFor(this.category);
        Mnemonics.setLocalizedText((JLabel)this.categoryTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Category"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.categoryTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.category, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalMenuItem, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_GlobalMenuItem"));
        this.globalMenuItem.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalMenuItem.setMargin(new Insets(0, 0, 0, 0));
        this.globalMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.globalMenuItemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalMenuItem, gridBagConstraints);
        this.menuTxt.setLabelFor(this.menu);
        Mnemonics.setLocalizedText((JLabel)this.menuTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Menu"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.menuTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.menu, gridBagConstraints);
        this.menuPositionTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.menuPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.menuPositionTxt, gridBagConstraints);
        this.menuPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.menuPosition, gridBagConstraints);
        this.menuSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorBefore, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.menuSeparatorBefore.setMargin(new Insets(0, 0, 0, 0));
        this.menuSeparatorPanel.add(this.menuSeparatorBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorAfter, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.menuSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.menuSeparatorAfter.setMargin(new Insets(0, 0, 0, 0));
        this.menuSeparatorPanel.add(this.menuSeparatorAfter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.menuSeparatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalToolbarButton, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_GlobalToolbarButton"));
        this.globalToolbarButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalToolbarButton.setMargin(new Insets(0, 0, 0, 0));
        this.globalToolbarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.globalToolbarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalToolbarButton, gridBagConstraints);
        this.toolbarTxt.setLabelFor(this.toolbar);
        Mnemonics.setLocalizedText((JLabel)this.toolbarTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Toolbar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.toolbarTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.toolbar, gridBagConstraints);
        this.toolbarPositionTxt.setLabelFor(this.toolbarPosition);
        Mnemonics.setLocalizedText((JLabel)this.toolbarPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.toolbarPositionTxt, gridBagConstraints);
        this.toolbarPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.toolbarPosition, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalKeyboardShortcut, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_GlobalKeyboardShortcut"));
        this.globalKeyboardShortcut.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalKeyboardShortcut.setMargin(new Insets(0, 0, 0, 0));
        this.globalKeyboardShortcut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.globalKeyboardShortcutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalKeyboardShortcut, gridBagConstraints);
        this.keyStrokeTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.keyStrokeTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_KeyStroke"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.keyStrokeTxt, gridBagConstraints);
        this.shortcutsList.setVisibleRowCount(3);
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                GUIRegistrationPanel.this.shortcutsListChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.shortcutsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeChange, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"CTL_Change"));
        this.keyStrokeChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.keyStrokeChangeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.keyStrokeChange, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeRemove, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/action/Bundle").getString("CTL_Remove"));
        this.keyStrokeRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.keyStrokeRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.keyStrokeRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fileTypeContext, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_FileTypeContextMenuItem"));
        this.fileTypeContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeContext.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.fileTypeContextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.fileTypeContext, gridBagConstraints);
        this.ftContentTypeTxt.setLabelFor(this.ftContentType);
        Mnemonics.setLocalizedText((JLabel)this.ftContentTypeTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.ftContentTypeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.ftContentType, gridBagConstraints);
        this.ftPositionTxt.setLabelFor(this.ftPosition);
        Mnemonics.setLocalizedText((JLabel)this.ftPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.ftPositionTxt, gridBagConstraints);
        this.ftPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.ftPosition, gridBagConstraints);
        this.ftSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorBefore, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.ftSeparatorBefore.setMargin(new Insets(0, 0, 0, 0));
        this.ftSeparatorPanel.add(this.ftSeparatorBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorAfter, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.ftSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.ftSeparatorAfter.setMargin(new Insets(0, 0, 0, 0));
        this.ftSeparatorPanel.add(this.ftSeparatorAfter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.ftSeparatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editorContext, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_EditorContextMenuItem"));
        this.editorContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.editorContext.setMargin(new Insets(0, 0, 0, 0));
        this.editorContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.editorContextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.editorContext, gridBagConstraints);
        this.edContentTypeTxt.setLabelFor(this.edContentType);
        Mnemonics.setLocalizedText((JLabel)this.edContentTypeTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.edContentTypeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.edContentType, gridBagConstraints);
        this.edPositionTxt.setLabelFor(this.edPosition);
        Mnemonics.setLocalizedText((JLabel)this.edPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.edPositionTxt, gridBagConstraints);
        this.edPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.edPosition, gridBagConstraints);
        this.edSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorBefore, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.edSeparatorBefore.setMargin(new Insets(0, 0, 0, 0));
        this.edSeparatorPanel.add(this.edSeparatorBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorAfter, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.edSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.edSeparatorAfter.setMargin(new Insets(0, 0, 0, 0));
        this.edSeparatorPanel.add(this.edSeparatorAfter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.edSeparatorPanel, gridBagConstraints);
    }

    private void shortcutsListChanged(ListSelectionEvent evt) {
        this.setShortcutGroupEnabled();
    }

    private void keyStrokeRemoveActionPerformed(ActionEvent evt) {
        DefaultListModel lm = (DefaultListModel)this.shortcutsList.getModel();
        Object[] selected = this.shortcutsList.getSelectedValues();
        if (selected.length > 0) {
            int idx = this.shortcutsList.getSelectionModel().getMinSelectionIndex();
            for (int i = 0; i < selected.length; ++i) {
                lm.removeElement(selected[i]);
            }
            if (lm.getSize() > 0) {
                idx = idx > 0 ? idx - 1 : 0;
                this.shortcutsList.setSelectedIndex(idx);
            }
        }
        this.checkValidity();
    }

    private void editorContextActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
        this.checkValidity();
    }

    private void fileTypeContextActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.checkValidity();
    }

    private void globalMenuItemActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.checkValidity();
    }

    private void globalToolbarButtonActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        this.checkValidity();
    }

    private void globalKeyboardShortcutActionPerformed(ActionEvent evt) {
        this.setShortcutGroupEnabled();
        this.checkValidity();
    }

    private void keyStrokeChangeActionPerformed(ActionEvent evt) {
        KeyStroke[] keyStrokes = ShortcutEnterPanel.showDialog();
        if (keyStrokes != null && keyStrokes.length > 0) {
            String newShortcut = UIUtil.keyStrokesToString(keyStrokes);
            DefaultListModel lm = (DefaultListModel)this.shortcutsList.getModel();
            if (!lm.contains(newShortcut)) {
                lm.addElement(newShortcut);
                this.data.setKeyStroke(UIUtil.keyStrokesToLogicalString(keyStrokes));
                this.shortcutsList.setSelectedValue(newShortcut, true);
                this.checkValidity();
            }
        }
    }

    private void initAccesibility() {
        this.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_GuiRegistrationPanel"));
        this.category.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_Category"));
        this.edContentType.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edContentType"));
        this.edPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edPosition"));
        this.edSeparatorAfter.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edSeparatorAfter"));
        this.edSeparatorBefore.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edSeparatorBefore"));
        this.editorContext.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_EditorContext"));
        this.fileTypeContext.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_FileTypeContext"));
        this.ftContentType.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftContentType"));
        this.ftPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftPosition"));
        this.ftSeparatorAfter.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftSeparatorAfter"));
        this.ftSeparatorBefore.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftSeparatorBefore"));
        this.globalKeyboardShortcut.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_globalKeyboardShortcut"));
        this.globalMenuItem.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_globalMenuItem"));
        this.globalToolbarButton.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_globalToolbarButton"));
        this.keyStrokeChange.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_keyStrokeChange"));
        this.keyStrokeRemove.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_keyStrokeRemove"));
        this.keyStrokeTxt.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_keyStrokeDef"));
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_keyStrokeList"));
        this.menu.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menu"));
        this.menuPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menuPosition"));
        this.menuSeparatorAfter.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menuSeparatorAfter"));
        this.menuSeparatorBefore.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menuSeparatorBefore"));
        this.toolbar.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_toolbar"));
        this.toolbarPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_toolbarPosition"));
    }

    private FileSystem getSFS() {
        if (!$assertionsDisabled && EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)"Called from ETD!");
        }
        if (this.sfs == null) {
            try {
                this.sfs = LayerUtils.getEffectiveSystemFilesystem(this.data.getProject());
            }
            catch (IOException ex) {
                Util.err.notify((Throwable)ex);
                this.sfs = FileUtil.createMemoryFileSystem();
            }
        }
        return this.sfs;
    }

    private Enumeration getFoldersByName(DataFolder startFolder, String subFoldersName) {
        Enumeration folders = GUIRegistrationPanel.getFolders(startFolder);
        Vector<DataFolder> result = new Vector<DataFolder>();
        while (folders.hasMoreElements()) {
            DataFolder dObj = (DataFolder)folders.nextElement();
            if (!subFoldersName.equals(dObj.getName()) || dObj.getPrimaryFile().getParent() == startFolder.getPrimaryFile()) continue;
            result.add(dObj);
        }
        return result.elements();
    }

    private static Enumeration getFolders(DataFolder folder) {
        ArrayList folders = new ArrayList();
        GUIRegistrationPanel.getFolders(folder, folders);
        return Collections.enumeration(folders);
    }

    private static void getFolders(DataFolder folder, List folders) {
        Enumeration e = folder.children();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof DataFolder)) continue;
            DataFolder f = (DataFolder)o;
            folders.add(f);
            GUIRegistrationPanel.getFolders(f, folders);
        }
    }

    static {
        $assertionsDisabled = !GUIRegistrationPanel.class.desiredAssertionStatus();
        POSITION_HERE = GUIRegistrationPanel.getMessage("CTL_PositionHere");
    }

    private class PML
    implements PopupMenuListener {
        private JComboBox menu;
        private JComboBox position;

        PML(JComboBox menu, JComboBox position) {
            this.menu = menu;
            this.position = position;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            UIUtil.LayerItemPresenter item = GUIRegistrationPanel.getSelectedLayerPresenter(this.menu);
            if (item != null) {
                GUIRegistrationPanel.this.loadPositionsCombo(item, this.position);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupMenuWillBecomeInvisible(null);
        }
    }

    private static class PositionRenderer
    extends DefaultListCellRenderer {
        private PositionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            if (value == null || value == CustomizerComponentFactory.WAIT_VALUE) {
                text = CustomizerComponentFactory.WAIT_VALUE;
            } else if (value == CustomizerComponentFactory.EMPTY_VALUE) {
                text = CustomizerComponentFactory.EMPTY_VALUE;
            } else {
                DataModel.Position pos = (DataModel.Position)value;
                String before = pos.getBeforeName() == null ? "" : pos.getBeforeName() + GUIRegistrationPanel.POSITION_SEPARATOR;
                String after = pos.getAfterName() == null ? "" : GUIRegistrationPanel.POSITION_SEPARATOR + pos.getAfterName();
                text = before + POSITION_HERE + after;
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            return c;
        }
    }
}

