/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProjectGenerator;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewNbModuleWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    static final int TYPE_MODULE = 1;
    static final int TYPE_SUITE = 2;
    static final int TYPE_LIBRARY_MODULE = 3;
    static final int TYPE_SUITE_COMPONENT = 4;
    static final String PREFERRED_SUITE_DIR = "preferredSuiteDir";
    static final String ONE_SUITE_DEDICATED_MODE = "oneSuiteDedicatedMode";
    private final NewModuleProjectData data;
    private int position;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor settings;
    private FileObject createdProjectFolder;
    private String preferredSuiteDir;
    private Boolean suiteDedicated = Boolean.FALSE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NewNbModuleWizardIterator(int type) {
        this.data = new NewModuleProjectData(type);
    }

    public static NewNbModuleWizardIterator createModuleIterator() {
        return new NewNbModuleWizardIterator(1);
    }

    public static NewNbModuleWizardIterator createSuiteComponentIterator(SuiteProject suite) {
        NewNbModuleWizardIterator iterator = new NewNbModuleWizardIterator(4);
        iterator.preferredSuiteDir = FileUtil.toFile((FileObject)suite.getProjectDirectory()).getAbsolutePath();
        iterator.suiteDedicated = Boolean.TRUE;
        return iterator;
    }

    public static NewNbModuleWizardIterator createSuiteIterator() {
        return new NewNbModuleWizardIterator(2);
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator(Project project) {
        NewNbModuleWizardIterator iterator = new NewNbModuleWizardIterator(3);
        iterator.preferredSuiteDir = SuiteUtils.getSuiteDirectoryPath(project);
        if (!$assertionsDisabled && iterator.preferredSuiteDir == null) {
            throw new AssertionError((Object)(project + " does not have a SuiteProvider in its lookup?"));
        }
        iterator.suiteDedicated = Boolean.TRUE;
        return iterator;
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator() {
        return new NewNbModuleWizardIterator(3);
    }

    public FileObject getCreateProjectFolder() {
        return this.createdProjectFolder;
    }

    public Set instantiate() throws IOException {
        File projectFolder = new File(this.data.getProjectFolder());
        ModuleUISettings.getDefault().setLastUsedModuleLocation(this.data.getProjectLocation());
        ModuleUISettings.getDefault().setLastUsedPlatformID(this.data.getPlatformID());
        switch (this.data.getWizardType()) {
            case 2: {
                ModuleUISettings.getDefault().setNewSuiteCounter(this.data.getSuiteCounter());
                SuiteProjectGenerator.createSuiteProject(projectFolder, this.data.getPlatformID());
                break;
            }
            case 1: 
            case 4: {
                ModuleUISettings.getDefault().setNewModuleCounter(this.data.getModuleCounter());
                if (this.data.isNetBeansOrg()) {
                    NbModuleProjectGenerator.createNetBeansOrgModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer());
                    break;
                }
                if (this.data.isStandalone()) {
                    NbModuleProjectGenerator.createStandAloneModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), this.data.getPlatformID());
                    break;
                }
                NbModuleProjectGenerator.createSuiteComponentModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), new File(this.data.getSuiteRoot()));
                break;
            }
            case 3: {
                File[] jars = LibraryStartVisualPanel.convertStringToFiles((String)this.settings.getProperty("LIBRARY_PATH_VALUE"));
                File license = null;
                String licPath = (String)this.settings.getProperty("LICENSE_PATH_VALUE");
                if (licPath != null && licPath.length() > 0) {
                    license = new File(licPath);
                }
                NbModuleProjectGenerator.createSuiteLibraryModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), new File(this.data.getSuiteRoot()), license, jars);
                break;
            }
            default: {
                throw new IllegalStateException("Uknown wizard type: " + this.data.getWizardType());
            }
        }
        this.createdProjectFolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)projectFolder));
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        resultSet.add(this.createdProjectFolder);
        UIUtil.setProjectChooserDirParent(projectFolder);
        this.settings.putProperty("setAsMain", (Object)this.data.isMainProject());
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        Project mainPrj;
        this.data.setSettings(wiz);
        this.settings = wiz;
        if (this.preferredSuiteDir == null && (mainPrj = OpenProjects.getDefault().getMainProject()) != null) {
            this.preferredSuiteDir = SuiteUtils.getSuiteDirectoryPath(mainPrj);
        }
        if (this.preferredSuiteDir != null) {
            this.settings.putProperty(PREFERRED_SUITE_DIR, (Object)this.preferredSuiteDir);
            this.settings.putProperty(ONE_SUITE_DEDICATED_MODE, (Object)this.suiteDedicated);
        }
        this.position = 0;
        String[] steps = null;
        switch (this.data.getWizardType()) {
            case 1: {
                steps = this.initModuleWizard();
                break;
            }
            case 4: {
                steps = this.initModuleWizard();
                break;
            }
            case 2: {
                steps = this.initSuiteModuleWizard();
                break;
            }
            case 3: {
                steps = this.initLibraryModuleWizard();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Should never get here. type: " + this.data.getWizardType()));
                }
                break;
            }
        }
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.settings = null;
        this.panels = null;
    }

    private String[] initModuleWizard() {
        this.panels = new WizardDescriptor.Panel[]{new BasicInfoWizardPanel(this.data), new BasicConfWizardPanel(this.data)};
        String[] steps = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicConfigPanel_Title")};
        return steps;
    }

    private String[] initSuiteModuleWizard() {
        this.panels = new WizardDescriptor.Panel[]{new BasicInfoWizardPanel(this.data)};
        String[] steps = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title")};
        return steps;
    }

    private String[] initLibraryModuleWizard() {
        this.panels = new WizardDescriptor.Panel[]{new LibraryStartWizardPanel(this.data), new BasicInfoWizardPanel(this.data), new LibraryConfWizardPanel(this.data)};
        String[] steps = new String[]{NewNbModuleWizardIterator.getMessage("LBL_LibraryStartPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_PlatformSelectionPanel_Title")};
        return steps;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.position < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.position];
    }

    static String getMessage(String key) {
        return NbBundle.getMessage((Class)NewNbModuleWizardIterator.class, (String)key);
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    static {
        $assertionsDisabled = !NewNbModuleWizardIterator.class.desiredAssertionStatus();
    }
}

