/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BasicInfoVisualPanel
extends BasicVisualPanel.NewTemplatePanel {
    private ButtonModel lastSelectedType;
    private static String lastSelectedSuite;
    private boolean locationUpdated;
    private boolean nameUpdated;
    private boolean moduleTypeGroupAttached = true;
    private boolean mainProjectTouched;
    private JButton browseButton;
    private JButton browseSuiteButton;
    private JLabel chooserFiller;
    private JLabel filler;
    private JLabel folderLbl;
    private JTextField folderValue;
    private JPanel infoPanel;
    private JLabel locationLbl;
    private JTextField locationValue;
    private JCheckBox mainProject;
    private JButton managePlatform;
    private JButton manageSuitePlatform;
    private JLabel moduleSuite;
    private JComboBox moduleSuiteValue;
    private ButtonGroup moduleTypeGroup;
    private JLabel nameLbl;
    JTextField nameValue;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel pnlThouShaltBeholdLayout;
    private JSeparator separator3;
    private JRadioButton standAloneModule;
    private JRadioButton suiteComponent;
    private JLabel suitePlatform;
    private JComboBox suitePlatformValue;
    private JPanel typeChooserPanel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicInfoVisualPanel(NewModuleProjectData data) {
        super(data);
        this.initComponents();
        this.initAccessibility();
        this.initPlatformCombos();
        this.setComponentsVisibility();
        switch (data.getWizardType()) {
            case 2: {
                this.detachModuleTypeGroup();
                break;
            }
            case 1: 
            case 4: {
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                this.suiteComponent.setSelected(true);
                this.mainProject.setSelected(false);
                break;
            }
            case 3: {
                this.moduleSuite.setText(BasicInfoVisualPanel.getMessage("LBL_Add_to_Suite"));
                this.suiteComponent.setSelected(true);
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unknown wizard type = " + data.getWizardType()));
                }
                break;
            }
        }
        this.attachDocumentListeners();
        this.setInitialLocation();
        this.setInitialProjectName();
        this.updateEnabled();
    }

    private void setInitialLocation() {
        if (this.isSuiteComponent()) {
            this.computeAndSetLocation((String)this.moduleSuiteValue.getSelectedItem(), true);
        } else {
            String location = this.computeLocationValue(ModuleUISettings.getDefault().getLastUsedModuleLocation());
            File locationF = new File(location);
            if (SuiteUtils.isSuite(locationF)) {
                this.computeAndSetLocation(locationF.getParent(), true);
            } else {
                this.setLocation(location, true);
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_BasicInfoVisualPanel"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_BrowseButton"));
        this.browseSuiteButton.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_BrowseSuiteButton"));
        this.folderValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_FolderValue"));
        this.locationValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_LocationValue"));
        this.mainProject.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_MainProject"));
        this.managePlatform.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_ManagePlatform"));
        this.manageSuitePlatform.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_ManageSuitePlatform"));
        this.moduleSuiteValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_ModuleSuiteValue"));
        this.nameValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_NameValue"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_PlatformValue"));
        this.standAloneModule.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_StandAloneModule"));
        this.suiteComponent.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_SuiteModule"));
        this.suitePlatformValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_SuitePlatformValue"));
    }

    private void setComponentsVisibility() {
        boolean isSuiteWizard = this.isSuiteWizard();
        boolean isSuiteComponentWizard = this.isSuiteComponentWizard();
        boolean isLibraryWizard = this.isLibraryWizard();
        this.typeChooserPanel.setVisible(!isSuiteWizard);
        this.suitePlatform.setVisible(isSuiteWizard);
        this.suitePlatformValue.setVisible(isSuiteWizard);
        this.manageSuitePlatform.setVisible(isSuiteWizard);
        this.mainProject.setVisible(!isLibraryWizard);
        this.suiteComponent.setVisible(!isLibraryWizard);
        this.platform.setVisible(!isLibraryWizard);
        this.platformValue.setVisible(!isLibraryWizard);
        this.managePlatform.setVisible(!isLibraryWizard);
        this.standAloneModule.setVisible(!isLibraryWizard);
        this.mainProject.setSelected(!isLibraryWizard);
        this.standAloneModule.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.platform.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.platformValue.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.managePlatform.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.suiteComponent.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
    }

    private void restoreSelectedSuite() {
        String preferredSuiteDir = this.getPreferredSuiteDir();
        if (preferredSuiteDir != null) {
            lastSelectedSuite = preferredSuiteDir;
        }
        if (lastSelectedSuite != null) {
            int max = this.moduleSuiteValue.getModel().getSize();
            for (int i = 0; i < max; ++i) {
                if (!lastSelectedSuite.equals(this.moduleSuiteValue.getModel().getElementAt(i))) continue;
                this.moduleSuiteValue.setSelectedItem(lastSelectedSuite);
                break;
            }
        }
    }

    private String getPreferredSuiteDir() {
        return (String)this.getSettings().getProperty("preferredSuiteDir");
    }

    private boolean isOneSuiteDedicatedMode() {
        Boolean b = (Boolean)this.getSettings().getProperty("oneSuiteDedicatedMode");
        return b != null ? b : false;
    }

    private String getNameValue() {
        return this.nameValue.getText().trim();
    }

    private String getLocationValue() {
        return this.locationValue.getText().trim();
    }

    private File getLocationFile() {
        return new File(this.getLocationValue());
    }

    private void updateEnabled() {
        boolean isNetBeansOrg = this.isNetBeansOrgFolder();
        this.standAloneModule.setEnabled(!isNetBeansOrg);
        this.suiteComponent.setEnabled(!isNetBeansOrg);
        boolean standalone = this.isStandAlone();
        boolean suiteModuleSelected = this.isSuiteComponent();
        this.platform.setEnabled(standalone);
        this.platformValue.setEnabled(standalone);
        this.managePlatform.setEnabled(standalone);
        this.moduleSuite.setEnabled(suiteModuleSelected);
        this.moduleSuiteValue.setEnabled(suiteModuleSelected && !this.isOneSuiteDedicatedMode());
        this.browseSuiteButton.setEnabled(suiteModuleSelected && !this.isOneSuiteDedicatedMode());
    }

    void updateAndCheck() {
        this.updateGUI();
        if ("".equals(this.getNameValue())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_NameCannotBeEmpty"));
        } else if ("".equals(this.getLocationValue())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LocationCannotBeEmpty"));
        } else if (this.isLibraryWizard() && this.isNetBeansOrgFolder()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LibraryWrapperForNBOrgUnsupported"));
        } else if (this.isSuiteComponent() && this.moduleSuiteValue.getSelectedItem() == null) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ChooseRegularSuite"));
        } else if (this.isStandAlone() && (this.platformValue.getSelectedItem() == null || !((NbPlatform)this.platformValue.getSelectedItem()).isValid())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ChosenPlatformIsInvalid"));
        } else if (this.isSuiteWizard() && (this.suitePlatformValue.getSelectedItem() == null || !((NbPlatform)this.suitePlatformValue.getSelectedItem()).isValid())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ChosenPlatformIsInvalid"));
        } else if (this.getFolder().exists()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ProjectFolderExists"));
        } else if (!this.getLocationFile().exists()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LocationMustExist"));
        } else if (!this.getLocationFile().canWrite()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LocationNotWritable"));
        } else {
            this.markValid();
        }
    }

    private void updateGUI() {
        this.folderValue.setText(this.getFolder().getPath());
        if (this.isSuiteWizard() || this.isNetBeansOrgFolder()) {
            this.detachModuleTypeGroup();
        } else {
            this.attachModuleTypeGroup();
        }
        this.updateEnabled();
    }

    private void detachModuleTypeGroup() {
        if (this.moduleTypeGroupAttached) {
            this.lastSelectedType = this.moduleTypeGroup.getSelection();
            this.moduleTypeGroup.remove(this.standAloneModule);
            this.moduleTypeGroup.remove(this.suiteComponent);
            this.standAloneModule.setSelected(false);
            this.suiteComponent.setSelected(false);
            this.moduleTypeGroupAttached = false;
        }
    }

    private void attachModuleTypeGroup() {
        if (!this.moduleTypeGroupAttached) {
            this.moduleTypeGroup.add(this.standAloneModule);
            this.moduleTypeGroup.add(this.suiteComponent);
            if (this.isLibraryWizard()) {
                this.suiteComponent.setSelected(true);
            } else {
                this.moduleTypeGroup.setSelected(this.lastSelectedType, true);
            }
            this.moduleTypeGroupAttached = true;
        }
    }

    private void setProjectName(String formater, int counter) {
        String name;
        while ((name = this.validFreeModuleName(formater, counter)) == null) {
            ++counter;
        }
        this.nameValue.setText(name);
    }

    private String validFreeModuleName(String formater, int index) {
        String name = MessageFormat.format(formater, new Integer(index));
        File file = new File(this.getLocationValue(), name);
        return file.exists() ? null : name;
    }

    void storeData() {
        this.getData().setProjectName(this.getNameValue());
        this.getData().setProjectLocation(this.getLocationValue());
        this.getData().setProjectFolder(this.folderValue.getText());
        this.getData().setMainProject(this.mainProject.isSelected());
        this.getData().setNetBeansOrg(this.isNetBeansOrgFolder());
        this.getData().setStandalone(this.isStandAlone());
        this.getData().setSuiteRoot((String)this.moduleSuiteValue.getSelectedItem());
        if (this.isSuiteWizard() && this.suitePlatformValue.getSelectedItem() != null) {
            this.getData().setPlatformID(((NbPlatform)this.suitePlatformValue.getSelectedItem()).getID());
        } else if (this.platformValue.getSelectedItem() != null) {
            this.getData().setPlatformID(((NbPlatform)this.platformValue.getSelectedItem()).getID());
        }
    }

    void refreshData() {
        if (this.getData().getProjectName() != null) {
            this.nameValue.setText(this.getData().getProjectName());
        } else {
            this.setInitialProjectName();
        }
    }

    private void setInitialProjectName() {
        String bundlekey = null;
        int counter = 0;
        switch (this.getData().getWizardType()) {
            case 2: {
                counter = ModuleUISettings.getDefault().getNewSuiteCounter() + 1;
                bundlekey = "TXT_Suite";
                this.getData().setSuiteCounter(counter);
                break;
            }
            case 1: 
            case 4: {
                counter = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                bundlekey = "TXT_Module";
                this.getData().setModuleCounter(counter);
                break;
            }
            case 3: {
                counter = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                bundlekey = "TXT_Library";
                this.getData().setModuleCounter(counter);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unknown wizard type = " + this.getData().getWizardType()));
                }
                break;
            }
        }
        this.setProjectName(BasicInfoVisualPanel.getMessage(bundlekey), counter);
        this.nameValue.select(0, this.nameValue.getText().length());
        this.nameUpdated = false;
    }

    private void attachDocumentListeners() {
        UIUtil.DocumentAdapter fieldsDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.nameValue.getDocument().addDocumentListener(fieldsDL);
        this.locationValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicInfoVisualPanel.this.nameUpdated = true;
            }
        });
        this.locationValue.getDocument().addDocumentListener(fieldsDL);
        this.locationValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicInfoVisualPanel.this.locationUpdated = true;
            }
        });
        ActionListener plafAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.platformValue.addActionListener(plafAL);
        this.suitePlatformValue.addActionListener(plafAL);
    }

    private File getFolder() {
        StringBuffer destFolder = new StringBuffer(this.getLocationValue());
        if (destFolder.length() != 0) {
            destFolder.append(File.separator);
        }
        destFolder.append(this.getNameValue());
        return FileUtil.normalizeFile((File)new File(destFolder.toString()));
    }

    private boolean isNetBeansOrgFolder() {
        return ModuleList.findNetBeansOrg(this.getFolder()) != null;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)key);
    }

    private void initPlatformCombos() {
        if (this.platformValue.getItemCount() <= 0) {
            return;
        }
        boolean set = false;
        String idToSelect = ModuleUISettings.getDefault().getLastUsedPlatformID();
        for (int i = 0; i < this.platformValue.getItemCount(); ++i) {
            if (!((NbPlatform)this.platformValue.getItemAt(i)).getID().equals(idToSelect)) continue;
            this.platformValue.setSelectedIndex(i);
            this.suitePlatformValue.setSelectedIndex(i);
            set = true;
            break;
        }
        if (!set) {
            NbPlatform defPlaf = NbPlatform.getDefaultPlatform();
            this.platformValue.setSelectedItem(defPlaf == null ? this.platformValue.getItemAt(0) : defPlaf);
            this.suitePlatformValue.setSelectedItem(defPlaf == null ? this.suitePlatformValue.getItemAt(0) : defPlaf);
        }
    }

    private void setLocation(String location, boolean silently) {
        boolean revert = silently && !this.locationUpdated;
        this.locationValue.setText(location);
        this.locationUpdated = revert ^ true;
    }

    private void computeAndSetLocation(String value, boolean silently) {
        this.setLocation(this.computeLocationValue(value), silently);
    }

    private String computeLocationValue(String value) {
        File file;
        if (value == null) {
            value = System.getProperty("user.home");
        }
        if (!(file = new File(value)).exists() && file.getParent() != null) {
            return this.computeLocationValue(file.getParent());
        }
        return file.exists() ? value : System.getProperty("user.home");
    }

    private boolean isStandAlone() {
        return this.standAloneModule.isSelected();
    }

    private boolean isSuiteComponent() {
        return this.suiteComponent.isSelected();
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.infoPanel = new JPanel();
        this.nameLbl = new JLabel();
        this.locationLbl = new JLabel();
        this.folderLbl = new JLabel();
        this.nameValue = new JTextField();
        this.locationValue = new JTextField();
        this.browseButton = new JButton();
        this.filler = new JLabel();
        this.folderValue = new JTextField();
        this.suitePlatform = new JLabel();
        this.suitePlatformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.manageSuitePlatform = new JButton();
        this.separator3 = new JSeparator();
        this.mainProject = new JCheckBox();
        this.typeChooserPanel = new JPanel();
        this.standAloneModule = new JRadioButton();
        this.platform = new JLabel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.managePlatform = new JButton();
        this.suiteComponent = new JRadioButton();
        this.moduleSuite = new JLabel();
        this.moduleSuiteValue = PlatformComponentFactory.getSuitesComboBox();
        this.browseSuiteButton = new JButton();
        this.chooserFiller = new JLabel();
        this.pnlThouShaltBeholdLayout = new JPanel();
        this.setLayout(new GridBagLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.nameLbl.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.nameLbl, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.nameLbl, gridBagConstraints);
        this.locationLbl.setLabelFor(this.locationValue);
        Mnemonics.setLocalizedText((JLabel)this.locationLbl, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"LBL_ProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.locationLbl, gridBagConstraints);
        this.folderLbl.setLabelFor(this.folderValue);
        Mnemonics.setLocalizedText((JLabel)this.folderLbl, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"LBL_ProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.folderLbl, gridBagConstraints);
        this.nameValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.nameValue, gridBagConstraints);
        this.locationValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.locationValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.browseLocation(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.browseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        this.infoPanel.add((Component)this.filler, gridBagConstraints);
        this.folderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.infoPanel.add((Component)this.folderValue, gridBagConstraints);
        this.suitePlatform.setLabelFor(this.suitePlatformValue);
        Mnemonics.setLocalizedText((JLabel)this.suitePlatform, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.suitePlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.suitePlatformValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageSuitePlatform, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_ManagePlatforms_g"));
        this.manageSuitePlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.manageSuitePlatformActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.manageSuitePlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.infoPanel.add((Component)this.separator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoPanel, gridBagConstraints);
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_SetAsMainProject"));
        this.mainProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.mainProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.mainProject, gridBagConstraints);
        this.typeChooserPanel.setLayout(new GridBagLayout());
        this.moduleTypeGroup.add(this.standAloneModule);
        this.standAloneModule.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.standAloneModule, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_StandaloneModule"));
        this.standAloneModule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.typeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.typeChooserPanel.add((Component)this.standAloneModule, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.platform, gridBagConstraints);
        this.platformValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.platformChosen(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.platformValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatform, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_ManagePlatforms_g"));
        this.managePlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.managePlatformActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.typeChooserPanel.add((Component)this.managePlatform, gridBagConstraints);
        this.moduleTypeGroup.add(this.suiteComponent);
        Mnemonics.setLocalizedText((AbstractButton)this.suiteComponent, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_AddToModuleSuite"));
        this.suiteComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.typeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.suiteComponent, gridBagConstraints);
        this.moduleSuite.setLabelFor(this.moduleSuiteValue);
        Mnemonics.setLocalizedText((JLabel)this.moduleSuite, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"LBL_ModuleSuite"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuite, gridBagConstraints);
        this.moduleSuiteValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.moduleSuiteChosen(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuiteValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseSuiteButton, (String)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"CTL_BrowseButton_w"));
        this.browseSuiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.browseModuleSuite(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.browseSuiteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.typeChooserPanel.add((Component)this.chooserFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.typeChooserPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlThouShaltBeholdLayout, gridBagConstraints);
    }

    private void manageSuitePlatformActionPerformed(ActionEvent evt) {
        this.managePlatform(this.suitePlatformValue);
    }

    private void mainProjectActionPerformed(ActionEvent evt) {
        this.mainProjectTouched = true;
    }

    private void managePlatformActionPerformed(ActionEvent evt) {
        this.managePlatform(this.platformValue);
    }

    private void managePlatform(JComboBox platformCombo) {
        NbPlatformCustomizer.showCustomizer();
        platformCombo.setModel(new PlatformComponentFactory.NbPlatformListModel());
        platformCombo.requestFocus();
        this.updateAndCheck();
    }

    private void platformChosen(ActionEvent evt) {
        this.updateAndCheck();
    }

    private void moduleSuiteChosen(ActionEvent evt) {
        if (!this.locationUpdated) {
            String suite = (String)this.moduleSuiteValue.getSelectedItem();
            this.computeAndSetLocation(suite, true);
            lastSelectedSuite = suite;
        }
        this.updateAndCheck();
    }

    private void browseModuleSuite(ActionEvent evt) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            File projectDir = chooser.getSelectedFile();
            UIUtil.setProjectChooserDirParent(projectDir);
            try {
                Project suite = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectDir));
                if (suite != null) {
                    String suiteDir = SuiteUtils.getSuiteDirectoryPath(suite);
                    if (suiteDir != null) {
                        PlatformComponentFactory.addUserSuite(suiteDir);
                        this.moduleSuiteValue.addItem(suiteDir);
                        this.moduleSuiteValue.setSelectedItem(suiteDir);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)BasicInfoVisualPanel.class, (String)"MSG_NotRegularSuite", (Object)ProjectUtils.getInformation((Project)suite).getDisplayName())));
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    private void typeChanged(ActionEvent evt) {
        if (!this.mainProjectTouched) {
            this.mainProject.setSelected(this.isStandAlone());
        }
        if (!this.locationUpdated) {
            this.setInitialLocation();
        }
        if (!this.nameUpdated) {
            this.setInitialProjectName();
        }
        this.updateAndCheck();
    }

    private void browseLocation(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.locationValue.getText());
        chooser.setFileSelectionMode(1);
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            this.computeAndSetLocation(chooser.getSelectedFile().getAbsolutePath(), false);
        }
    }

    static {
        $assertionsDisabled = !BasicInfoVisualPanel.class.desiredAssertionStatus();
    }
}

