/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.apisupport.project.ui.customizer.DragManager;

class SplashComponentPreview
extends JLabel {
    private FontMetrics fm;
    private Rectangle view;
    private Color color_text;
    private Color color_bar;
    private Color color_edge;
    private Color color_corner;
    private boolean draw_bar;
    protected Image image;
    private Rectangle dirty = new Rectangle();
    private String text;
    private Rectangle rect = new Rectangle();
    private Rectangle bar = new Rectangle();
    private Rectangle bar_inc = new Rectangle();
    private int progress = 0;
    private int maxSteps = 0;
    private int tmpSteps = 0;
    private int barStart = 0;
    private int barLength = 0;
    private DragManager dragManager = new DragManager(this);
    private DragManager.DragItem textDragItem = this.dragManager.createNewItem();
    private DragManager.DragItem progressDragItem = this.dragManager.createNewItem();

    void setFontSize(String fontSize) throws NumberFormatException {
        String sizeStr = fontSize;
        int size = Integer.parseInt(sizeStr);
        Font font = new Font("Dialog", 0, size);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
    }

    void setSplashImageIcon(URL url) {
        ImageIcon imgIcon = new ImageIcon(url);
        this.image = imgIcon.getImage();
    }

    void setDropHandletForProgress(DragManager.DropHandler dHandler) {
        this.progressDragItem.setDropHandler(dHandler);
    }

    void setDropHandletForText(DragManager.DropHandler dHandler) {
        this.textDragItem.setDropHandler(dHandler);
    }

    void setFontSize(int size) throws NumberFormatException {
        Font font = new Font("Dialog", 0, size);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
    }

    void setRunningTextBounds(Rectangle bounds) throws NumberFormatException {
        this.view = bounds;
    }

    void setProgressBarEnabled(boolean enabled) {
        this.draw_bar = enabled;
        this.progressDragItem.setEnabled(enabled);
    }

    void setProgressBarBounds(Rectangle bounds) throws NumberFormatException {
        this.bar = bounds;
        this.progressDragItem.setRectangle(this.bar);
    }

    void setColorCorner(Color color) throws NumberFormatException {
        this.color_corner = color;
    }

    void setColorEdge(Color color) throws NumberFormatException {
        this.color_edge = color;
    }

    void setTextColor(Color color) throws NumberFormatException {
        this.color_text = color;
    }

    void setColorBar(Color color) throws NumberFormatException {
        this.color_bar = color;
    }

    public void setText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (text == null) {
                    SplashComponentPreview.this.repaint(SplashComponentPreview.this.dirty);
                    return;
                }
                if (SplashComponentPreview.this.fm == null) {
                    return;
                }
                SplashComponentPreview.this.adjustText(text);
                SwingUtilities.layoutCompoundLabel(SplashComponentPreview.this.fm, text, null, 3, 2, 3, 2, SplashComponentPreview.this.view, new Rectangle(), SplashComponentPreview.this.rect, 0);
                SplashComponentPreview.this.textDragItem.setRectangle(SplashComponentPreview.this.view);
                SplashComponentPreview.this.dirty = SplashComponentPreview.this.dirty.union(SplashComponentPreview.this.rect);
                SplashComponentPreview.this.repaint();
                SplashComponentPreview.this.dirty = new Rectangle(SplashComponentPreview.this.rect);
            }
        });
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    public void addToMaxSteps(int steps) {
        this.tmpSteps += steps;
    }

    public void addAndSetMaxSteps(int steps) {
        this.tmpSteps += steps;
        this.maxSteps = this.tmpSteps;
    }

    public void increment(int steps) {
        if (this.draw_bar) {
            int bl;
            this.progress += steps;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((bl = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = bl;
                this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                this.repaint(this.bar_inc);
            }
        }
    }

    public void resetSteps() {
        this.progress = 0;
        this.barStart = 0;
        this.barLength = 0;
        this.increment(this.maxSteps);
    }

    private void adjustText(String text) {
        String newText = null;
        if (text == null) {
            return;
        }
        if (this.fm == null) {
            return;
        }
        int width = this.fm.stringWidth(text);
        if (width > this.view.width) {
            StringTokenizer st = new StringTokenizer(text);
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                String newString = newText == null ? element : newText + " " + element;
                if (this.fm.stringWidth(newString + "...") > this.view.width) {
                    this.text = newText + "...";
                    break;
                }
                newText = newString;
            }
        } else {
            this.text = text;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.dragManager.setTranslate(0, 0);
        this.originalPaint(g);
        this.dragManager.paint(g);
    }

    public void originalPaint(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        if (!this.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        graphics.setColor(this.color_text);
        graphics.drawImage(this.image, 0, 0, null);
        if (this.text == null) {
            return;
        }
        if (this.fm == null) {
            return;
        }
        SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
        if (this.draw_bar && !Boolean.getBoolean("netbeans.splash.nobar") && this.maxSteps > 0) {
            graphics.setColor(this.color_bar);
            graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
            graphics.setColor(this.color_corner);
            graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
            graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
            graphics.setColor(this.color_edge);
            graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
            graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
            this.barStart += this.barLength;
            this.barLength = 0;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public Rectangle getView() {
        return this.view;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textDragItem.setEnabled(enabled);
        this.progressDragItem.setEnabled(enabled & this.draw_bar);
    }
}

