/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ModuleProperties {
    public static final String PROPERTIES_REFRESHED = "propertiesRefreshed";
    static final RequestProcessor RP = new RequestProcessor(ModuleProperties.class.getName());
    static boolean runFromTests = false;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private EditableProperties projectProperties;
    private EditableProperties privateProperties;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    ModuleProperties(AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.reloadProperties();
    }

    protected void reloadProperties() {
        this.projectProperties = this.helper.getProperties("nbproject/project.properties");
        this.privateProperties = this.helper.getProperties("nbproject/private/private.properties");
    }

    abstract Map getDefaultValues();

    AntProjectHelper getHelper() {
        return this.helper;
    }

    PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    EditableProperties getProjectProperties() {
        return this.projectProperties;
    }

    EditableProperties getPrivateProperties() {
        return this.privateProperties;
    }

    final String getProperty(String key) {
        String value = this.getProjectProperties().getProperty(key);
        return value != null ? value : (String)this.getDefaultValues().get(key);
    }

    final boolean getBooleanProperty(String key) {
        String bValue = this.getProperty(key);
        return bValue != null && (bValue.equalsIgnoreCase("true") || bValue.equalsIgnoreCase("yes"));
    }

    final String removeProperty(String key) {
        return (String)this.getProjectProperties().remove((Object)key);
    }

    final String removePrivateProperty(String key) {
        return (String)this.getPrivateProperties().remove((Object)key);
    }

    final void setProperty(String key, String value) {
        String def = (String)this.getDefaultValues().get(key);
        if (def == null) {
            def = "";
        }
        if (value == null || def.equals(value)) {
            this.getProjectProperties().remove((Object)key);
        } else {
            this.getProjectProperties().setProperty(key, value);
        }
        this.firePropertyChange(key, null, value);
    }

    final void setPrivateProperty(String key, String value) {
        String def = (String)this.getDefaultValues().get(key);
        if (def == null) {
            def = "";
        }
        if (def.equals(value)) {
            this.getPrivateProperties().remove((Object)key);
        } else {
            this.getPrivateProperties().setProperty(key, value);
        }
        this.firePropertyChange(key, null, value);
    }

    void setProperty(String key, String[] value) {
        this.getProjectProperties().setProperty(key, value);
        this.firePropertyChange(key, null, null);
    }

    final void setBooleanProperty(String key, boolean bProp) {
        this.setProperty(key, Boolean.toString(bProp));
    }

    String getProjectDisplayName() {
        return Util.getDisplayName(this.getHelper().getProjectDirectory());
    }

    final File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory());
    }

    final String getProjectDirectory() {
        return this.getProjectDirectoryFile().getAbsolutePath();
    }

    void storeProperties() throws IOException {
        this.getHelper().putProperties("nbproject/project.properties", this.getProjectProperties());
        this.getHelper().putProperties("nbproject/private/private.properties", this.getPrivateProperties());
    }

    static void storePlatform(AntProjectHelper helper, NbPlatform platform) {
        if (platform != null) {
            EditableProperties props = helper.getProperties("nbproject/platform.properties");
            props.put((Object)"nbplatform.active", (Object)platform.getID());
            helper.putProperties("nbproject/platform.properties", props);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.removePropertyChangeListener(pchl);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propName, oldValue, newValue);
    }

    protected void firePropertiesRefreshed() {
        this.firePropertyChange(PROPERTIES_REFRESHED, null, null);
    }

    protected static void reportLostPlatform(NbPlatform lostPlatform) {
        String plafText = lostPlatform != null ? '\"' + lostPlatform.getLabel() + '\"' : NbBundle.getMessage((Class)ModuleProperties.class, (String)"MSG_PreviouslySet");
        String message = NbBundle.getMessage((Class)ModuleProperties.class, (String)"MSG_PlatformNotFound", (Object)plafText);
        if (!runFromTests) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
        } else {
            System.err.println(message);
        }
    }

    static String getPlatformID(JavaPlatform platform) {
        return (String)platform.getProperties().get("platform.ant.name");
    }

    static JavaPlatform findJavaPlatformByID(String id) {
        if (id == null || id.equals("default")) {
            return JavaPlatform.getDefault();
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            if (!id.equals(ModuleProperties.getPlatformID(platforms[i]))) continue;
            return platforms[i];
        }
        return null;
    }

    static void storeJavaPlatform(AntProjectHelper helper, PropertyEvaluator eval, JavaPlatform platform, boolean isNetBeansOrg) throws IOException {
        if (isNetBeansOrg) {
            FileObject nbbuild;
            File home;
            final boolean isDefault = platform == null || platform == JavaPlatform.getDefault();
            File file = home = isDefault ? null : ModuleProperties.getPlatformLocation(platform);
            if ((home != null || isDefault) && (nbbuild = helper.resolveFileObject(eval.evaluate("${nb_all}/nbbuild"))) != null) {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws IOException {
                            FileObject userBuildProperties = nbbuild.getFileObject("user.build.properties");
                            if (userBuildProperties == null) {
                                userBuildProperties = nbbuild.createData("user.build.properties");
                            }
                            EditableProperties ep = Util.loadProperties(userBuildProperties);
                            if (isDefault) {
                                ep.remove((Object)"nbjdk.home");
                            } else {
                                ep.setProperty("nbjdk.home", home.getAbsolutePath());
                            }
                            Util.storeProperties(userBuildProperties, ep);
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    throw (IOException)e.getException();
                }
            }
        } else {
            EditableProperties props = helper.getProperties("nbproject/platform.properties");
            if (platform == null || platform == JavaPlatform.getDefault()) {
                if (props.containsKey((Object)"nbjdk.active")) {
                    props.put((Object)"nbjdk.active", (Object)"default");
                }
            } else {
                props.put((Object)"nbjdk.active", (Object)ModuleProperties.getPlatformID(platform));
            }
            helper.putProperties("nbproject/platform.properties", props);
        }
    }

    private static File getPlatformLocation(JavaPlatform platform) {
        Collection installs = platform.getInstallFolders();
        if (installs.size() == 1) {
            return FileUtil.toFile((FileObject)((FileObject)installs.iterator().next()));
        }
        return null;
    }

    public static JavaPlatform findJavaPlatformByLocation(String home) {
        if (home == null) {
            return JavaPlatform.getDefault();
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            if (!new File(home).equals(ModuleProperties.getPlatformLocation(platforms[i]))) continue;
            return platforms[i];
        }
        return null;
    }
}

