/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Utilities;

public final class ModuleDependency
implements Comparable {
    private String releaseVersion;
    private String specVersion;
    private static final String SPEC_VERSION_LAZY = "<lazy>";
    private boolean implDep;
    private boolean compileDep;
    private ModuleEntry me;
    private Set filterTokensNotFriend;
    private Set filterTokensFriend;
    public static final Comparator LOCALIZED_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            ModuleEntry me1 = ((ModuleDependency)o1).getModuleEntry();
            ModuleEntry me2 = ((ModuleDependency)o2).getModuleEntry();
            int result = Collator.getInstance().compare(me1.getLocalizedName(), me2.getLocalizedName());
            return result != 0 ? result : me1.getCodeNameBase().compareTo(me2.getCodeNameBase());
        }
    };
    public static final Comparator CNB_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ModuleDependency)o1).getCodeNameBase().compareTo(((ModuleDependency)o2).getCodeNameBase());
        }
    };

    public ModuleDependency(ModuleEntry me) {
        this(me, me.getReleaseVersion(), SPEC_VERSION_LAZY, me.getPublicPackages().length > 0, false);
    }

    public ModuleDependency(ModuleEntry me, String releaseVersion, String specVersion, boolean compileDep, boolean implDep) {
        this.me = me;
        this.compileDep = compileDep;
        this.implDep = implDep;
        this.releaseVersion = releaseVersion;
        this.specVersion = specVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        if (this.specVersion == SPEC_VERSION_LAZY) {
            this.specVersion = this.me.getSpecificationVersion();
        }
        return this.specVersion;
    }

    public ModuleEntry getModuleEntry() {
        return this.me;
    }

    private String getCodeNameBase() {
        return this.getModuleEntry().getCodeNameBase();
    }

    public int compareTo(Object o) {
        ModuleDependency other = (ModuleDependency)o;
        int result = this.getCodeNameBase().compareTo(other.getCodeNameBase());
        if (result != 0) {
            return result;
        }
        String relVersion = other.getReleaseVersion();
        int n = this.getReleaseVersion() == null ? (relVersion == null ? 0 : -1) : (result = relVersion == null ? 1 : this.getReleaseVersion().compareTo(relVersion));
        if (result != 0) {
            return result;
        }
        if (this.specVersion != SPEC_VERSION_LAZY || other.specVersion != SPEC_VERSION_LAZY) {
            String otherSpec = other.getSpecificationVersion();
            String spec = this.getSpecificationVersion();
            int n2 = spec == null ? (otherSpec == null ? 0 : -1) : (result = otherSpec == null ? 1 : spec.compareTo(otherSpec));
            if (result != 0) {
                return result;
            }
        }
        int n3 = this.hasImplementationDepedendency() == other.hasImplementationDepedendency() ? 0 : (result = this.implDep ? 1 : -1);
        if (result != 0) {
            return result;
        }
        result = this.hasCompileDependency() == other.hasCompileDependency() ? 0 : (this.compileDep ? 1 : -1);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ModuleDependency) {
            ModuleDependency other = (ModuleDependency)o;
            return this.getCodeNameBase().equals(other.getCodeNameBase()) && Utilities.compareObjects((Object)this.getReleaseVersion(), (Object)other.getReleaseVersion()) && (this.specVersion == SPEC_VERSION_LAZY && other.specVersion == SPEC_VERSION_LAZY || Utilities.compareObjects((Object)this.getSpecificationVersion(), (Object)other.getSpecificationVersion())) && this.hasImplementationDepedendency() == other.hasImplementationDepedendency() && this.hasCompileDependency() == other.hasCompileDependency();
        }
        return false;
    }

    public int hashCode() {
        return this.getCodeNameBase().hashCode();
    }

    public boolean hasCompileDependency() {
        return this.compileDep;
    }

    public boolean hasImplementationDepedendency() {
        return this.implDep;
    }

    Set getFilterTokens(String dependingModuleCNB) {
        HashSet<String> filterTokens;
        boolean friend = this.me.isDeclaredAsFriend(dependingModuleCNB);
        Set<String> set = filterTokens = friend ? this.filterTokensFriend : this.filterTokensNotFriend;
        if (filterTokens == null) {
            filterTokens = new HashSet<String>();
            filterTokens.add(this.me.getCodeNameBase());
            filterTokens.add(this.me.getLocalizedName());
            filterTokens.add(this.me.getJarLocation().getAbsolutePath());
            String[] cpext = PropertyUtils.tokenizePath((String)this.me.getClassPathExtensions());
            for (int i = 0; i < cpext.length; ++i) {
                filterTokens.add(cpext[i]);
            }
            if (friend) {
                Iterator it = this.me.getPublicClassNames().iterator();
                while (it.hasNext()) {
                    String clazz = (String)it.next();
                    filterTokens.add(clazz.replace('$', '.'));
                }
            }
            if (friend) {
                this.filterTokensFriend = filterTokens;
            } else {
                this.filterTokensNotFriend = filterTokens;
            }
        }
        return filterTokens;
    }

    public String toString() {
        return "ModuleDependency[me: " + this.getModuleEntry() + ", relVer: " + this.getReleaseVersion() + ", specVer: " + this.getSpecificationVersion() + ", implDep: " + this.hasImplementationDepedendency() + ", compDep: " + this.hasCompileDependency() + "]";
    }
}

