/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.BrandingSupport;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public class BasicBrandingModel {
    private BrandingSupport branding;
    private SuiteProperties suiteProps;
    public static final String NAME_PROPERTY = "app.name";
    public static final String TITLE_PROPERTY = "app.title";
    public static final String ICON_LOCATION_PROPERTY = "app.icon";
    public static final String BRANDING_TOKEN_PROPERTY = "branding.token";
    static final int ICON_WIDTH = 48;
    static final int ICON_HEIGHT = 48;
    private boolean brandingEnabled;
    private String name;
    private String title;
    private BrandingSupport.BrandedFile icon = null;
    private BrandingSupport.BundleKey productInformation = null;
    private BrandingSupport.BundleKey mainWindowTitle = null;
    private BrandingSupport.BundleKey mainWindowTitleNoProject = null;
    private BrandingSupport.BundleKey currentVersion = null;
    private BrandingSupport.BrandedFile splash = null;
    private BrandingSupport.BundleKey splashWidth = null;
    private BrandingSupport.BundleKey splashHeight = null;
    private BrandingSupport.BundleKey splashShowProgressBar = null;
    private BrandingSupport.BundleKey splashRunningTextBounds = null;
    private BrandingSupport.BundleKey splashProgressBarBounds = null;
    private BrandingSupport.BundleKey splashRunningTextFontSize = null;
    private BrandingSupport.BundleKey splashRunningTextColor = null;
    private BrandingSupport.BundleKey splashProgressBarColor = null;
    private BrandingSupport.BundleKey splashProgressBarEdgeColor = null;
    private BrandingSupport.BundleKey splashProgressBarCornerColor = null;
    private final Set listeners = new HashSet();
    private Set splashKeys = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicBrandingModel(SuiteProperties suiteProps) {
        this.suiteProps = suiteProps;
        this.init();
    }

    public boolean isBrandingEnabled() {
        return this.brandingEnabled;
    }

    public void setBrandingEnabled(boolean brandingEnabled) {
        if (this.brandingEnabled != brandingEnabled) {
            this.brandingEnabled = brandingEnabled;
            this.fireChange();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.isBrandingEnabled()) {
            this.name = name;
            this.suiteProps.setProperty(NAME_PROPERTY, this.getName());
            this.suiteProps.setProperty(BRANDING_TOKEN_PROPERTY, "${app.name}");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public void setTitle(String title) {
        if (this.isBrandingEnabled()) {
            this.title = title;
            if (this.productInformation != null) {
                this.productInformation.setValue(title);
            }
            if (this.mainWindowTitle != null) {
                this.mainWindowTitle.setValue(title + " {0}");
            }
            if (this.mainWindowTitleNoProject != null) {
                this.mainWindowTitleNoProject.setValue(title + " {0}");
            }
            if (this.currentVersion != null) {
                this.currentVersion.setValue(title + " {0}");
            }
            this.suiteProps.setProperty(TITLE_PROPERTY, this.getTitle());
        }
    }

    public URL getIconSource() {
        return this.icon != null ? this.icon.getBrandingSource() : null;
    }

    public void setIconSource(URL url) {
        if (this.isBrandingEnabled()) {
            this.icon.setBrandingSource(url);
            this.suiteProps.setProperty(ICON_LOCATION_PROPERTY, this.getIconLocation());
        }
    }

    public String getIconLocation() {
        File prj = FileUtil.toFile((FileObject)this.suiteProps.getProject().getProjectDirectory());
        String relativePath = PropertyUtils.relativizeFile((File)prj, (File)this.icon.getFileLocation());
        return relativePath;
    }

    public String getSplashLocation() {
        File prj = FileUtil.toFile((FileObject)this.suiteProps.getProject().getProjectDirectory());
        String relativePath = PropertyUtils.relativizeFile((File)prj, (File)this.splash.getFileLocation());
        return relativePath;
    }

    public void store() throws IOException {
        if (this.brandingEnabled) {
            this.getBranding().brandBundleKey(this.productInformation);
            this.getBranding().brandBundleKey(this.mainWindowTitle);
            this.getBranding().brandBundleKey(this.mainWindowTitleNoProject);
            this.getBranding().brandBundleKey(this.currentVersion);
            this.getBranding().brandFile(this.icon, this.getScaleAndStoreIconTask());
            this.getBranding().brandBundleKeys(this.splashKeys);
            this.getBranding().brandFile(this.splash);
        } else {
            this.suiteProps.removeProperty(BRANDING_TOKEN_PROPERTY);
            this.suiteProps.removeProperty(NAME_PROPERTY);
            this.suiteProps.removeProperty(TITLE_PROPERTY);
            this.suiteProps.removeProperty(ICON_LOCATION_PROPERTY);
        }
    }

    private Runnable getScaleAndStoreIconTask() throws IOException {
        return new Runnable(){

            public void run() {
                BufferedImage bi = new BufferedImage(48, 48, 1);
                Graphics2D g2 = bi.createGraphics();
                ImageIcon image = new ImageIcon(BasicBrandingModel.this.icon.getBrandingSource());
                g2.drawImage(image.getImage(), 0, 0, 48, 48, Color.LIGHT_GRAY, null);
                g2.dispose();
                try {
                    ImageIO.write((RenderedImage)bi, "png", BasicBrandingModel.this.icon.getFileLocation());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        };
    }

    private BrandingSupport getBranding() {
        if (this.branding == null) {
            try {
                this.branding = BrandingSupport.getInstance(this.suiteProps);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                throw new IllegalStateException(ex.getLocalizedMessage());
            }
        }
        return this.branding;
    }

    private void init() {
        this.initBundleKeys();
        this.initName(false);
        this.initTitle(false);
        this.brandingEnabledRefresh();
    }

    void brandingEnabledRefresh() {
        this.brandingEnabled = this.suiteProps.getProperty(BRANDING_TOKEN_PROPERTY) != null;
    }

    private String getSimpleName() {
        Element nameEl = Util.findElement(this.suiteProps.getProject().getHelper().getPrimaryConfigurationData(true), "name", "http://www.netbeans.org/ns/nb-module-suite-project/1");
        String text = nameEl != null ? Util.findText(nameEl) : null;
        return text != null ? text : "???";
    }

    void initName(boolean reread) {
        if (this.name == null || reread) {
            this.name = this.suiteProps.getProperty(NAME_PROPERTY);
        }
        if (this.name == null) {
            this.name = this.getSimpleName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_");
            if (!this.name.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
                this.name = "app";
            }
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
    }

    void initTitle(boolean reread) {
        if (this.title == null || reread) {
            String initTitle = this.suiteProps.getProperty(TITLE_PROPERTY);
            if (initTitle == null && Character.isLowerCase((initTitle = this.getSimpleName()).charAt(0))) {
                initTitle = String.valueOf(Character.toLowerCase(initTitle.charAt(0))) + initTitle.substring(1);
            }
            if (!$assertionsDisabled && initTitle == null) {
                throw new AssertionError();
            }
            this.title = initTitle;
        }
    }

    private void initBundleKeys() {
        this.productInformation = this.getBranding().getBundleKey("org.netbeans.core", "org/netbeans/core/ui/Bundle.properties", "LBL_ProductInformation");
        if (!$assertionsDisabled && this.productInformation == null) {
            throw new AssertionError();
        }
        this.mainWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title");
        if (!$assertionsDisabled && this.mainWindowTitle == null) {
            throw new AssertionError();
        }
        this.mainWindowTitleNoProject = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title_No_Project");
        if (!$assertionsDisabled && this.mainWindowTitleNoProject == null) {
            throw new AssertionError();
        }
        this.currentVersion = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "currentVersion");
        if (!$assertionsDisabled && this.currentVersion == null) {
            throw new AssertionError();
        }
        this.icon = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame48.gif");
        if (!$assertionsDisabled && this.icon == null) {
            throw new AssertionError();
        }
        this.splash = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/splash.gif");
        if (!$assertionsDisabled && this.splash == null) {
            throw new AssertionError();
        }
        this.splashWidth = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_WIDTH");
        if (!$assertionsDisabled && this.splashWidth == null) {
            throw new AssertionError();
        }
        this.splashHeight = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_HEIGHT");
        if (!$assertionsDisabled && this.splashHeight == null) {
            throw new AssertionError();
        }
        this.splashShowProgressBar = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashShowProgressBar");
        if (!$assertionsDisabled && this.splashShowProgressBar == null) {
            throw new AssertionError();
        }
        this.splashRunningTextFontSize = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextFontSize");
        if (!$assertionsDisabled && this.splashRunningTextFontSize == null) {
            throw new AssertionError();
        }
        this.splashProgressBarBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarBounds");
        if (!$assertionsDisabled && this.splashProgressBarBounds == null) {
            throw new AssertionError();
        }
        this.splashRunningTextBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextBounds");
        if (!$assertionsDisabled && this.splashRunningTextBounds == null) {
            throw new AssertionError();
        }
        this.splashRunningTextColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextColor");
        if (!$assertionsDisabled && this.splashRunningTextColor == null) {
            throw new AssertionError();
        }
        this.splashProgressBarColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarColor");
        if (!$assertionsDisabled && this.splashProgressBarColor == null) {
            throw new AssertionError();
        }
        this.splashProgressBarEdgeColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarEdgeColor");
        if (!$assertionsDisabled && this.splashProgressBarEdgeColor == null) {
            throw new AssertionError();
        }
        this.splashProgressBarCornerColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarCornerColor");
        if (!$assertionsDisabled && this.splashProgressBarCornerColor == null) {
            throw new AssertionError();
        }
        this.splashKeys.clear();
        this.splashKeys.add(this.splashWidth);
        this.splashKeys.add(this.splashHeight);
        this.splashKeys.add(this.splashShowProgressBar);
        this.splashKeys.add(this.splashRunningTextBounds);
        this.splashKeys.add(this.splashProgressBarBounds);
        this.splashKeys.add(this.splashRunningTextFontSize);
        this.splashKeys.add(this.splashRunningTextColor);
        this.splashKeys.add(this.splashProgressBarColor);
        this.splashKeys.add(this.splashProgressBarEdgeColor);
        this.splashKeys.add(this.splashProgressBarCornerColor);
        this.splashKeys.remove(null);
    }

    public BrandingSupport.BundleKey getSplashWidth() {
        return this.splashWidth;
    }

    public BrandingSupport.BundleKey getSplashHeight() {
        return this.splashHeight;
    }

    public BrandingSupport.BundleKey getSplashShowProgressBar() {
        return this.splashShowProgressBar;
    }

    public BrandingSupport.BundleKey getSplashRunningTextBounds() {
        return this.splashRunningTextBounds;
    }

    public BrandingSupport.BundleKey getSplashProgressBarBounds() {
        return this.splashProgressBarBounds;
    }

    public BrandingSupport.BundleKey getSplashRunningTextFontSize() {
        return this.splashRunningTextFontSize;
    }

    public BrandingSupport.BundleKey getSplashRunningTextColor() {
        return this.splashRunningTextColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarColor() {
        return this.splashProgressBarColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarEdgeColor() {
        return this.splashProgressBarEdgeColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarCornerColor() {
        return this.splashProgressBarCornerColor;
    }

    public BrandingSupport.BrandedFile getSplash() {
        return this.splash;
    }

    static {
        $assertionsDisabled = !BasicBrandingModel.class.desiredAssertionStatus();
    }
}

