/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class SuiteActions
implements ActionProvider {
    private final SuiteProject project;
    private static final int PROMPT_FOR_APP_NAME_MODE_JNLP = 0;
    private static final int PROMPT_FOR_APP_NAME_MODE_ZIP = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    static Action[] getProjectActions(SuiteProject project) {
        ArrayList<Action> actions;
        block7: {
            actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_build"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_rebuild"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_clean"), null));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_run"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_debug"), null));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build-zip", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_zip"), null));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build-jnlp", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_build_jnlp"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"run-jnlp", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_run_jnlp"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug-jnlp", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_debug_jnlp"), null));
            actions.add(null);
            NbPlatform platform = project.getPlatform(false);
            if (platform != null && platform.getHarnessVersion() >= 2) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"nbms", (String)NbBundle.getMessage((Class)SuiteActions.class, (String)"SUITE_ACTION_nbms"), null));
                actions.add(null);
            }
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.openSubprojectsAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add((Action)SystemAction.get((Class)FindAction.class));
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            try {
                FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
                FileObject fo = sfs.findResource("Projects/Actions");
                if (fo != null) {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                    Lookup.Template query = new Lookup.Template(Object.class);
                    Lookup lookup = actionRegistry.getLookup();
                    Iterator it = lookup.lookup(query).allInstances().iterator();
                    if (it.hasNext()) {
                        actions.add(null);
                    }
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof Action) {
                            actions.add((Action)next);
                            continue;
                        }
                        if (!(next instanceof JSeparator)) continue;
                        actions.add(null);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)ex);
            }
        }
        actions.add(null);
        actions.add((Action)SystemAction.get((Class)ToolsAction.class));
        actions.add(null);
        actions.add(CommonProjectActions.customizeProjectAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public SuiteActions(SuiteProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        return new String[]{"build", "clean", "rebuild", "run", "debug", "build-zip", "build-jnlp", "run-jnlp", "debug-jnlp", "nbms", "profile", "rename", "move", "delete"};
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command) || "rename".equals(command) || "move".equals(command)) {
            return true;
        }
        if (Arrays.asList(this.getSupportedActions()).contains(command)) {
            return SuiteActions.findBuildXml(this.project) != null;
        }
        throw new IllegalArgumentException(command);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
        } else if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
        } else if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
        } else {
            try {
                this.invokeActionImpl(command, context);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
    }

    public ExecutorTask invokeActionImpl(String command, Lookup context) throws IllegalArgumentException, IOException {
        String[] targetNames;
        if (command.equals("build")) {
            targetNames = new String[]{"build"};
        } else if (command.equals("clean")) {
            targetNames = new String[]{"clean"};
        } else if (command.equals("rebuild")) {
            targetNames = new String[]{"clean", "build"};
        } else if (command.equals("run")) {
            targetNames = new String[]{"run"};
        } else if (command.equals("debug")) {
            targetNames = new String[]{"debug"};
        } else if (command.equals("build-zip")) {
            if (this.promptForAppName(1)) {
                return null;
            }
            targetNames = new String[]{"build-zip"};
        } else if (command.equals("build-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{"build-jnlp"};
        } else if (command.equals("run-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{"run-jnlp"};
        } else if (command.equals("debug-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{"debug-jnlp"};
        } else if (command.equals("nbms")) {
            targetNames = new String[]{"nbms"};
        } else if (command.equals("profile")) {
            targetNames = new String[]{"profile"};
        } else {
            throw new IllegalArgumentException(command);
        }
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])targetNames, null);
    }

    private static FileObject findBuildXml(SuiteProject project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean promptForAppName(int mode) {
        String msg;
        String name = this.project.getEvaluator().getProperty("app.name");
        if (name != null) {
            return false;
        }
        switch (mode) {
            case 0: {
                msg = NbBundle.getMessage((Class)ModuleActions.class, (String)"ERR_app_name_jnlp");
                break;
            }
            case 1: {
                msg = NbBundle.getMessage((Class)ModuleActions.class, (String)"ERR_app_name_zip");
                break;
            }
            default: {
                throw new AssertionError(mode);
            }
        }
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage((Class)ModuleActions.class, (String)"TITLE_app_name"), msg, NbBundle.getMessage((Class)ModuleActions.class, (String)"LBL_configure_app_name"), null, 2)) {
            SuiteCustomizer cpi = (SuiteCustomizer)this.project.getLookup().lookup(SuiteCustomizer.class);
            cpi.showCustomizer("Application", "standaloneApp");
        }
        return true;
    }

    static {
        $assertionsDisabled = !SuiteActions.class.desiredAssertionStatus();
    }
}

