/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.PlatformNode;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class LibrariesNode
extends AbstractNode {
    static final String LIBRARIES_NAME = "libraries";
    private static final String DISPLAY_NAME = LibrariesNode.getMessage("LBL_libraries");
    private Action[] actions;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$customizer$AddModulePanel;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$NbModuleProject;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$customizer$EditDependencyPanel;

    public LibrariesNode(NbModuleProject project) {
        super((Children)new LibrariesChildren(project));
        this.setName(LIBRARIES_NAME);
        this.setDisplayName(DISPLAY_NAME);
        this.actions = Util.getModuleType(project) == NbModuleTypeProvider.SUITE_COMPONENT ? new Action[]{new AddModuleDependencyAction(project), new SuiteLogicalView.AddNewLibraryWrapperAction(project, project)} : new Action[]{new AddModuleDependencyAction(project)};
    }

    public Image getIcon(int type) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean opened) {
        Image badge = Utilities.loadImage((String)"org/netbeans/modules/apisupport/project/ui/resources/libraries-badge.png", (boolean)true);
        return Utilities.mergeImages((Image)UIUtil.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    public Action[] getActions(boolean context) {
        return this.actions;
    }

    private static String createHtmlDescription(ModuleDependency dep) {
        StringBuffer shortDesc = new StringBuffer("<html><u>" + dep.getModuleEntry().getCodeNameBase() + "</u><br>");
        if (dep.hasImplementationDepedendency()) {
            shortDesc.append("<br><font color=\"red\">" + LibrariesNode.getMessage("CTL_ImplementationDependency") + "</font>");
        }
        if (dep.hasCompileDependency()) {
            shortDesc.append("<br>" + LibrariesNode.getMessage("CTL_NeededToCompile"));
        }
        if (dep.getReleaseVersion() != null) {
            shortDesc.append("<br>" + NbBundle.getMessage((Class)LibrariesNode.class, (String)"CTL_MajorReleaseVersion", (Object)dep.getReleaseVersion()));
        }
        if (dep.getSpecificationVersion() != null) {
            shortDesc.append("<br>" + NbBundle.getMessage((Class)LibrariesNode.class, (String)"CTL_SpecificationVersion", (Object)dep.getSpecificationVersion()));
        }
        shortDesc.append("</html>");
        return shortDesc.toString();
    }

    private static String getMessage(String bundleKey) {
        return NbBundle.getMessage((Class)LibrariesNode.class, (String)bundleKey);
    }

    private static final class OpenProjectAction
    extends CookieAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        private OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            block6: {
                try {
                    final Project[] projects = new Project[activatedNodes.length];
                    for (int i = 0; i < activatedNodes.length; ++i) {
                        ModuleDependency dep = (ModuleDependency)activatedNodes[i].getLookup().lookup(class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency == null ? LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency") : class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency);
                        if (!$assertionsDisabled && dep == null) {
                            throw new AssertionError();
                        }
                        File prjDir = dep.getModuleEntry().getSourceLocation();
                        if (!$assertionsDisabled && prjDir == null) {
                            throw new AssertionError();
                        }
                        Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)prjDir));
                        if (!$assertionsDisabled && project == null) {
                            throw new AssertionError();
                        }
                        projects[i] = project;
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            String previousText = StatusDisplayer.getDefault().getStatusText();
                            StatusDisplayer.getDefault().setStatusText(LibrariesNode.getMessage("MSG_OpeningProjects"));
                            OpenProjects.getDefault().open(projects, false);
                            StatusDisplayer.getDefault().setStatusText(previousText);
                        }
                    });
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)e);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }

        public String getName() {
            return LibrariesNode.getMessage("CTL_Open");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency")) : class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency};
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$LibrariesNode == null ? (class$org$netbeans$modules$apisupport$project$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.LibrariesNode")) : class$org$netbeans$modules$apisupport$project$ui$LibrariesNode).desiredAssertionStatus();
        }
    }

    private static final class ShowJavadocAction
    extends AbstractAction {
        private final ModuleDependency dep;
        private final NbModuleProject project;
        private URL currectJavadoc;

        ShowJavadocAction(ModuleDependency dep, NbModuleProject project) {
            super(LibrariesNode.getMessage("CTL_ShowJavadoc"));
            this.dep = dep;
            this.project = project;
        }

        public void actionPerformed(ActionEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.currectJavadoc);
        }

        public boolean isEnabled() {
            this.currectJavadoc = Util.getModuleType(this.project) == NbModuleTypeProvider.NETBEANS_ORG ? Util.findJavadocForNetBeansOrgModules(this.dep) : Util.findJavadoc(this.dep, this.project.getPlatform(true));
            return this.currectJavadoc != null;
        }
    }

    private static final class EditDependencyAction
    extends AbstractAction {
        private final ModuleDependency dep;
        private final NbModuleProject project;

        EditDependencyAction(ModuleDependency dep, NbModuleProject project) {
            super(LibrariesNode.getMessage("CTL_EditDependency"));
            this.dep = dep;
            this.project = project;
        }

        public void actionPerformed(ActionEvent ev) {
            EditDependencyPanel editPanel = new EditDependencyPanel(this.dep, NbPlatform.getPlatformByDestDir(this.dep.getModuleEntry().getDestDir()));
            DialogDescriptor descriptor = new DialogDescriptor((Object)editPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$LibrariesNode == null ? (class$org$netbeans$modules$apisupport$project$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.LibrariesNode")) : class$org$netbeans$modules$apisupport$project$ui$LibrariesNode), (String)"CTL_EditModuleDependencyTitle", (Object)this.dep.getModuleEntry().getLocalizedName()));
            descriptor.setHelpCtx(new HelpCtx(class$org$netbeans$modules$apisupport$project$ui$customizer$EditDependencyPanel == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$EditDependencyPanel = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel")) : class$org$netbeans$modules$apisupport$project$ui$customizer$EditDependencyPanel));
            Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
            d.setVisible(true);
            if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                ModuleDependency editedDep = editPanel.getEditedDependency();
                try {
                    ProjectXMLManager pxm = new ProjectXMLManager(this.project);
                    TreeSet<ModuleDependency> deps = new TreeSet<ModuleDependency>(pxm.getDirectDependencies());
                    deps.remove(this.dep);
                    deps.add(editedDep);
                    pxm.replaceDependencies(deps);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Cannot store dependency: " + editedDep);
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            d.dispose();
        }
    }

    private static final class RemoveDependencyAction
    extends CookieAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        private RemoveDependencyAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            Set<ModuleDependency> deps;
            NbModuleProject project;
            HashMap<NbModuleProject, HashSet<ModuleDependency>> map = new HashMap<NbModuleProject, HashSet<ModuleDependency>>();
            for (int i = 0; i < activatedNodes.length; ++i) {
                ModuleDependency dep = (ModuleDependency)activatedNodes[i].getLookup().lookup(class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency == null ? LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency") : class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency);
                if (!$assertionsDisabled && dep == null) {
                    throw new AssertionError();
                }
                project = (NbModuleProject)activatedNodes[i].getLookup().lookup(class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? LibrariesNode.class$("org.netbeans.modules.apisupport.project.NbModuleProject") : class$org$netbeans$modules$apisupport$project$NbModuleProject);
                if (!$assertionsDisabled && project == null) {
                    throw new AssertionError();
                }
                deps = (Set)map.get(project);
                if (deps == null) {
                    deps = new HashSet<ModuleDependency>();
                    map.put(project, (HashSet<ModuleDependency>)deps);
                }
                deps.add(dep);
            }
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                project = (NbModuleProject)me.getKey();
                deps = (HashSet<ModuleDependency>)me.getValue();
                ProjectXMLManager pxm = new ProjectXMLManager(project);
                pxm.removeDependencies(deps);
                try {
                    ProjectManager.getDefault().saveProject((Project)project);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Problem during dependencies removing");
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public String getName() {
            return LibrariesNode.getMessage("CTL_RemoveDependency");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency")) : class$org$netbeans$modules$apisupport$project$ui$customizer$ModuleDependency, class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = LibrariesNode.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject};
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$LibrariesNode == null ? (class$org$netbeans$modules$apisupport$project$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.LibrariesNode")) : class$org$netbeans$modules$apisupport$project$ui$LibrariesNode).desiredAssertionStatus();
        }
    }

    private static final class AddModuleDependencyAction
    extends AbstractAction {
        private final NbModuleProject project;

        AddModuleDependencyAction(NbModuleProject project) {
            super(LibrariesNode.getMessage("CTL_AddModuleDependency"));
            this.project = project;
        }

        public void actionPerformed(ActionEvent ev) {
            SingleModuleProperties props = SingleModuleProperties.getInstance(this.project);
            final AddModulePanel addPanel = new AddModulePanel(props);
            DialogDescriptor descriptor = new DialogDescriptor((Object)addPanel, LibrariesNode.getMessage("CTL_AddModuleDependencyTitle"));
            descriptor.setHelpCtx(new HelpCtx(class$org$netbeans$modules$apisupport$project$ui$customizer$AddModulePanel == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$AddModulePanel = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel")) : class$org$netbeans$modules$apisupport$project$ui$customizer$AddModulePanel));
            descriptor.setClosingOptions(new Object[0]);
            final Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
            descriptor.setButtonListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DialogDescriptor.OK_OPTION.equals(e.getSource()) && addPanel.getSelectedDependencies().length == 0) {
                        return;
                    }
                    d.setVisible(false);
                    d.dispose();
                }
            });
            d.setVisible(true);
            if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                ModuleDependency[] newDeps = addPanel.getSelectedDependencies();
                ProjectXMLManager pxm = new ProjectXMLManager(this.project);
                try {
                    for (int i = 0; i < newDeps.length; ++i) {
                        pxm.addDependency(newDeps[i]);
                    }
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Cannot add selected dependencies: " + Arrays.asList(newDeps));
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            d.dispose();
        }
    }

    private static final class LibraryDependencyNode
    extends FilterNode {
        private final ModuleDependency dep;
        private final NbModuleProject project;
        private Action[] actions;

        LibraryDependencyNode(ModuleDependency dep, NbModuleProject project, Node original) {
            super(original, null, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.fixed((Object[])new Object[]{dep, project})}));
            this.dep = dep;
            this.project = project;
            this.setShortDescription(LibrariesNode.createHtmlDescription(dep));
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                LinkedHashSet<Action> result = new LinkedHashSet<Action>();
                result.add(new EditDependencyAction(this.dep, this.project));
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof FindAction)) continue;
                    result.add(superActions[i]);
                }
                result.add(new ShowJavadocAction(this.dep, this.project));
                result.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = result.toArray(new Action[result.size()]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    private static final class ProjectDependencyNode
    extends AbstractNode {
        private final ModuleDependency dep;
        private final NbModuleProject project;
        private Action[] actions;

        ProjectDependencyNode(ModuleDependency dep, NbModuleProject project) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{dep, project}));
            this.dep = dep;
            this.project = project;
            ModuleEntry me = dep.getModuleEntry();
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.gif");
            this.setDisplayName(me.getLocalizedName());
            this.setShortDescription(LibrariesNode.createHtmlDescription(dep));
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                LinkedHashSet<Action> result = new LinkedHashSet<Action>();
                result.add(LibrariesChildren.OPEN_PROJECT_ACTION);
                result.add(new EditDependencyAction(this.dep, this.project));
                result.add(new ShowJavadocAction(this.dep, this.project));
                result.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = result.toArray(new Action[result.size()]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    private static final class LibrariesChildren
    extends Children.Keys
    implements AntProjectListener {
        private static final String JDK_PLATFORM_NAME = "jdkPlatform";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";
        static final Action OPEN_PROJECT_ACTION;
        static final Action REMOVE_DEPENDENCY_ACTION;
        private final NbModuleProject project;
        private ImageIcon librariesIcon;
        static final /* synthetic */ boolean $assertionsDisabled;

        LibrariesChildren(NbModuleProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
            super.removeNotify();
        }

        private void refreshKeys() {
            RequestProcessor.getDefault().post(new Runnable(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void run() {
                    block2: {
                        try {
                            ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){

                                public Object run() throws Exception {
                                    ProjectXMLManager pxm = new ProjectXMLManager(LibrariesChildren.this.project);
                                    ArrayList<String> keys = new ArrayList<String>();
                                    keys.add(LibrariesChildren.JDK_PLATFORM_NAME);
                                    TreeSet deps = new TreeSet(ModuleDependency.LOCALIZED_NAME_COMPARATOR);
                                    deps.addAll(pxm.getDirectDependencies());
                                    keys.addAll(deps);
                                    LibrariesChildren.this.setKeys(Collections.unmodifiableList(keys));
                                    return null;
                                }
                            });
                        }
                        catch (MutexException e) {
                            if ($assertionsDisabled) break block2;
                            throw new AssertionError((Object)e.getException());
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$LibrariesNode == null ? (class$org$netbeans$modules$apisupport$project$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.LibrariesNode")) : class$org$netbeans$modules$apisupport$project$ui$LibrariesNode).desiredAssertionStatus();
                }
            });
        }

        protected Node[] createNodes(Object key) {
            Object node;
            if (key == JDK_PLATFORM_NAME) {
                node = PlatformNode.create(this.project.evaluator(), "nbjdk.home");
            } else {
                ModuleDependency dep = (ModuleDependency)key;
                File srcF = dep.getModuleEntry().getSourceLocation();
                if (srcF == null) {
                    File jarF = dep.getModuleEntry().getJarLocation();
                    URL jarRootURL = Util.urlForJar(jarF);
                    if (!$assertionsDisabled && jarRootURL == null) {
                        throw new AssertionError();
                    }
                    FileObject root = URLMapper.findFileObject((URL)jarRootURL);
                    ModuleEntry me = dep.getModuleEntry();
                    String name = me.getLocalizedName() + " - " + me.getCodeNameBase();
                    Icon icon = this.getLibrariesIcon();
                    ActionFilterNode pvNode = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(root, name, icon, icon)));
                    node = new LibraryDependencyNode(dep, this.project, (Node)pvNode);
                } else {
                    node = new ProjectDependencyNode(dep, this.project);
                }
            }
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            return new Node[]{node};
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (this.project.getHelper().resolveFileObject("nbproject/project.xml") != null) {
                this.refreshKeys();
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        private Icon getLibrariesIcon() {
            if (this.librariesIcon == null) {
                this.librariesIcon = new ImageIcon(Utilities.loadImage((String)LIBRARIES_ICON, (boolean)true));
            }
            return this.librariesIcon;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$LibrariesNode == null ? (class$org$netbeans$modules$apisupport$project$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.apisupport.project.ui.LibrariesNode")) : class$org$netbeans$modules$apisupport$project$ui$LibrariesNode).desiredAssertionStatus();
            OPEN_PROJECT_ACTION = new OpenProjectAction();
            REMOVE_DEPENDENCY_ACTION = new RemoveDependencyAction();
        }
    }
}

