/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;

final class SuiteSubprojectProviderImpl
implements SubprojectProvider {
    private Set projects;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final Set listeners = new HashSet();
    private boolean reloadNeeded;

    public SuiteSubprojectProviderImpl(AntProjectHelper helper, PropertyEvaluator eval) {
        this.helper = helper;
        this.eval = eval;
        eval.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("modules".equals(evt.getPropertyName())) {
                    SuiteSubprojectProviderImpl.this.reloadNeeded = true;
                    SuiteSubprojectProviderImpl.this.fireChange();
                }
            }
        });
    }

    public Set getSubprojects() {
        if (this.projects == null || this.reloadNeeded) {
            this.projects = this.loadProjects();
            this.reloadNeeded = false;
        }
        return this.projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        Iterator it;
        ChangeEvent e = new ChangeEvent(this);
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            it = new HashSet(this.listeners).iterator();
        }
        while (it.hasNext()) {
            ChangeListener l = (ChangeListener)it.next();
            l.stateChanged(e);
        }
    }

    private Set loadProjects() {
        HashSet<Project> newProjects = new HashSet<Project>();
        String modules = this.eval.getProperty("modules");
        if (modules != null) {
            String[] pieces = PropertyUtils.tokenizePath((String)modules);
            for (int i = 0; i < pieces.length; ++i) {
                FileObject dir = this.helper.resolveFileObject(pieces[i]);
                if (dir == null) continue;
                try {
                    Project subp = ProjectManager.getDefault().findProject(dir);
                    if (subp == null) continue;
                    newProjects.add(subp);
                    continue;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
        }
        return Collections.unmodifiableSet(newProjects);
    }
}

