/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

public class SimpleFileOwnerQueryImplementation
implements FileOwnerQueryImplementation {
    private final Set warnedAboutBrokenProjects = new WeakSet();
    private static final Map externalOwners;
    private static final Map project2External;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Project getOwner(URI fileURI) {
        FileObject file;
        URI test = fileURI;
        do {
            file = SimpleFileOwnerQueryImplementation.uri2FileObject(test);
            test = SimpleFileOwnerQueryImplementation.goUp(test);
        } while (file == null && test != null);
        if (file == null) {
            return null;
        }
        return this.getOwner(file);
    }

    public Project getOwner(FileObject f) {
        while (f != null) {
            FileObject externalOwner;
            WeakReference externalOwnersReference;
            if (f.isFolder()) {
                Project p;
                try {
                    p = ProjectManager.getDefault().findProject(f);
                }
                catch (IOException e) {
                    if (this.warnedAboutBrokenProjects.add(f)) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    return null;
                }
                if (p != null) {
                    return p;
                }
            }
            if (!externalOwners.isEmpty() && (externalOwnersReference = (WeakReference)externalOwners.get(SimpleFileOwnerQueryImplementation.fileObject2URI(f))) != null && (externalOwner = (FileObject)externalOwnersReference.get()) != null) {
                try {
                    return ProjectManager.getDefault().findProject(externalOwner);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    return null;
                }
            }
            f = f.getParent();
        }
        return null;
    }

    public static void reset() {
        externalOwners.clear();
    }

    private static URI fileObject2URI(FileObject f) {
        try {
            return URI.create(f.getURL().toString());
        }
        catch (FileStateInvalidException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            ErrorManager.getDefault().annotate((Throwable)iae, (Throwable)e);
            throw iae;
        }
    }

    public static void markExternalOwnerTransient(FileObject root, Project owner) {
        SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(SimpleFileOwnerQueryImplementation.fileObject2URI(root), owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markExternalOwnerTransient(URI root, Project owner) {
        FileObject ownerFO;
        if (owner != null) {
            externalOwners.put(root, new WeakReference<FileObject>(owner.getProjectDirectory()));
            Map map = project2External;
            synchronized (map) {
                FileObject prjDir = owner.getProjectDirectory();
                LinkedList<URI> roots = (LinkedList<URI>)project2External.get(prjDir);
                if (roots == null) {
                    roots = new LinkedList<URI>();
                    project2External.put(prjDir, roots);
                }
                roots.add(root);
            }
        }
        WeakReference ownerReference = (WeakReference)externalOwners.remove(root);
        if (ownerReference != null && (ownerFO = (FileObject)ownerReference.get()) != null) {
            Map map = project2External;
            synchronized (map) {
                Collection roots = (Collection)project2External.get(ownerFO);
                if (roots != null) {
                    roots.remove(root);
                    if (roots.size() == 0) {
                        project2External.remove(ownerFO);
                    }
                }
            }
        }
    }

    private static FileObject uri2FileObject(URI u) {
        URL url;
        try {
            url = u.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError(u);
            }
            return null;
        }
        return URLMapper.findFileObject((URL)url);
    }

    private static URI goUp(URI u) {
        String pth;
        URI nue;
        if (!$assertionsDisabled && !u.isAbsolute()) {
            throw new AssertionError(u);
        }
        if (!$assertionsDisabled && u.getFragment() != null) {
            throw new AssertionError(u);
        }
        if (!$assertionsDisabled && u.getQuery() != null) {
            throw new AssertionError(u);
        }
        String path = u.getPath();
        if (path == null || path.equals("/")) {
            return null;
        }
        String us = u.toString();
        if (us.endsWith("/")) {
            us = us.substring(0, us.length() - 1);
            if (!$assertionsDisabled && !path.endsWith("/")) {
                throw new AssertionError();
            }
            path = path.substring(0, path.length() - 1);
        }
        int idx = us.lastIndexOf(47);
        if (!$assertionsDisabled && idx == -1) {
            throw new AssertionError((Object)path);
        }
        us = path.lastIndexOf(47) == 0 ? us.substring(0, idx + 1) : us.substring(0, idx);
        try {
            nue = new URI(us);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (Utilities.isWindows() && ((pth = nue.getPath()).length() == 3 && pth.endsWith(":") || pth.length() == 1 && pth.endsWith("/"))) {
            return null;
        }
        if (!$assertionsDisabled && !nue.isAbsolute()) {
            throw new AssertionError(nue);
        }
        if (!$assertionsDisabled && !u.toString().startsWith(nue.toString())) {
            throw new AssertionError((Object)("not a parent: " + nue + " of " + u));
        }
        return nue;
    }

    static {
        $assertionsDisabled = !SimpleFileOwnerQueryImplementation.class.desiredAssertionStatus();
        externalOwners = Collections.synchronizedMap(new WeakHashMap());
        project2External = Collections.synchronizedMap(new WeakHashMap());
    }
}

