/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.parser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.tax.parser.ParserLoader;
import org.netbeans.modules.xml.tax.parser.Util;
import org.netbeans.tax.io.TreeBuilder;
import org.netbeans.tax.io.TreeInputSource;
import org.netbeans.tax.io.TreeStreamBuilderErrorHandler;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TreeStreamSource
implements TreeInputSource {
    private static final String BUILDER_IMPL = "org.netbeans.tax.io.XNIBuilder";
    private InputSource inputSource;
    private Class buildClass;
    private ErrorHolder errorHolder;

    public TreeStreamSource(Class buildClass, InputSource inputSource, URL url) {
        this.buildClass = buildClass;
        this.inputSource = inputSource;
        this.errorHolder = new ErrorHolder();
    }

    public TreeBuilder getBuilder() {
        return this.getImplementation();
    }

    private TreeBuilder getImplementation() {
        ClassLoader loader;
        if (Boolean.getBoolean("netbeans.tax.use_private_xni_impl")) {
            loader = ParserLoader.getInstance();
            if (loader == null) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Can not get loader.");
                }
                return null;
            }
        } else {
            loader = TreeBuilder.class.getClassLoader();
        }
        Class<?> impl_c = null;
        try {
            impl_c = loader.loadClass(BUILDER_IMPL);
        }
        catch (ClassNotFoundException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!! TreeStreamSource.getImplementation", ex);
            }
            return null;
        }
        try {
            Constructor<?> impl_const = impl_c.getConstructor(Class.class, InputSource.class, EntityResolver.class, TreeStreamBuilderErrorHandler.class);
            return (TreeBuilder)impl_const.newInstance(this.buildClass, this.inputSource, this.getSystemEntityResolver(), this.errorHolder);
        }
        catch (InvocationTargetException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(ex);
            }
            return null;
        }
        catch (NoSuchMethodException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(ex);
            }
            return null;
        }
        catch (InstantiationException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(ex);
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(ex);
            }
            return null;
        }
    }

    private EntityResolver getSystemEntityResolver() {
        EntityResolver resolver;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeStreamSource.getSystemEntityResolver:");
        }
        UserCatalog catalog = UserCatalog.getDefault();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    UserCatalog.getDefault() = " + catalog);
        }
        EntityResolver entityResolver = resolver = catalog == null ? null : catalog.getEntityResolver();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    EntityResolver = " + resolver);
        }
        if (resolver == null) {
            return null;
        }
        resolver = new EntityResolverWrapper(resolver);
        return resolver;
    }

    static class EntityResolverWrapper
    implements EntityResolver {
        private final EntityResolver res;

        public EntityResolverWrapper(EntityResolver er) {
            if (er == null) {
                throw new NullPointerException();
            }
            this.res = er;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException, IOException {
            this.res.resolveEntity(null, "urn:nowhere");
            ErrorManager emgr = ErrorManager.getDefault();
            final InputSource MARK = new InputSource("mark");
            try {
                final InputSource[] result = new InputSource[]{MARK};
                final SAXException[] sex = new SAXException[1];
                final IOException[] ioex = new IOException[1];
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        InputSource is = MARK;
                        try {
                            is = EntityResolverWrapper.this.res.resolveEntity(publicId, systemId);
                        }
                        catch (IOException _ioex) {
                            ioex[0] = _ioex;
                        }
                        catch (SAXException _sex) {
                            sex[0] = _sex;
                        }
                        finally {
                            EntityResolverWrapper _ioex = EntityResolverWrapper.this;
                            synchronized (_ioex) {
                                if (is != MARK) {
                                    result[0] = is;
                                }
                                EntityResolverWrapper.this.notify();
                            }
                        }
                    }
                };
                Thread thread = new Thread(task, "Timeouted EntityResolver");
                thread.setDaemon(true);
                thread.start();
                Object object = this;
                synchronized (object) {
                    if (result[0] == MARK) {
                        this.wait(300L);
                    }
                }
                if (result[0] == MARK) {
                    StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("MSG_resolving"));
                    object = this;
                    synchronized (object) {
                        int timeout = Integer.getInteger("netbeans.xml.resolver.timeout", 5000);
                        if (result[0] == MARK) {
                            this.wait(timeout);
                        }
                    }
                }
                if (result[0] != MARK) {
                    object = result[0];
                    return object;
                }
                try {
                    if (sex[0] != null) {
                        throw sex[0];
                    }
                    if (ioex[0] != null) {
                        throw ioex[0];
                    }
                    thread.interrupt();
                    thread.setPriority(1);
                    thread.setName("Zombie");
                    IOException CANNOT_CONNECT = new IOException("Resolution timeout \"" + systemId + "\" (" + publicId + ")");
                    String pattern = Util.THIS.getString("MSG_cannot_connect");
                    Object[] params = new String[]{publicId, systemId};
                    String annotation = MessageFormat.format(pattern, params);
                    emgr.annotate((Throwable)CANNOT_CONNECT, annotation);
                    throw CANNOT_CONNECT;
                }
                catch (InterruptedException iex) {
                    IOException INTERRUPTED = new IOException("Resolution interrupted \"" + systemId + "\" (" + publicId + ")");
                    String pattern = Util.THIS.getString("MSG_interrupted");
                    Object[] params = new String[]{publicId, systemId};
                    String annotation = MessageFormat.format(pattern, params);
                    emgr.annotate((Throwable)INTERRUPTED, annotation);
                    throw INTERRUPTED;
                }
            }
            finally {
                StatusDisplayer.getDefault().setStatusText("");
            }
        }

        public String toString() {
            return super.toString() + Util.THIS.getString("PROP_wrapping") + this.res.toString();
        }
    }

    static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }
    }

    private class ErrorHolder
    implements TreeStreamBuilderErrorHandler {
        private ErrorHolder() {
        }

        public void message(int type, SAXParseException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Builder ex", e);
            }
        }
    }
}

