/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.netbeans.modules.xml.retriever.ResourceRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceRetriever
implements ResourceRetriever {
    long streamLength = 0L;

    @Override
    public boolean accept(String baseAddr, String currentAddr) throws URISyntaxException {
        URI baseURI;
        URI currURI = new URI(currentAddr);
        if (currURI.isAbsolute() && currURI.getScheme().equalsIgnoreCase("file")) {
            return true;
        }
        if (!currURI.isAbsolute() && baseAddr == null) {
            return true;
        }
        return baseAddr != null && !currURI.isAbsolute() && (baseURI = new URI(baseAddr)).getScheme().equalsIgnoreCase("file");
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        URI currURI = new URI(this.getEffectiveAddress(baseAddress, documentAddress));
        HashMap<String, InputStream> result = null;
        File curFile = new File(currURI);
        if (curFile.isFile()) {
            FileInputStream is = new FileInputStream(curFile);
            result = new HashMap<String, InputStream>();
            result.put(curFile.toURI().toString(), is);
            this.streamLength = curFile.length();
            return result;
        }
        throw new IOException("File not found: " + curFile.toString());
    }

    @Override
    public long getStreamLength() {
        return this.streamLength;
    }

    @Override
    public String getEffectiveAddress(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        URI currURI = new URI(documentAddress);
        if (currURI.isAbsolute()) {
            return currURI.toString();
        }
        if (baseAddress != null) {
            URI baseURI = new URI(baseAddress);
            return baseURI.resolve(currURI).toString();
        }
        return null;
    }
}

