/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.MimeLookupInitializerImpl;
import org.netbeans.modules.editor.settings.storage.SimpleAttributeSet;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.ErrorManager;

public class FontColorSettingsImpl
extends FontColorSettingsFactory
implements MimeLookupInitializerImpl.Factory {
    private String[] mimeTypes;
    private String mimeType;
    private PropertyChangeSupport pcs;
    private String test;
    private ErrorManager logger;
    private static final String DEFAULT = "default";
    private EditorSettingsImpl editorSettingsImpl;
    private Map colorings = new HashMap();
    private Map defaults = new HashMap();
    private static Font defaultSystemFont;

    FontColorSettingsImpl(String[] mimeTypes) {
        if (mimeTypes.length > 0 && mimeTypes[0].startsWith("test")) {
            String[] newMT = new String[mimeTypes.length];
            System.arraycopy(mimeTypes, 0, newMT, 0, newMT.length);
            int i = mimeTypes[0].indexOf(95);
            this.test = newMT[0].substring(0, i);
            newMT[0] = newMT[0].substring(i + 1);
            this.mimeTypes = newMT;
        } else {
            this.mimeTypes = mimeTypes;
        }
        this.mimeType = this.getMimeType();
        this.logger = ErrorManager.getDefault().getInstance(FontColorSettingsImpl.class.getName() + '.' + (this.test == null ? this.mimeType : this.test + "_" + this.mimeType));
        this.pcs = new PropertyChangeSupport(this);
        new Listener(this);
    }

    public AttributeSet getFontColors(String settingName) {
        if (settingName.equals(DEFAULT)) {
            return this.getTokenFontColors(settingName);
        }
        String profile = this.test != null ? this.test : this.getEditorColoringImpl().getCurrentFontColorProfile();
        AttributeSet as = (AttributeSet)this.getEditorColoringImpl().getHighlightings(profile).get(settingName);
        if (as == null) {
            this.logger.log("highlighting2 " + settingName + " : null");
            return null;
        }
        SimpleAttributeSet result = this.resolveDefaults(as, profile);
        this.logger.log("highlighting3 " + settingName + " : " + result);
        return result;
    }

    public AttributeSet getTokenFontColors(String tokenName) {
        String profile = null;
        String profileOriginal = null;
        if (this.test != null) {
            profileOriginal = profile = this.test;
        } else {
            profile = this.getEditorColoringImpl().getCurrentFontColorProfile();
            profileOriginal = this.getEditorColoringImpl().getInternalFontColorProfile(profile);
        }
        Map m = this.getColorings(profileOriginal);
        if (m == null) {
            this.logger.log("syntax1 " + tokenName + " : null");
            return null;
        }
        AttributeSet as = (AttributeSet)m.get(tokenName);
        if (as == null) {
            if (tokenName.equals(DEFAULT)) {
                as = new SimpleAttributeSet();
                ((SimpleAttributeSet)as).addAttribute(EditorStyleConstants.Default, DEFAULT);
            } else {
                this.logger.log("syntax2 " + tokenName + " : null");
                return null;
            }
        }
        SimpleAttributeSet result = this.resolveDefaults(as, profile);
        if (tokenName.equals(DEFAULT)) {
            if (result.getAttribute(StyleConstants.Foreground) == null) {
                result.addAttribute(StyleConstants.Foreground, Color.black);
            }
            if (result.getAttribute(StyleConstants.Background) == null) {
                result.addAttribute(StyleConstants.Background, Color.white);
            }
            if (result.getAttribute(StyleConstants.FontFamily) == null) {
                result.addAttribute(StyleConstants.FontFamily, FontColorSettingsImpl.getDefaultSystemFont().getName());
            }
            if (result.getAttribute(StyleConstants.FontSize) == null) {
                result.addAttribute(StyleConstants.FontSize, new Integer(FontColorSettingsImpl.getDefaultSystemFont().getSize()));
            }
            this.logger.log("syntax3 " + tokenName + " : " + result);
            return result;
        }
        if (!result.isDefined(StyleConstants.FontFamily) && (result.isDefined(StyleConstants.FontSize) || result.isDefined(StyleConstants.Bold) || result.isDefined(StyleConstants.Italic))) {
            AttributeSet defaultCategory = this.getTokenFontColors(DEFAULT);
            result.addAttribute(StyleConstants.FontFamily, defaultCategory.getAttribute(StyleConstants.FontFamily));
            if (!result.isDefined(StyleConstants.FontSize)) {
                result.addAttribute(StyleConstants.FontSize, defaultCategory.getAttribute(StyleConstants.FontSize));
            }
        }
        this.logger.log("syntax4 " + tokenName + " : " + result);
        return result;
    }

    public Collection getAllFontColors(String profile) {
        profile = this.test != null ? this.test : this.getEditorColoringImpl().getInternalFontColorProfile(profile);
        Map m = this.getColorings(profile);
        if (m == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(m.values());
    }

    public Collection getAllFontColorDefaults(String profile) {
        profile = this.test != null ? this.test : this.getEditorColoringImpl().getInternalFontColorProfile(profile);
        Map m = this.getDefaults(profile);
        if (m == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(m.values());
    }

    public void setAllFontColors(String profile, Collection fontColors) {
        Map m;
        this.logger.log("set " + profile);
        String string = profile = this.test != null ? this.test : this.getEditorColoringImpl().getInternalFontColorProfile(profile);
        if (fontColors == null) {
            ColoringStorage.deleteColorings(this.mimeTypes, profile, "coloring.xml");
            this.colorings.remove(profile);
            this.pcs.firePropertyChange("fontColors", null, null);
            return;
        }
        if (this.test == null) {
            ColoringStorage.saveColorings(this.mimeTypes, profile, "coloring.xml", fontColors);
        }
        if ((m = this.getColorings(profile)) == null) {
            return;
        }
        Iterator it = fontColors.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            AttributeSet as = (AttributeSet)it.next();
            String name = (String)as.getAttribute(StyleConstants.NameAttribute);
            if (!changed && !as.equals(m.get(name))) {
                changed = true;
            }
            m.put(name, as);
            this.logger.log("set " + name + " : " + as);
        }
        if (changed) {
            this.pcs.firePropertyChange("fontColors", null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private EditorSettingsImpl getEditorColoringImpl() {
        if (this.editorSettingsImpl == null) {
            this.editorSettingsImpl = (EditorSettingsImpl)EditorSettings.getDefault();
        }
        return this.editorSettingsImpl;
    }

    private Map getColorings(String profile) {
        if (!this.colorings.containsKey(profile)) {
            Map m = ColoringStorage.loadColorings(this.mimeTypes, this.test != null ? "NetBeans" : profile, "coloring.xml", false);
            if (m == null) {
                m = ColoringStorage.loadColorings(this.mimeTypes, "NetBeans", "coloring.xml", false);
            }
            this.colorings.put(profile, m);
        }
        return (Map)this.colorings.get(profile);
    }

    private Map getDefaults(String profile) {
        if (!this.defaults.containsKey(profile)) {
            Map m = ColoringStorage.loadColorings(this.mimeTypes, profile, "coloring.xml", true);
            this.defaults.put(profile, m);
        }
        return (Map)this.defaults.get(profile);
    }

    private String getMimeType() {
        int k = this.mimeTypes.length;
        if (k == 0) {
            return "";
        }
        if (k == 1) {
            return this.mimeTypes[0];
        }
        StringBuffer result = new StringBuffer(this.mimeTypes[0]);
        for (int i = 1; i < k; ++i) {
            result.append('+').append(this.mimeTypes[i]);
        }
        return result.toString();
    }

    private SimpleAttributeSet resolveDefaults(AttributeSet as, String profile) {
        SimpleAttributeSet sas = new SimpleAttributeSet(as);
        this.resolveDefaults(sas, sas, StyleConstants.Background, profile);
        this.resolveDefaults(sas, sas, StyleConstants.Foreground, profile);
        this.resolveDefaults(sas, sas, StyleConstants.Underline, profile);
        this.resolveDefaults(sas, sas, StyleConstants.StrikeThrough, profile);
        this.resolveDefaults(sas, sas, EditorStyleConstants.WaveUnderlineColor, profile);
        this.resolveDefaults(sas, sas, StyleConstants.Bold, profile);
        this.resolveDefaults(sas, sas, StyleConstants.Italic, profile);
        this.resolveDefaults(sas, sas, StyleConstants.FontFamily, profile);
        this.resolveDefaults(sas, sas, StyleConstants.FontSize, profile);
        return sas;
    }

    private void resolveDefaults(SimpleAttributeSet originalAS, AttributeSet currentAS, Object name, String profile) {
        Collection defaults;
        Object value = currentAS.getAttribute(name);
        if (value != null) {
            originalAS.addAttribute(name, value);
            return;
        }
        String defaultCategory = (String)currentAS.getAttribute(EditorStyleConstants.Default);
        if (defaultCategory == null) {
            return;
        }
        if (!defaultCategory.equals(currentAS.getAttribute(StyleConstants.NameAttribute))) {
            Iterator it = this.getAllFontColors(profile).iterator();
            while (it.hasNext()) {
                AttributeSet as1 = (AttributeSet)it.next();
                if (!defaultCategory.equals(as1.getAttribute(StyleConstants.NameAttribute))) continue;
                this.resolveDefaults(originalAS, as1, name, profile);
            }
        }
        if ((defaults = this.getEditorColoringImpl().getDefaultFontColors(this.test == null ? profile : this.test)) == null) {
            return;
        }
        Iterator it = defaults.iterator();
        while (it.hasNext()) {
            AttributeSet as1 = (AttributeSet)it.next();
            if (!defaultCategory.equals(as1.getAttribute(StyleConstants.NameAttribute))) continue;
            this.resolveDefaults(originalAS, as1, name, profile);
        }
    }

    private static Font getDefaultSystemFont() {
        if (defaultSystemFont == null) {
            int size;
            Integer defaultFontSize = (Integer)UIManager.get("customFontSize");
            int n = size = defaultFontSize != null ? defaultFontSize.intValue() : UIManager.getFont("TextField.font").getSize();
            if (size < 12) {
                size = 12;
            }
            defaultSystemFont = new Font("Monospaced", 0, size);
        }
        return defaultSystemFont;
    }

    public Object createInstance() {
        ArrayList allFC;
        ArrayList defFC;
        String profile = this.test != null ? this.test : this.getEditorColoringImpl().getCurrentFontColorProfile();
        String profileOriginal = null;
        profileOriginal = this.test != null ? (profile = this.test) : this.getEditorColoringImpl().getInternalFontColorProfile(profile);
        Map highlightings = this.getEditorColoringImpl().getHighlightings(profile);
        highlightings = highlightings != null ? new HashMap(highlightings) : Collections.EMPTY_MAP;
        HashMap colorings = this.getColorings(profileOriginal);
        if (colorings != null) {
            colorings = new HashMap(colorings);
        }
        if ((defFC = this.getEditorColoringImpl().getDefaultFontColors(profile)) != null) {
            defFC = new ArrayList(defFC);
        }
        if ((allFC = this.getAllFontColors(profile)) != null) {
            allFC = new ArrayList(allFC);
        }
        return new Immutable(this.logger, this.test, profile, highlightings, colorings, defFC, allFC);
    }

    private static final class Immutable
    extends FontColorSettings {
        private final ErrorManager logger;
        private final String test;
        private final String profile;
        private final Map highlightings;
        private final Map colorings;
        private final Collection defFC;
        private final Collection allFC;

        public Immutable(ErrorManager logger, String test, String profile, Map highlightings, Map colorings, Collection defFC, Collection allFC) {
            this.logger = logger;
            this.test = test;
            this.profile = profile;
            this.highlightings = highlightings;
            this.colorings = colorings;
            this.defFC = defFC;
            this.allFC = allFC;
        }

        public AttributeSet getFontColors(String settingName) {
            if (settingName.equals(FontColorSettingsImpl.DEFAULT)) {
                return this.getTokenFontColors(settingName);
            }
            AttributeSet as = (AttributeSet)this.highlightings.get(settingName);
            if (as == null) {
                this.logger.log("highlighting2 " + settingName + " : null");
                return null;
            }
            SimpleAttributeSet result = this.resolveDefaults(as, this.profile);
            this.logger.log("highlighting3 " + settingName + " : " + result);
            return result;
        }

        public AttributeSet getTokenFontColors(String tokenName) {
            Map m = this.colorings;
            if (m == null) {
                this.logger.log("syntax1 " + tokenName + " : null");
                return null;
            }
            AttributeSet as = (AttributeSet)m.get(tokenName);
            if (as == null) {
                if (tokenName.equals(FontColorSettingsImpl.DEFAULT)) {
                    as = new SimpleAttributeSet();
                    ((SimpleAttributeSet)as).addAttribute(EditorStyleConstants.Default, FontColorSettingsImpl.DEFAULT);
                } else {
                    this.logger.log("syntax2 " + tokenName + " : null");
                    return null;
                }
            }
            SimpleAttributeSet result = this.resolveDefaults(as, this.profile);
            if (tokenName.equals(FontColorSettingsImpl.DEFAULT)) {
                if (result.getAttribute(StyleConstants.Foreground) == null) {
                    result.addAttribute(StyleConstants.Foreground, Color.black);
                }
                if (result.getAttribute(StyleConstants.Background) == null) {
                    result.addAttribute(StyleConstants.Background, Color.white);
                }
                if (result.getAttribute(StyleConstants.FontFamily) == null) {
                    result.addAttribute(StyleConstants.FontFamily, FontColorSettingsImpl.getDefaultSystemFont().getName());
                }
                if (result.getAttribute(StyleConstants.FontSize) == null) {
                    result.addAttribute(StyleConstants.FontSize, new Integer(FontColorSettingsImpl.getDefaultSystemFont().getSize()));
                }
                this.logger.log("syntax3 " + tokenName + " : " + result);
                return result;
            }
            if (!result.isDefined(StyleConstants.FontFamily) && (result.isDefined(StyleConstants.FontSize) || result.isDefined(StyleConstants.Bold) || result.isDefined(StyleConstants.Italic))) {
                AttributeSet defaultCategory = this.getTokenFontColors(FontColorSettingsImpl.DEFAULT);
                result.addAttribute(StyleConstants.FontFamily, defaultCategory.getAttribute(StyleConstants.FontFamily));
                if (!result.isDefined(StyleConstants.FontSize)) {
                    result.addAttribute(StyleConstants.FontSize, defaultCategory.getAttribute(StyleConstants.FontSize));
                }
            }
            this.logger.log("syntax4 " + tokenName + " : " + result);
            return result;
        }

        private SimpleAttributeSet resolveDefaults(AttributeSet as, String profile) {
            SimpleAttributeSet sas = new SimpleAttributeSet(as);
            this.resolveDefaults(sas, sas, StyleConstants.Background, profile);
            this.resolveDefaults(sas, sas, StyleConstants.Foreground, profile);
            this.resolveDefaults(sas, sas, StyleConstants.Underline, profile);
            this.resolveDefaults(sas, sas, StyleConstants.StrikeThrough, profile);
            this.resolveDefaults(sas, sas, EditorStyleConstants.WaveUnderlineColor, profile);
            this.resolveDefaults(sas, sas, StyleConstants.Bold, profile);
            this.resolveDefaults(sas, sas, StyleConstants.Italic, profile);
            this.resolveDefaults(sas, sas, StyleConstants.FontFamily, profile);
            this.resolveDefaults(sas, sas, StyleConstants.FontSize, profile);
            return sas;
        }

        private void resolveDefaults(SimpleAttributeSet originalAS, AttributeSet currentAS, Object name, String profile) {
            Collection defaults;
            Object value = currentAS.getAttribute(name);
            if (value != null) {
                originalAS.addAttribute(name, value);
                return;
            }
            String defaultCategory = (String)currentAS.getAttribute(EditorStyleConstants.Default);
            if (defaultCategory == null) {
                return;
            }
            if (!defaultCategory.equals(currentAS.getAttribute(StyleConstants.NameAttribute))) {
                Iterator it = this.allFC.iterator();
                while (it.hasNext()) {
                    AttributeSet as1 = (AttributeSet)it.next();
                    if (!defaultCategory.equals(as1.getAttribute(StyleConstants.NameAttribute))) continue;
                    this.resolveDefaults(originalAS, as1, name, profile);
                }
            }
            if ((defaults = this.defFC) == null) {
                return;
            }
            Iterator it = defaults.iterator();
            while (it.hasNext()) {
                AttributeSet as1 = (AttributeSet)it.next();
                if (!defaultCategory.equals(as1.getAttribute(StyleConstants.NameAttribute))) continue;
                this.resolveDefaults(originalAS, as1, name, profile);
            }
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference fontColorSettings;
        private EditorSettingsImpl editorSettings;
        private String test;

        Listener(FontColorSettingsImpl fontColorSettings) {
            this.fontColorSettings = new WeakReference<FontColorSettingsImpl>(fontColorSettings);
            this.editorSettings = fontColorSettings.getEditorColoringImpl();
            this.editorSettings.addPropertyChangeListener("currentFontColorProfile", this);
            this.test = fontColorSettings.test;
            if (this.test != null) {
                this.editorSettings.addPropertyChangeListener(this.test, this);
            } else {
                this.editorSettings.addPropertyChangeListener("defaultFontColors", this);
                this.editorSettings.addPropertyChangeListener("editorFontColors", this);
            }
        }

        private FontColorSettingsImpl getFontColorSettings() {
            FontColorSettingsImpl r = (FontColorSettingsImpl)this.fontColorSettings.get();
            if (r != null) {
                return r;
            }
            this.editorSettings.removePropertyChangeListener("currentFontColorProfile", this);
            if (this.test != null) {
                this.editorSettings.removePropertyChangeListener(this.test, this);
            } else {
                this.editorSettings.removePropertyChangeListener("defaultFontColors", this);
                this.editorSettings.removePropertyChangeListener("editorFontColors", this);
            }
            return null;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FontColorSettingsImpl fontColorSettings = this.getFontColorSettings();
            fontColorSettings.pcs.firePropertyChange("fontColors", null, null);
        }
    }
}

