/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.util.Iterator;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;

public final class Statistics {
    public static final TimeConsumer REFRESH_FOLDER = new TimeConsumer("Folder refresh");
    public static final TimeConsumer REFRESH_FILE = new TimeConsumer("File refresh");
    public static final TimeConsumer REFRESH_FS = new TimeConsumer("FileSystem refresh");
    public static final TimeConsumer LISTENERS_CALLS = new TimeConsumer("Invocation of FileChangeListeners");
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$filebasedfs$Statistics;

    private Statistics() {
    }

    public static StopWatch getStopWatch(TimeConsumer consumer) {
        return new StopWatch(consumer);
    }

    public static int fileSystems() {
        return FileBasedFileSystem.getSize();
    }

    public static int fileNamings() {
        return NamingFactory.getSize();
    }

    public static int fileObjects() {
        int retVal = 0;
        Iterator it = FileBasedFileSystem.getInstances().iterator();
        int i = 0;
        while (it.hasNext()) {
            FileBasedFileSystem fbs = (FileBasedFileSystem)((Object)it.next());
            retVal += Statistics.fileObjectsPerFileSystem(fbs);
            ++i;
        }
        return retVal;
    }

    public static int fileObjectsPerFileSystem(FileBasedFileSystem fbs) {
        return fbs.getFactory().getSize();
    }

    public static final class StopWatch {
        private long startTime = 0L;
        private final TimeConsumer activity;
        static final /* synthetic */ boolean $assertionsDisabled;

        private StopWatch(TimeConsumer activity) {
            this.activity = activity;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            if (!$assertionsDisabled && this.startTime == 0L) {
                throw new AssertionError();
            }
            this.activity.elapsedTime = (int)((long)this.activity.elapsedTime + (System.currentTimeMillis() - this.startTime));
            this.activity.incrementNumerOfCalls();
            this.startTime = 0L;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$Statistics == null ? (class$org$netbeans$modules$masterfs$filebasedfs$Statistics = Statistics.class$("org.netbeans.modules.masterfs.filebasedfs.Statistics")) : class$org$netbeans$modules$masterfs$filebasedfs$Statistics).desiredAssertionStatus();
        }
    }

    public static final class TimeConsumer {
        private int elapsedTime;
        private int numberOfCalls;
        private final String description;

        private TimeConsumer(String description) {
            this.description = description;
        }

        public int getConsumedTime() {
            return this.elapsedTime;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public void reset() {
            this.elapsedTime = 0;
            this.numberOfCalls = 0;
        }

        public String toString() {
            return this.description + ": " + this.numberOfCalls + " calls in " + this.elapsedTime + "ms";
        }

        private void incrementNumerOfCalls() {
            ++this.numberOfCalls;
        }
    }
}

