/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.Delegate;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.ResourcePath;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

final class Cache {
    private Map res2DfoMap;
    private static Cache instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cache getDefault() {
        Class clazz = Cache.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new Cache();
                Cache.instance.res2DfoMap = Collections.synchronizedMap(new WeakHashMap());
            }
        }
        return instance;
    }

    private Cache() {
    }

    MasterFileObject get(ResourcePath resPath) {
        MasterFileObject retVal = this.getValidOrInvalid(resPath);
        if (retVal != null) {
            retVal = retVal.isValid() ? retVal : null;
        }
        return retVal;
    }

    MasterFileObject getValidOrInvalid(ResourcePath resPath) {
        Reference ref = (Reference)this.res2DfoMap.get(resPath.getNormalizedPath());
        MasterFileObject retVal = null;
        if (ref != null) {
            retVal = (MasterFileObject)((Object)ref.get());
        }
        return retVal;
    }

    MasterFileObject getOrCreate(ResourcePath resPath) {
        MasterFileObject retVal = this.get(resPath);
        if (retVal != null) {
            return retVal;
        }
        FileObject delegate = Delegate.resolve(resPath);
        return delegate == null ? null : this.getOrCreate(resPath, delegate);
    }

    MasterFileObject getOrCreate(ResourcePath resPath, FileObject delegate) {
        boolean isRetValValid;
        MasterFileObject retVal = this.getValidOrInvalid(resPath);
        boolean bl = isRetValValid = retVal == null || retVal.isValid();
        if (retVal != null && isRetValValid) {
            return retVal;
        }
        MasterFileObject nRetVal = new MasterFileObject(resPath, delegate);
        if (nRetVal.isValid()) {
            retVal = nRetVal;
            this.put(retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getAll() {
        ArrayList<MasterFileObject> arrayList = new ArrayList<MasterFileObject>();
        Map map = this.res2DfoMap;
        synchronized (map) {
            Iterator it = this.res2DfoMap.entrySet().iterator();
            while (it.hasNext()) {
                MasterFileObject hfo;
                Map.Entry entry = it.next();
                Reference ref = (Reference)entry.getValue();
                if (ref == null || (hfo = (MasterFileObject)((Object)ref.get())) == null || !hfo.getDelegate().isValid()) continue;
                arrayList.add(hfo);
            }
        }
        Object[] array = new Object[arrayList.size()];
        arrayList.toArray(array);
        return Enumerations.array((Object[])array);
    }

    void clear() {
        this.res2DfoMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterFileObject put(MasterFileObject hfo) {
        MasterFileObject retVal = hfo;
        Map map = this.res2DfoMap;
        synchronized (map) {
            MasterFileObject test = this.get(hfo.getResource());
            if (test == null || !test.isValid()) {
                this.res2DfoMap.remove(hfo.getResource().getNormalizedPath());
                this.res2DfoMap.put(hfo.getResource().getNormalizedPath(), Cache.createReference(hfo));
            } else {
                retVal = test;
            }
        }
        return retVal;
    }

    private static Reference createReference(MasterFileObject hfo) {
        return new SoftReference<MasterFileObject>(hfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replace(String oldResPath, MasterFileObject newObject) {
        Map map = this.res2DfoMap;
        synchronized (map) {
            MasterFileObject test = this.getValidOrInvalid(new ResourcePath(oldResPath));
            if (test != null) {
                this.res2DfoMap.remove(oldResPath);
            }
            this.put(newObject);
        }
    }
}

