/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.syntax.PropertiesKit;
import org.netbeans.modules.properties.syntax.PropertiesOptions;
import org.netbeans.modules.properties.syntax.PropertiesTokenContext;
import org.openide.util.SharedClassObject;

public class EditorSettingsCopy
extends TableViewSettings
implements SettingsChangeListener {
    private static EditorSettingsCopy editorSettingsCopy;
    private Color keyColor;
    private Color keyBackground;
    private Color valueColor;
    private Color valueBackground;
    private Color highlightColor;
    private Color highlightBackground;
    private Color shadowColor;
    private KeyStroke[] keyStrokesFindNext;
    private KeyStroke[] keyStrokesFindPrevious;
    private KeyStroke[] keyStrokesToggleHighlight;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private boolean prepared = false;

    private EditorSettingsCopy() {
    }

    public Color getKeyColor() {
        this.prepareSettings();
        if (this.keyColor == null) {
            this.keyColor = TableViewSettings.KEY_DEFAULT_COLOR;
        }
        return this.keyColor;
    }

    public Color getKeyBackground() {
        this.prepareSettings();
        if (this.keyBackground == null) {
            this.keyBackground = TableViewSettings.KEY_DEFAULT_BACKGROUND;
        }
        return this.keyBackground;
    }

    public Color getValueColor() {
        this.prepareSettings();
        if (this.valueColor == null) {
            this.valueColor = TableViewSettings.VALUE_DEFAULT_COLOR;
        }
        return this.valueColor;
    }

    public Color getValueBackground() {
        this.prepareSettings();
        if (this.valueBackground == null) {
            this.valueBackground = TableViewSettings.VALUE_DEFAULT_BACKGROUND;
        }
        return this.valueBackground;
    }

    public Color getHighlightColor() {
        this.prepareSettings();
        if (this.highlightColor == null) {
            this.highlightColor = TableViewSettings.HIGHLIGHT_DEFAULT_COLOR;
        }
        return this.highlightColor;
    }

    public Color getHighlightBackground() {
        this.prepareSettings();
        if (this.highlightBackground == null) {
            this.highlightBackground = TableViewSettings.HIGHLIGHT_DEFAULT_BACKGROUND;
        }
        return this.highlightBackground;
    }

    public Color getShadowColor() {
        this.prepareSettings();
        if (this.shadowColor == null) {
            this.shadowColor = TableViewSettings.SHADOW_DEFAULT_COLOR;
        }
        return this.shadowColor;
    }

    public Font getFont() {
        this.prepareSettings();
        Font font = SettingsUtil.getColoring((Class)PropertiesKit.class, (String)"default", (boolean)false).getFont();
        return font;
    }

    public KeyStroke[] getKeyStrokesFindNext() {
        this.prepareSettings();
        if (this.keyStrokesFindNext == null || this.keyStrokesFindNext.length == 0) {
            this.keyStrokesFindNext = TableViewSettings.FIND_NEXT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindNext;
    }

    public KeyStroke[] getKeyStrokesFindPrevious() {
        this.prepareSettings();
        if (this.keyStrokesFindPrevious == null || this.keyStrokesFindPrevious.length == 0) {
            this.keyStrokesFindPrevious = TableViewSettings.FIND_PREVIOUS_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindPrevious;
    }

    public KeyStroke[] getKeyStrokesToggleHighlight() {
        this.prepareSettings();
        if (this.keyStrokesToggleHighlight == null || this.keyStrokesToggleHighlight.length == 0) {
            this.keyStrokesToggleHighlight = TableViewSettings.TOGGLE_HIGHLIGHT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesToggleHighlight;
    }

    public void settingsUpdated() {
        if (this.prepared) {
            this.support.firePropertyChange(new PropertyChangeEvent((Object)this, null, null, null));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public static synchronized EditorSettingsCopy getLayerInstance() {
        if (editorSettingsCopy == null) {
            editorSettingsCopy = new EditorSettingsCopy();
        }
        return editorSettingsCopy;
    }

    private void prepareSettings() {
        if (this.prepared) {
            return;
        }
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.updateSettings();
        this.prepared = true;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.updateSettings();
    }

    private void updateSettings() {
        if (this.updateColors()) {
            this.updateKeyStrokes();
        }
    }

    private boolean updateColors() {
        PropertiesOptions propertiesOptions = (PropertiesOptions)SharedClassObject.findObject((Class)PropertiesOptions.class, (boolean)false);
        if (propertiesOptions == null) {
            return false;
        }
        Map map = propertiesOptions.getColoringMap();
        Coloring keyColoring = (Coloring)map.get(PropertiesTokenContext.contextPath.getFullTokenName((TokenCategory)PropertiesTokenContext.KEY));
        this.keyColor = keyColoring.getForeColor();
        this.keyBackground = keyColoring.getBackColor();
        Coloring valueColoring = (Coloring)map.get(PropertiesTokenContext.contextPath.getFullTokenName((TokenCategory)PropertiesTokenContext.VALUE));
        this.valueColor = valueColoring.getForeColor();
        this.valueBackground = valueColoring.getBackColor();
        Coloring highlightColoring = (Coloring)map.get("highlight-search");
        this.highlightColor = highlightColoring.getForeColor();
        this.highlightBackground = highlightColoring.getBackColor();
        this.shadowColor = propertiesOptions.getShadowTableCell();
        Color defaultForeground = ((Coloring)map.get("default")).getForeColor();
        Color defaultBackground = ((Coloring)map.get("default")).getBackColor();
        if (this.keyColor == null) {
            this.keyColor = defaultForeground;
        }
        if (this.keyBackground == null) {
            this.keyBackground = defaultBackground;
        }
        if (this.valueColor == null) {
            this.valueColor = defaultForeground;
        }
        if (this.valueBackground == null) {
            this.valueBackground = defaultBackground;
        }
        if (this.highlightColor == null) {
            this.highlightColor = new Color(SystemColor.textHighlightText.getRGB());
        }
        if (this.highlightBackground == null) {
            this.highlightBackground = new Color(SystemColor.textHighlight.getRGB());
        }
        if (this.shadowColor == null) {
            this.shadowColor = new Color(SystemColor.controlHighlight.getRGB());
        }
        return true;
    }

    private void updateKeyStrokes() {
        Settings.KitAndValue[] kv = Settings.getValueHierarchy((Class)PropertiesKit.class, (String)"key-bindings");
        HashSet<KeyStroke> nextKS = new HashSet<KeyStroke>();
        HashSet<KeyStroke> prevKS = new HashSet<KeyStroke>();
        HashSet<KeyStroke> toggleKS = new HashSet<KeyStroke>();
        for (int i = kv.length - 1; i >= 0; --i) {
            List keyList = (List)kv[i].value;
            JTextComponent.KeyBinding[] bindings = new JTextComponent.KeyBinding[keyList.size()];
            keyList.toArray(bindings);
            for (int j = 0; j < bindings.length; ++j) {
                int k;
                JTextComponent.KeyBinding binding = bindings[j];
                if (binding == null) continue;
                if (binding.actionName.equals("find-next")) {
                    if (binding instanceof MultiKeyBinding && ((MultiKeyBinding)binding).keys != null) {
                        for (k = 0; k < ((MultiKeyBinding)binding).keys.length; ++k) {
                            nextKS.add(((MultiKeyBinding)binding).keys[k]);
                        }
                    } else {
                        nextKS.add(binding.key);
                    }
                }
                if (binding.actionName.equals("find-previous")) {
                    if (binding instanceof MultiKeyBinding && ((MultiKeyBinding)binding).keys != null) {
                        for (k = 0; k < ((MultiKeyBinding)binding).keys.length; ++k) {
                            prevKS.add(((MultiKeyBinding)binding).keys[k]);
                        }
                    } else {
                        prevKS.add(binding.key);
                    }
                }
                if (!binding.actionName.equals("toggle-highlight-search")) continue;
                if (binding instanceof MultiKeyBinding && ((MultiKeyBinding)binding).keys != null) {
                    for (k = 0; k < ((MultiKeyBinding)binding).keys.length; ++k) {
                        toggleKS.add(((MultiKeyBinding)binding).keys[k]);
                    }
                    continue;
                }
                toggleKS.add(binding.key);
            }
        }
        this.keyStrokesFindNext = new KeyStroke[nextKS.size()];
        nextKS.toArray(this.keyStrokesFindNext);
        this.keyStrokesFindPrevious = new KeyStroke[prevKS.size()];
        prevKS.toArray(this.keyStrokesFindPrevious);
        this.keyStrokesToggleHighlight = new KeyStroke[toggleKS.size()];
        toggleKS.toArray(this.keyStrokesToggleHighlight);
        this.settingsUpdated();
    }
}

