/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ResultWindow
extends TopComponent {
    private static final String ID = "junit-test-results";
    private static WeakReference instance = null;
    private TopComponent view;
    private Map topCompMethodsMap;

    static synchronized ResultWindow getInstance() {
        ResultWindow window = (ResultWindow)WindowManager.getDefault().findTopComponent(ID);
        if (window == null) {
            window = ResultWindow.getDefault();
        }
        return window;
    }

    public static synchronized ResultWindow getDefault() {
        ResultWindow window;
        if (instance == null || (window = (ResultWindow)((Object)instance.get())) == null) {
            window = new ResultWindow();
            instance = new WeakReference<ResultWindow>(window);
        }
        return window;
    }

    public ResultWindow() {
        this.setLayout(new BorderLayout());
        this.setName(ID);
        this.setDisplayName(NbBundle.getMessage(ResultWindow.class, (String)"TITLE_TEST_RESULTS"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/junit/output/res/testResults.png", (boolean)true));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSN_TestResults"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_TestResults"));
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        if (this.view != null) {
            this.forwardMessage(this.view, "componentOpened");
        }
        super.componentOpened();
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        if (this.view != null) {
            this.forwardMessage(this.view, "componentClosed");
        }
        super.componentClosed();
    }

    protected void componentActivated() {
        assert (EventQueue.isDispatchThread());
        if (this.view != null) {
            this.forwardMessage(this.view, "componentActivated");
        }
        super.componentActivated();
    }

    protected void componentDeactivated() {
        assert (EventQueue.isDispatchThread());
        if (this.view != null) {
            this.forwardMessage(this.view, "componentDeactivated");
        }
        super.componentDeactivated();
    }

    protected void componentShowing() {
        assert (EventQueue.isDispatchThread());
        if (this.view != null) {
            this.forwardMessage(this.view, "componentShowing");
        }
        super.componentShowing();
    }

    protected void componentHidden() {
        assert (EventQueue.isDispatchThread());
        if (this.view != null) {
            this.forwardMessage(this.view, "componentHidden");
        }
        super.componentHidden();
    }

    private void forwardMessage(TopComponent tc, String messageName) {
        this.ensureMethodsPrepared();
        Method method = (Method)this.topCompMethodsMap.get(messageName);
        if (method != null) {
            try {
                method.invoke((Object)tc, (Object[])null);
            }
            catch (InvocationTargetException invocationExc) {
                ErrorManager.getDefault().notify((Throwable)invocationExc);
            }
            catch (Exception ex) {
                this.topCompMethodsMap.remove(messageName);
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
    }

    private void ensureMethodsPrepared() {
        if (this.topCompMethodsMap == null) {
            this.prepareMethods();
        }
    }

    private void prepareMethods() throws SecurityException {
        assert (this.topCompMethodsMap == null);
        assert (this.view != null);
        this.topCompMethodsMap = new HashMap(8);
        String[] methodNames = new String[]{"componentOpened", "componentClosed", "componentActivated", "componentDeactivated", "componentShowing", "componentHidden"};
        ArrayList<Method> methods = new ArrayList<Method>(methodNames.length);
        Class<?> viewClass = this.view.getClass();
        Class[] noParams = new Class[]{};
        for (int i = 0; i < methodNames.length; ++i) {
            try {
                String methodName = methodNames[i];
                Method m = viewClass.getDeclaredMethod(methodName, noParams);
                this.topCompMethodsMap.put(methodName, m);
                methods.add(m);
                continue;
            }
            catch (NoSuchMethodException ex) {
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
        if (!methods.isEmpty()) {
            AccessibleObject[] methodsArray = new Method[methods.size()];
            methods.toArray(methodsArray);
            Method.setAccessible(methodsArray, true);
        }
    }

    void addDisplayComponent(TopComponent displayComp) {
        assert (EventQueue.isDispatchThread());
        this.removeAll();
        this.addView(displayComp);
    }

    private void addView(TopComponent view) {
        assert (EventQueue.isDispatchThread());
        this.view = view;
        if (this.isOpened()) {
            this.forwardMessage(view, "componentOpened");
            if (this.isShowing()) {
                this.forwardMessage(view, "componentShowing");
                if (this.isActivated()) {
                    this.forwardMessage(view, "componentActivated");
                }
            }
        }
        this.add((Component)view);
    }

    private boolean isActivated() {
        return TopComponent.getRegistry().getActivated() == this;
    }

    void promote() {
        assert (EventQueue.isDispatchThread());
        this.open();
        this.requestVisible();
        this.requestActive();
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public int getPersistenceType() {
        return 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultWindow.getDefault();
    }
}

