/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.java.classpath.ClassPath;

final class Report {
    File antScript;
    File resultsDir;
    String suiteClassName;
    String classpath;
    ClassPath platformSources;
    Collection classpathSourceRoots;
    String[] outputStd;
    String[] outputErr;
    int totalTests;
    int failures;
    int errors;
    int elapsedTimeMillis;
    int detectedPassedTests;
    private Collection tests;
    private boolean closed = false;

    Report(String suiteClassName) {
        this.suiteClassName = suiteClassName;
        this.antScript = this.antScript;
        this.tests = new ArrayList(10);
    }

    void reportTest(Testcase test) {
        this.tests.add(test);
        if (test.trouble == null) {
            ++this.detectedPassedTests;
        }
    }

    void update(Report report) {
        this.resultsDir = report.resultsDir;
        this.suiteClassName = report.suiteClassName;
        this.outputStd = report.outputStd;
        this.outputErr = report.outputErr;
        this.totalTests = report.totalTests;
        this.failures = report.failures;
        this.errors = report.errors;
        this.elapsedTimeMillis = report.elapsedTimeMillis;
        this.detectedPassedTests = report.detectedPassedTests;
        this.tests = report.tests;
    }

    Collection getTests() {
        if (this.tests.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.tests);
    }

    boolean containsFailed() {
        return this.failures + this.errors != 0;
    }

    static final class Trouble {
        private final boolean error;
        String message;
        String exceptionClsName;
        String[] stackTrace;

        Trouble(boolean error) {
            this.error = error;
        }

        boolean isError() {
            return this.error;
        }
    }

    static final class Testcase {
        String className;
        String name;
        int timeMillis;
        Trouble trouble;

        Testcase() {
        }
    }
}

