/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.AntSessionInfo;
import org.netbeans.modules.junit.output.JUnitOutputReader;

public final class JUnitAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 3};
    private static final String[] JUNIT_STRARR = new String[]{"junit"};
    private static final String[] JAVA_STRARR = new String[]{"java"};
    private static final String ANT_TEST_RUNNER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner";
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        int sessionType = this.getSessionType(session);
        return sessionType == 2 ? JUNIT_STRARR : (sessionType == 3 ? JAVA_STRARR : AntLogger.NO_TASKS);
    }

    private static int detectSessionType(AntSession session) {
        String[] originatingTargets = session.getOriginatingTargets();
        if (originatingTargets.length == 0) {
            return 0;
        }
        if (originatingTargets.length == 1) {
            String origTarget = originatingTargets[0];
            if (origTarget.startsWith("test") && (origTarget.length() == 4 || !Character.isLetter(origTarget.charAt(4))) || origTarget.equals("run-tests")) {
                return 2;
            }
            if (origTarget.startsWith("debug-test") && (origTarget.length() == 10 || !Character.isLetter(origTarget.charAt(10)))) {
                return 3;
            }
        }
        return 1;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        if (event.getLogLevel() != 3) {
            this.getOutputReader(event.getSession()).messageLogged(event);
        } else {
            this.verboseMessageLogged(event);
        }
    }

    private void verboseMessageLogged(AntEvent event) {
        String currTask = event.getTaskName();
        if (currTask == null) {
            return;
        }
        AntSession session = event.getSession();
        String[] myTasks = this.interestedInTasks(session);
        for (int i = 0; i < myTasks.length; ++i) {
            if (!currTask.equals(myTasks[i])) continue;
            this.getOutputReader(session).verboseMessageLogged(event);
            break;
        }
    }

    public void taskStarted(AntEvent event) {
        boolean hasXmlOutput = JUnitAntLogger.hasXmlOutput(event);
        this.getOutputReader(event.getSession()).testTaskStarted(hasXmlOutput);
    }

    public void buildFinished(AntEvent event) {
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        int sessionType = sessionInfo.sessionType;
        if (sessionType != 0 && sessionType != 1) {
            this.getOutputReader(event.getSession()).buildFinished(event);
        }
        session.putCustomData((AntLogger)this, null);
    }

    private int getSessionType(AntSession session) {
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        assert (sessionInfo != null);
        int sessionType = sessionInfo.sessionType;
        if (sessionType == 0 && (sessionType = JUnitAntLogger.detectSessionType(session)) != 0) {
            sessionInfo.sessionType = sessionType;
            if (sessionType != 1) {
                this.getOutputReader(session).testTargetStarted();
            }
        }
        return sessionType;
    }

    private JUnitOutputReader getOutputReader(AntSession session) {
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        JUnitOutputReader outputReader = sessionInfo.outputReader;
        if (outputReader == null) {
            sessionInfo.outputReader = outputReader = new JUnitOutputReader(session, this.getSessionType(session), sessionInfo.getTimeOfSessionStart());
        }
        return outputReader;
    }

    private AntSessionInfo getSessionInfo(AntSession session) {
        AntSessionInfo sessionInfo;
        Object o = session.getCustomData((AntLogger)this);
        assert (o == null || o instanceof AntSessionInfo);
        if (o != null) {
            sessionInfo = (AntSessionInfo)o;
        } else {
            sessionInfo = new AntSessionInfo();
            session.putCustomData((AntLogger)this, (Object)sessionInfo);
        }
        return sessionInfo;
    }

    private static boolean hasXmlOutput(AntEvent event) {
        String taskName = event.getTaskName();
        if (taskName.equals("junit")) {
            return JUnitAntLogger.hasXmlOutputJunit(event);
        }
        if (taskName.equals("java")) {
            return JUnitAntLogger.hasXmlOutputJava(event);
        }
        assert (false);
        return false;
    }

    private static boolean hasXmlOutputJunit(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        for (TaskStructure child : taskStruct.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("formatter")) continue;
            String type = child.getAttribute("type");
            String usefile = child.getAttribute("usefile");
            if (type == null || !type.equals("xml") || usefile == null || JUnitAntLogger.isAntTrue(usefile)) continue;
            String ifPropName = child.getAttribute("if");
            String unlessPropName = child.getAttribute("unless");
            if (ifPropName != null && event.getProperty(ifPropName) == null || unlessPropName != null && event.getProperty(unlessPropName) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasXmlOutputJava(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        String classname = taskStruct.getAttribute("classname");
        if (classname == null || !event.evaluate(classname).equals(ANT_TEST_RUNNER_CLASS_NAME)) {
            return false;
        }
        for (TaskStructure child : taskStruct.getChildren()) {
            int clsNameStartIndex;
            String argValue;
            String childName = child.getName();
            if (!childName.equals("arg") || (argValue = child.getAttribute("value")) == null || !(argValue = event.evaluate(argValue)).startsWith("formatter=") || argValue.indexOf(44, clsNameStartIndex = "formatter=".length()) != -1 || !argValue.substring(clsNameStartIndex).equals(XML_FORMATTER_CLASS_NAME)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAntTrue(String s) {
        return "on".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s);
    }
}

