/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.modules.junit.TestAction;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class OpenTestAction
extends TestAction {
    public OpenTestAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Object[] objectArray;
            String msgPattern;
            boolean isDefPkg;
            FileObject selectedFO = TestUtil.getFileObjectFromNode(nodes[i]);
            if (selectedFO == null) {
                TestUtil.notifyUser(NbBundle.getMessage(OpenTestAction.class, (String)"MSG_file_from_node_failed"));
                continue;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)selectedFO, (String)"classpath/source");
            if (cp == null) {
                TestUtil.notifyUser(NbBundle.getMessage(OpenTestAction.class, (String)"MSG_no_project", (Object)selectedFO));
                continue;
            }
            FileObject packageRoot = cp.findOwnerRoot(selectedFO);
            URL[] testRoots = UnitTestForSourceQuery.findUnitTests((FileObject)packageRoot);
            FileObject fileToOpen = null;
            for (int j = 0; j < testRoots.length && (fileToOpen = OpenTestAction.findUnitTestInTestRoot(cp, selectedFO, testRoots[j])) == null; ++j) {
            }
            if (fileToOpen != null) {
                OpenTestAction.openFile(fileToOpen);
                continue;
            }
            String testClsName = OpenTestAction.getTestName(cp, selectedFO).replace('/', '.');
            String pkgName = cp.getResourceName(selectedFO, '.', false);
            boolean isPackage = selectedFO.isFolder();
            boolean bl = isDefPkg = isPackage && pkgName.length() == 0;
            String string = !isPackage ? "MSG_test_class_not_found" : (msgPattern = isDefPkg ? "MSG_testsuite_class_not_found_def_pkg" : "MSG_testsuite_class_not_found");
            if (isDefPkg) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = testClsName;
            } else {
                String[] stringArray = new String[2];
                stringArray[0] = testClsName;
                objectArray = stringArray;
                stringArray[1] = pkgName;
            }
            Object[] params = objectArray;
            TestUtil.notifyUser(NbBundle.getMessage(OpenTestAction.class, (String)msgPattern, (Object[])params), 1);
        }
    }

    private static FileObject findUnitTestInTestRoot(ClassPath cp, FileObject selectedFO, URL testRoot) {
        ClassPath testClassPath = null;
        if (testRoot == null) {
            testClassPath = cp;
        } else {
            try {
                ArrayList<PathResourceImplementation> cpItems = new ArrayList<PathResourceImplementation>();
                cpItems.add(ClassPathSupport.createResource((URL)testRoot));
                testClassPath = ClassPathSupport.createClassPath(cpItems);
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                testClassPath = cp;
            }
        }
        String testName = OpenTestAction.getTestName(cp, selectedFO);
        return testClassPath.findResource(testName + ".java");
    }

    private static String getTestName(ClassPath cp, FileObject selectedFO) {
        String resource = cp.getResourceName(selectedFO, '/', false);
        String testName = null;
        testName = selectedFO.isFolder() ? TestUtil.convertPackage2SuiteName(resource) : TestUtil.convertClass2TestName(resource);
        return testName;
    }

    public static boolean openFile(FileObject fo) {
        DataObject dobj;
        try {
            dobj = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().log(65536, e.toString());
            return false;
        }
        if (dobj == null) {
            return false;
        }
        EditorCookie cookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
        if (cookie == null) {
            return false;
        }
        cookie.open();
        return true;
    }

    static boolean openFileAtElement(FileObject fileObject, Feature element) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().log(65536, e.toString());
            return false;
        }
        assert (dataObject != null);
        JEditorPane openedEditor = OpenTestAction.getEditor(dataObject);
        if (openedEditor == null) {
            return false;
        }
        int startOffset = element.getStartOffset();
        int endOffset = element.getEndOffset();
        int caretPosition = openedEditor.getCaretPosition();
        if (caretPosition < startOffset || caretPosition >= endOffset) {
            openedEditor.setCaretPosition(startOffset);
        }
        return true;
    }

    private static JEditorPane getEditor(DataObject dataObj) {
        EditorCookie editorCookie = (EditorCookie)dataObj.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        editorCookie.open();
        JEditorPane[] editorPanes = editorCookie.getOpenedPanes();
        return editorPanes != null ? editorPanes[0] : null;
    }

    public String getName() {
        return NbBundle.getMessage(OpenTestAction.class, (String)"LBL_Action_OpenTest");
    }

    protected String iconResource() {
        return "org/netbeans/modules/junit/resources/OpenTestActionIcon.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenTestAction.class);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(OpenTestAction.class, (String)"HINT_Action_OpenTest"));
    }
}

