/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.commit.CommitBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;

public class CommitCommand
extends BasicCommand {
    private final List argumentRequests = new LinkedList();
    private String message;
    private boolean forceCommit;
    private String logMessageFromFile;
    private boolean noModuleProgram;
    private String toRevisionOrBranch;

    public CommitCommand() {
        this.resetCVSCommand();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isForceCommit() {
        return this.forceCommit;
    }

    public void setForceCommit(boolean forceCommit) {
        this.forceCommit = forceCommit;
    }

    protected void addRequestsForDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        String dir = this.getRelativeToLocalPathInUnixStyle(directory);
        try {
            String repository = this.clientServices.getRepositoryForDirectory(directory.getAbsolutePath());
            this.requests.add(new DirectoryRequest(dir, repository));
            String tag2 = this.clientServices.getStickyTagForDirectory(directory);
            if (tag2 != null) {
                this.requests.add(new StickyRequest(tag2));
            }
        }
        catch (IOException ex) {
            System.err.println("An error occurred reading the respository for the directory " + dir + ": " + ex);
            ex.printStackTrace();
        }
        Set set = this.clientServices.getAllFiles(directory);
        File[] files = directory.listFiles();
        set.addAll(Arrays.asList(files));
        LinkedList<File> subdirectories = null;
        if (this.isRecursive()) {
            subdirectories = new LinkedList<File>();
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (file.getName().equals("CVS")) continue;
            try {
                File cvsSubDir;
                Entry entry = this.clientServices.getEntry(file);
                if (entry == null) continue;
                if (file.isFile()) {
                    this.sendEntryAndModifiedRequests(entry, file);
                    continue;
                }
                if (!this.isRecursive() || !file.isDirectory() || !(cvsSubDir = new File(file, "CVS")).exists()) continue;
                subdirectories.add(file);
            }
            catch (IOException ex) {
                System.err.println("An error occurred getting the Entry for file " + file + ": " + ex);
                ex.printStackTrace();
            }
        }
        if (this.isRecursive()) {
            it = subdirectories.iterator();
            while (it.hasNext()) {
                File subdirectory = (File)it.next();
                this.addRequestsForDirectory(subdirectory);
            }
        }
    }

    protected void addRequestsForFile(File file) throws IOException {
        File parentDirectory = file.getParentFile();
        String dir = this.getRelativeToLocalPathInUnixStyle(parentDirectory);
        try {
            this.requests.add(new DirectoryRequest(dir, this.clientServices.getRepositoryForDirectory(parentDirectory.getAbsolutePath())));
            String tag2 = this.clientServices.getStickyTagForDirectory(parentDirectory);
            if (tag2 != null) {
                this.requests.add(new StickyRequest(tag2));
            }
        }
        catch (IOException ex) {
            System.err.println("An error occurred reading the respository for the directory " + dir + ": " + ex);
            ex.printStackTrace();
        }
        try {
            Entry entry = this.clientServices.getEntry(file);
            if (entry != null) {
                this.sendEntryAndModifiedRequests(entry, file);
            }
        }
        catch (IOException ex) {
            System.err.println("An error occurred getting the Entry for file " + file + ": " + ex);
            ex.printStackTrace();
        }
    }

    protected boolean doesCheckFileTime() {
        return !this.isForceCommit();
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        super.execute(client, em);
        try {
            if (this.isForceCommit()) {
                this.requests.add(1, new ArgumentRequest("-f"));
                if (this.isRecursive()) {
                    this.requests.add(1, new ArgumentRequest("-R"));
                }
            }
            if (this.isNoModuleProgram()) {
                this.requests.add(1, new ArgumentRequest("-n"));
            }
            if (this.getToRevisionOrBranch() != null) {
                this.requests.add(1, new ArgumentRequest("-r"));
                this.requests.add(2, new ArgumentRequest(this.getToRevisionOrBranch()));
            }
            String message = this.getMessage();
            if (this.getLogMessageFromFile() != null) {
                message = this.loadLogFile(this.getLogMessageFromFile());
            }
            if (message != null) {
                message = message.trim();
            }
            if (message == null || message.length() == 0) {
                message = "no message";
            }
            this.addMessageRequest(message);
            this.addRequestForWorkingDirectory(client);
            this.requests.addAll(this.argumentRequests);
            this.argumentRequests.clear();
            this.addArgumentRequests();
            this.requests.add(CommandRequest.COMMIT);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    protected void addArgumentRequests() {
        if (this.isForceCommit()) {
            Iterator it = this.requests.iterator();
            String directory = "";
            LinkedList<ArgumentRequest> args = new LinkedList<ArgumentRequest>();
            while (it.hasNext()) {
                Object req = it.next();
                if (req instanceof DirectoryRequest) {
                    DirectoryRequest dirReq = (DirectoryRequest)req;
                    directory = dirReq.getLocalDirectory();
                    continue;
                }
                if (!(req instanceof EntryRequest)) continue;
                EntryRequest entReq = (EntryRequest)req;
                String argument = null;
                argument = directory.length() == 0 ? entReq.getEntry().getName() : directory + '/' + entReq.getEntry().getName();
                args.add(new ArgumentRequest(argument));
            }
            it = args.iterator();
            while (it.hasNext()) {
                this.requests.add(it.next());
            }
        } else {
            super.addArgumentRequests();
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("commit ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (int index = 0; index < files.length; ++index) {
                toReturn.append(files[index].getName() + " ");
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'm') {
            this.setMessage(optArg);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'f') {
            this.setForceCommit(true);
        } else if (opt == 'F') {
            this.setLogMessageFromFile(optArg);
        } else if (opt == 'r') {
            this.setToRevisionOrBranch(optArg);
        } else if (opt == 'n') {
            this.setNoModuleProgram(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "m:flRnF:r:";
    }

    public Builder createBuilder(EventManager eventMan) {
        return new CommitBuilder(eventMan, this.getLocalDirectory(), this.clientServices.getRepository());
    }

    private void addMessageRequest(String message) {
        this.requests.add(new ArgumentRequest("-m"));
        StringTokenizer token = new StringTokenizer(message, "\n", false);
        boolean first = true;
        while (token.hasMoreTokens()) {
            if (first) {
                this.requests.add(new ArgumentRequest(token.nextToken()));
                first = false;
                continue;
            }
            this.requests.add(new ArgumentxRequest(token.nextToken()));
        }
    }

    public String getLogMessageFromFile() {
        return this.logMessageFromFile;
    }

    public void setLogMessageFromFile(String logMessageFromFile) {
        this.logMessageFromFile = logMessageFromFile;
    }

    public boolean isNoModuleProgram() {
        return this.noModuleProgram;
    }

    public void setNoModuleProgram(boolean noModuleProgram) {
        this.noModuleProgram = noModuleProgram;
    }

    public String getToRevisionOrBranch() {
        return this.toRevisionOrBranch;
    }

    public void setToRevisionOrBranch(String toRevBranch) {
        this.toRevisionOrBranch = toRevBranch;
    }

    private String loadLogFile(String fileName) throws CommandException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(fileName));
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
        }
        catch (FileNotFoundException ex) {
            throw new CommandException(ex, CommandException.getLocalMessage("CommitCommand.logInfoFileNotExists", new Object[]{fileName}));
        }
        catch (IOException ex) {
            throw new CommandException(ex, CommandException.getLocalMessage("CommitCommand.errorReadingLogFile", new Object[]{fileName}));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exc) {}
            }
        }
        return buffer.toString();
    }

    public void resetCVSCommand() {
        this.setMessage(null);
        this.setRecursive(true);
        this.setForceCommit(false);
        this.setLogMessageFromFile(null);
        this.setNoModuleProgram(false);
        this.setToRevisionOrBranch(null);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer();
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isForceCommit()) {
            toReturn.append("-f ");
            if (this.isRecursive()) {
                toReturn.append("-R ");
            }
        }
        if (this.isNoModuleProgram()) {
            toReturn.append("-n ");
        }
        if (this.getToRevisionOrBranch() != null) {
            toReturn.append("-r ");
            toReturn.append(this.getToRevisionOrBranch() + " ");
        }
        if (this.getLogMessageFromFile() != null) {
            toReturn.append("-F ");
            toReturn.append(this.getLogMessageFromFile());
            toReturn.append(" ");
        }
        if (this.getMessage() != null) {
            toReturn.append("-m \"");
            toReturn.append(this.getMessage());
            toReturn.append("\" ");
        }
        return toReturn.toString();
    }
}

