/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Type;

public final class SrcFinder {
    private static final ElementFormat FORMATOR = new ElementFormat("{C}");

    private SrcFinder() {
    }

    static Element findSource(String aPackage, URL url) {
        String resourceName;
        FileObject fo;
        aPackage = aPackage.replace('.', '/');
        String thePackage = null;
        String member = url.getRef();
        String clazz = url.getFile();
        String filename = null;
        int pIndex = clazz.toLowerCase().indexOf(aPackage.trim().toLowerCase());
        if (pIndex != -1) {
            thePackage = clazz.substring(pIndex, pIndex + aPackage.trim().length() - 1);
            int ei = (clazz = clazz.substring(pIndex + aPackage.trim().length(), clazz.length() - 5)).indexOf(46);
            filename = ei != -1 ? clazz.substring(0, ei) : clazz;
        }
        if ((fo = SrcFinder.searchResource(url, resourceName = thePackage + "/" + filename + ".java")) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                SourceCookie sc = (SourceCookie)dobj.getCookie(SourceCookie.class);
                ClassElement[] classes = sc.getSource().getAllClasses();
                for (int i = 0; i < classes.length; ++i) {
                    String outerName = FORMATOR.format((Element)classes[i]);
                    if (!clazz.equals(outerName)) continue;
                    if (member == null) {
                        return classes[i];
                    }
                    int pi = member.indexOf(40);
                    if (pi == -1) {
                        FieldElement fe = classes[i].getField(Identifier.create((String)member));
                        return fe;
                    }
                    return SrcFinder.getMethod(classes[i], member);
                }
                return null;
            }
            catch (DataObjectNotFoundException e) {
                System.out.println((Object)e);
            }
        }
        return null;
    }

    private static FileObject searchResource(URL url, String respath) {
        FileObject res = SrcFinder.searchBinaryPath("classpath/boot", respath, url);
        if (res == null) {
            res = SrcFinder.searchBinaryPath("classpath/compile", respath, url);
        }
        if (res == null) {
            res = SrcFinder.searchSourcePath(respath, url);
        }
        return res;
    }

    private static FileObject searchBinaryPath(String classPathID, String respath, URL url) {
        Set cpaths = GlobalPathRegistry.getDefault().getPaths(classPathID);
        Iterator it = cpaths.iterator();
        while (it.hasNext()) {
            ClassPath cpath = (ClassPath)it.next();
            FileObject[] cpRoots = cpath.getRoots();
            for (int i = 0; i < cpRoots.length; ++i) {
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)URLMapper.findURL((FileObject)cpRoots[i], (int)1));
                FileObject[] srcRoots = result.getRoots();
                for (int j = 0; j < srcRoots.length; ++j) {
                    FileObject fo = srcRoots[j].getFileObject(respath);
                    if (fo == null || !SrcFinder.isJavadocAssigned(cpath, url)) continue;
                    return fo;
                }
            }
        }
        return null;
    }

    private static FileObject searchSourcePath(String respath, URL url) {
        Set cpaths = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        Iterator it = cpaths.iterator();
        while (it.hasNext()) {
            ClassPath cpath = (ClassPath)it.next();
            FileObject fo = cpath.findResource(respath);
            if (fo == null || !SrcFinder.isJavadocAssigned(cpath, url)) continue;
            return fo;
        }
        return null;
    }

    private static boolean isJavadocAssigned(ClassPath cpath, URL url) {
        FileObject[] cpRoots = cpath.getRoots();
        String urlPath = url.toExternalForm();
        for (int i = 0; i < cpRoots.length; ++i) {
            JavadocForBinaryQuery.Result result = JavadocForBinaryQuery.findJavadoc((URL)URLMapper.findURL((FileObject)cpRoots[i], (int)1));
            URL[] jdRoots = result.getRoots();
            for (int j = 0; j < jdRoots.length; ++j) {
                String jdRootPath = jdRoots[j].toExternalForm();
                if (urlPath.indexOf(jdRootPath) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static ConstructorElement getMethod(ClassElement ce, String member) {
        int pi = member.indexOf(40);
        String name = member.substring(0, pi);
        StringTokenizer tokenizer = new StringTokenizer(member.substring(pi), " ,()");
        ArrayList<Type> paramList = new ArrayList<Type>();
        while (tokenizer.hasMoreTokens()) {
            paramList.add(Type.parse((String)tokenizer.nextToken()));
        }
        Type[] params = new Type[paramList.size()];
        paramList.toArray(params);
        ConstructorElement result = ce.getConstructor(params);
        if (result == null) {
            result = ce.getMethod(Identifier.create((String)name), params);
        }
        return result;
    }
}

