/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress.aggregate;

import org.netbeans.api.progress.aggregate.AggregateProgressHandle;

public final class ProgressContributor {
    private String id;
    private int workunits;
    private int current;
    private int parentUnits;
    private int lastParentedUnit;
    private AggregateProgressHandle parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    ProgressContributor(String id) {
        this.id = id;
        this.workunits = 0;
        this.current = 0;
        this.lastParentedUnit = 0;
    }

    public String getTrackingId() {
        return this.id;
    }

    void setParent(AggregateProgressHandle par) {
        this.parent = par;
    }

    int getWorkUnits() {
        return this.workunits;
    }

    int getRemainingParentWorkUnits() {
        return this.parentUnits;
    }

    void setAvailableParentWorkUnits(int newCount) {
        this.parentUnits = newCount;
    }

    double getCompletedRatio() {
        return this.workunits == 0 ? 0.0 : (double)(this.current / this.workunits);
    }

    public void start(int workunits) {
        if (this.parent == null) {
            return;
        }
        this.workunits = workunits;
        this.parent.processContributorStart(this, null);
    }

    public void finish() {
        if (this.parent == null) {
            return;
        }
        if (this.current < this.workunits) {
            this.progress(null, this.workunits);
        }
        this.parent.processContributorFinish(this);
    }

    public void progress(int workunit) {
        this.progress(null, workunit);
    }

    public void progress(String message) {
        this.progress(message, this.current);
    }

    public void progress(String message, int unit) {
        if (this.parent == null) {
            return;
        }
        if (!($assertionsDisabled || unit >= this.current && unit <= this.workunits)) {
            throw new AssertionError();
        }
        if (message != null && unit == this.current) {
            this.parent.processContributorStep(this, message, 0);
            return;
        }
        this.current = unit;
        int delta = this.current - this.lastParentedUnit;
        double step = 1.0 / ((double)this.parentUnits / (double)(this.workunits - this.lastParentedUnit));
        if ((double)delta >= step) {
            int count = (int)((double)delta / step);
            this.lastParentedUnit += (int)((double)count * step);
            this.parentUnits -= count;
            this.parent.processContributorStep(this, message, count);
        }
    }

    static {
        $assertionsDisabled = !ProgressContributor.class.desiredAssertionStatus();
    }
}

