/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TargetModuleConverter
extends DOMConvertor {
    private static final String PUBLIC_ID = "-//org_netbeans_modules_j2ee//DTD TargetModule 1.0//EN";
    private static final String SYSTEM_ID = "nbres:/org/netbeans/modules/j2ee/deployment/impl/target-module.dtd";
    private static final String E_TARGET_MODULE_LIST = "target-module-list";
    private static final String E_TARGET_MODULE = "target-module";
    private static final String A_ID = "id";
    private static final String A_INSTANCE_URL = "instance-url";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TIMESTAMP = "timestamp";
    private static final String A_CONTENT_DIR = "content-dir";
    private static final String A_CONTEXT_ROOT = "context-root";
    private static final String DIR_TARGETMODULES = "TargetModules";
    private static FileObject targetModulesDir = null;

    public static DOMConvertor create() {
        return new TargetModuleConverter();
    }

    protected TargetModuleConverter() {
        super(PUBLIC_ID, SYSTEM_ID, E_TARGET_MODULE_LIST);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        NodeList targetModuleElements = element.getElementsByTagName(E_TARGET_MODULE);
        TargetModule[] targetModules = new TargetModule[targetModuleElements.getLength()];
        for (int i = 0; i < targetModules.length; ++i) {
            Element te = (Element)targetModuleElements.item(i);
            String id = te.getAttribute(A_ID);
            String url = te.getAttribute(A_INSTANCE_URL);
            String targetName = te.getAttribute(A_TARGET_NAME);
            String timestamp = te.getAttribute(A_TIMESTAMP);
            String contentDir = te.getAttribute(A_CONTENT_DIR);
            String contextRoot = te.getAttribute(A_CONTEXT_ROOT);
            if (id == null || url == null || targetName == null) {
                throw new IOException(NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_TargetModuleParseError"));
            }
            try {
                targetModules[i] = new TargetModule(id, url, targetName, Long.parseLong(timestamp), contentDir, contextRoot);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)nfe);
            }
        }
        return new TargetModule.List(targetModules);
    }

    protected void writeElement(Document doc, Element element, Object obj) throws IOException, DOMException {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof TargetModule.List)) {
            throw new DOMException(9, NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_NotSupportedObject", obj.getClass()));
        }
        TargetModule.List tmList = (TargetModule.List)obj;
        TargetModule[] targetModules = tmList.getTargetModules();
        for (int i = 0; i < targetModules.length; ++i) {
            Element tmElement = doc.createElement(E_TARGET_MODULE);
            tmElement.setAttribute(A_ID, targetModules[i].getId());
            tmElement.setAttribute(A_INSTANCE_URL, targetModules[i].getInstanceUrl());
            tmElement.setAttribute(A_TARGET_NAME, targetModules[i].getTargetName());
            tmElement.setAttribute(A_TIMESTAMP, String.valueOf(targetModules[i].getTimestamp()));
            tmElement.setAttribute(A_CONTENT_DIR, targetModules[i].getContentDirectory());
            tmElement.setAttribute(A_CONTEXT_ROOT, targetModules[i].getContextRoot());
            element.appendChild(tmElement);
        }
    }

    public void registerSaver(Object inst, Saver s) {
    }

    public void unregisterSaver(Object inst, Saver s) {
    }

    private static FileObject getTargetModulesDir() throws IOException {
        FileObject j2eeDir;
        if (targetModulesDir == null && (targetModulesDir = (j2eeDir = Repository.getDefault().getDefaultFileSystem().findResource("/J2EE")).getFileObject(DIR_TARGETMODULES)) == null) {
            targetModulesDir = j2eeDir.createFolder(DIR_TARGETMODULES);
        }
        return targetModulesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTargetModule(TargetModule instance, String managerDir, String targetDir, String tmFileName) {
        FileLock lock = null;
        Writer writer = null;
        try {
            FileObject targetDirFO;
            FileObject managerDirFO = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (managerDirFO == null) {
                managerDirFO = TargetModuleConverter.getTargetModulesDir().createFolder(managerDir);
            }
            if ((targetDirFO = managerDirFO.getFileObject(targetDir)) == null) {
                targetDirFO = managerDirFO.createFolder(targetDir);
            }
            FileObject fo = FileUtil.createData((FileObject)targetDirFO, (String)tmFileName);
            lock = fo.lock();
            writer = new OutputStreamWriter(fo.getOutputStream(lock));
            TargetModuleConverter.create().write(writer, (Object)new TargetModule.List(instance));
            boolean bl = true;
            return bl;
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetModule readTargetModule(String managerDir, String targetDir, String tmFileName) {
        TargetModule targetModule;
        Reader reader = null;
        try {
            FileObject fo;
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null && (fo = dir.getFileObject(tmFileName)) != null) {
                reader = new InputStreamReader(fo.getInputStream());
                TargetModule.List tml = (TargetModule.List)TargetModuleConverter.create().read(reader);
                if (tml == null || tml.getTargetModules().length < 1) {
                    TargetModule targetModule2 = null;
                    return targetModule2;
                }
                TargetModule targetModule3 = tml.getTargetModules()[0];
                return targetModule3;
            }
            targetModule = null;
            return targetModule;
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            targetModule = null;
            return targetModule;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTargetModulesByContextRoot(String managerDir, String targetDir, String contextRoot) {
        Reader reader = null;
        try {
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null) {
                Enumeration fos = dir.getChildren(false);
                ArrayList<TargetModule> result = new ArrayList<TargetModule>();
                while (fos.hasMoreElements()) {
                    TargetModule tm;
                    FileObject fo = (FileObject)fos.nextElement();
                    reader = new InputStreamReader(fo.getInputStream());
                    TargetModule.List tml = (TargetModule.List)TargetModuleConverter.create().read(reader);
                    if (tml == null || tml.getTargetModules().length <= 0 || !contextRoot.equals((tm = tml.getTargetModules()[0]).getContextRoot())) continue;
                    result.add(tm);
                }
                ArrayList<TargetModule> arrayList = result;
                return arrayList;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetModule remove(String managerDir, String targetDir, String tmFileName) {
        FileLock lock = null;
        try {
            FileObject fo;
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null && (fo = dir.getFileObject(tmFileName)) != null) {
                lock = fo.lock();
                fo.delete(lock);
            }
            TargetModule targetModule = null;
            return targetModule;
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            TargetModule targetModule = null;
            return targetModule;
        }
        finally {
            try {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }
}

