/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InstancePropertiesImpl
extends InstanceProperties
implements InstanceListener {
    private final String url;
    private transient FileObject fo;

    public InstancePropertiesImpl(ServerInstance instance) {
        this(instance.getUrl());
    }

    public InstancePropertiesImpl(String url) {
        this.url = url;
    }

    private FileObject getFO() {
        if (this.fo == null) {
            ServerInstance instance = ServerRegistry.getInstance().getServerInstance(this.url);
            if (instance == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
            ServerRegistry.getInstance();
            this.fo = ServerRegistry.getInstanceFileObject(this.url);
            if (this.fo == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
        }
        return this.fo;
    }

    public void instanceRemoved(String instance) {
        if (instance != null && this.url.equals(instance)) {
            this.fo = null;
        }
    }

    public void instanceAdded(String instance) {
    }

    public void changeDefaultInstance(String oldInstance, String newInstance) {
    }

    public String getProperty(String propname) throws IllegalStateException {
        Object propValue = this.getFO().getAttribute(propname);
        return propValue == null ? null : propValue.toString();
    }

    public Enumeration propertyNames() throws IllegalStateException {
        return this.getFO().getAttributes();
    }

    public void setProperty(String propname, String value) throws IllegalStateException {
        try {
            String oldValue = this.getProperty(propname);
            this.getFO().setAttribute(propname, (Object)value);
            this.firePropertyChange(new PropertyChangeEvent(this, propname, oldValue, value));
        }
        catch (IOException ioe) {
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url)), (Throwable)ioe);
        }
    }

    public void setProperties(Properties props) throws IllegalStateException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            this.setProperty(propName, propValue);
        }
    }

    public DeploymentManager getDeploymentManager() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        return inst.getDeploymentManager();
    }

    public Target getDefaultTarget() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerString ss = registry.getDefaultInstance();
        Target[] targets = ss.toTargets();
        if (targets != null && targets.length > 0) {
            return targets[0];
        }
        return null;
    }

    public void setAsDefaultServer(String targetName) {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        ServerString server = new ServerString(inst, targetName);
        registry.setDefaultInstance(server);
    }

    public boolean isDefaultInstance() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerString ss = registry.getDefaultInstance();
        return ss.getUrl().equals(this.url);
    }

    public void refreshServerInstance() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        if (inst != null) {
            inst.refresh();
        }
    }
}

